//==========================================================================
//
//	title		: define functions to effect
//	company		: YAMAHA
//	author		: Taichi Sugiyama
//	create Data : 30/Sep/99
//
//==========================================================================
#include "define.h"


#ifdef TRACE_EFFPROC
#define	DPF(X)		cprintf("TRACE_EFFPROC:");cprintf X
#define	dprintf(X)	cprintf X
#else
#define	DPF(X)
#define	dprintf(X)
#endif


//==========================================================================
//	setup Effect bank register
//
//	argument
//		phwi	: pointer to hardware information
//
//	return
//
//==========================================================================
void	SetupEffBankRegister(PHWINFO phwi)
{
	DWORD	i, j;


	DPF(("SetupEffBankRegister")); 

	//	set bank1 & bank2
	for(j=0; j<DEF_MAXEFF; j++) {
		for(i=0; i<2; i++) {
			phwi->effinfo[j].lpEffBank[i]->dwPgBase = phwi->dwEffBuffBase;
			phwi->effinfo[j].lpEffBank[i]->dwPgLoopEndAdr = phwi->dwEffBuffByteSize >> 1;
			phwi->effinfo[j].lpEffBank[i]->dwPgStartAdr = 0x00000000;
			phwi->effinfo[j].lpEffBank[i]->dwTemp = 0x00000000;
		}
	}

	dprintf(("/End\n\r"));
}