// This Code is for hardware function demonstration purposes only
// Leipzig 02-19-98 (c) 1998 marian GbR Leipzig

{ To load the FPGA: FIRST reset the Card, then call WriteConfigData }
const
  MaxSize      = 55000;

procedure ResetCard; Assembler;
ASM
        mov     EDI,[EDX+TCard.PCI]          ; EDI = Adsress of PCI Registers
        add     EDI,50h                      ; EDI = Address of Register 50h
        mov     EAX,[EDI]                    ; EAX = Value of Register 50h

        or      EAX,40000000h                ; Set Reset Bit
        mov     [EDI],EAX                    ; Put it out

        and     EAX,0BFFFFFFFh               ; Reset the Reset Bit
        mov     [EDI],EAX                    ; Put it out
end;

{ Card^.BaseAdr^ = FPGA Base Address at the Card
  Rbt^.Data      = Pointer to Memory Range with loaded Configuration Data (.RBT - File)
  Rbt^.Len       = Length of Configuration Data
}
procedure WriteConfigData (Card : PCard; Rbt : PRbt);
var
  i    : LongInt;
  Base : Word;
begin
  for i := 0 to Rbt^.Len-1 do
  begin
    Case Rbt^.DataLin[i] of
      '0' : DWORD (Card^.BaseAdr^) := $fffffffe;
      '1' : DWORD (Card^.BaseAdr^) := $ffffffff;
    end;
  end;
 { !! 5 ms Delay !!! }
end;


