//*****************************************************************************
//* Name:
//*      1212wave.h
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file contains private declarations for the implementation of the
//*      Win16 application to Korg1212 VxD interface.
//*
//* Modification Log:
//*
//*      1.5   08/20/97 Bill
//*      (v1.0B6) Added K1212SetAutoWaveSync() declarations.
//*
//*      1.4   07/09/97 Bill
//*      (v1.0B4) Added ResetWaveInDevice() and ResetWaveOutDevice() declarations.
//*      These will be used by the ISR to clean up if the card is stopped due to
//*      an error.
//*
//*      1.3   06/09/97 Bill
//*      (v1.08) Added K1212BreakLoop() declaration.
//*
//*      1.2   06/03/97 Bill
//*      (v1.05) Added K1212PostMessageToFile() declaration.
//*
//*      1.1   03/13/97 Bill
//*      Initial version.  
//*
//*
//* Copyright (c) 1997 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#ifndef K1212WAVE_H
#define K1212WAVE_H

#ifndef  K1212WAVEAPI_H
#include "1212WaveApi.h"
#endif
#ifndef  K1212WAVESTRUCT_H
#include "1212wavestruct.h"
#endif

// ------------------------------------------------------------------------
// function declarations implemented by the wave device API
// ------------------------------------------------------------------------
DWORD FramesPerSample
(
   K1212WaveFormat format
);
void WaveDeviceFillRoutine
(
   WORD  cardIndex
);
void K1212EnableWaveInputDevices
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212DisableWaveInputDevices
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212EnableWaveOutputDevices
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212DisableWaveOutputDevices
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212OpenWaveInputDevice
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212CloseWaveInputDevice
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212OpenWaveOutputDevice
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212CloseWaveOutputDevice
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212CheckInputFormat
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212CheckOutputFormat
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212AddRecordBuffer
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212AddPlayBuffer
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212StartWaveInDevice
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212StopWaveInDevice
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void FinishWaveInStop
(
   WORD               cardIndex,
   WORD               deviceId,
   k1212WaveInDevice* waveInDevPtr
);
void K1212PauseWaveOutDevice
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212ResumeWaveOutDevice
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212ResetWaveDevice
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212BreakLoop              // v1.08
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212SetWaveOutDeviceVolume
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212QueryWaveOutDeviceMute
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212MuteWaveOutDevice
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212UnmuteWaveOutDevice
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212GetWaveOutDeviceVolume
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212GetWavePosition
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
void K1212PostMessageToFile
(
   k1212PMIn*  reqInputBufPtr,
   k1212PMOut* reqOutputBufPtr
);
K1212CmdRet disableWaveVolControl
(
   DWORD          cardIndex,
   WORD           deviceId
);
K1212CmdRet enableWaveVolControl
(
   DWORD          cardIndex,
   WORD           deviceId
);
K1212CmdRet getWaveVolEnaFlag
(
   DWORD          cardIndex,
   WORD           deviceId,
   BOOL*          boolPtr
);
K1212CmdRet setWaveDevSyncFlag
(
   DWORD                cardIndex,
   K1212WaveDeviceType  deviceType,
   DWORD                deviceId,
   DWORD                newSetting
);
K1212CmdRet getWaveDevSyncFlag
(
   DWORD                cardIndex,
   K1212WaveDeviceType  deviceType,
   DWORD                deviceId,
   DWORD*               valPtr
);
K1212CmdRet getWaveVolume
(
   DWORD           cardIndex,
   WORD            deviceId,
   k1212LeftRight* lrValsPtr
);
K1212CmdRet setWaveVolume
(
   DWORD           cardIndex,
   k1212WaveVolume waveVol
);
BOOL ResetWaveInDevice
(
   WORD      cardIndex,
   WORD      deviceId
);
BOOL ResetWaveOutDevice
(
   WORD      cardIndex,
   WORD      deviceId
);
K1212CmdRet K1212SetAutoWaveSync
(
   DWORD     cardIndex,
   BOOL      newSetting
);


// ------------------------------------------------------------------------
// function declarations implemented by the native API, but
// needed by the wave device API.
// ------------------------------------------------------------------------
BOOL  K1212TriggerPlay
(
   DWORD cardIndex
);
BOOL  K1212TriggerPlayFromAdat
(
   DWORD             cardIndex,
   DWORD             timecodeVal,
   StopModeSelector  stopModeSel
);
BOOL  K1212SetupForPlay
(
   DWORD cardIndex
);
BOOL  K1212StopPlay
(
   DWORD cardIndex
);
BOOL  K1212CloseCard
(
   DWORD cardIndex
);
BOOL  K1212OpenCard
(
   DWORD     cardIndex,
   APIHandle apiHandle
);

#endif // K1212WAVE_H
