//*****************************************************************************
//* Name:
//*      1212cfg.c
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file processes configuration control messages for the 1212 I/O 
//*      and all other driver requests.
//*
//* Routines defined:
//*      Korg1212_ConfigHandler().
//*
//* Modification Log:
//*
//*      1.1   11/14/96 Bill
//*      Initial version created.  
//*
//*
//* Copyright (c) 1996 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#include <vtoolsc.h>
#include <vmm.h>
#include <debug.h>
#include <vmmreg.h>
#include <configmg.h>

#ifndef  K1212CARD_H
#include "1212card.h"      // public card configuration function declarations
#endif
#ifndef  K1212CFG_H
#include "1212cfg.h"       // private card configuration function declarations
#endif
#ifndef  K1212CM_H
#include "1212cm.h"        // contains config manager function declaration for the card
#endif
#ifndef  K1212PCI_H
#include "1212pci.h"       // needed for accessing the PCI configuration space
#endif


#pragma warning (disable:4100)   // Parameter unused

DEBUG_CONFIG_NAMES;

//*************************************************************************
//*
//* K1212io_ConfigHandler - Handler of the config manager config call
//* 
//* Exported.
//*
//* ENTRY:   Standard config handler.
//*
//* EXIT:    Standard config manager return value.
//*
//*************************************************************************

CONFIGRET CM_HANDLER
Korg1212_ConfigHandler(CONFIGFUNC     cfFuncName, 
                       SUBCONFIGFUNC  scfSubFuncName, 
                       DEVNODE        devNode, 
                       DWORD          dwRefData, 
                       ULONG          ulFlags)
{
   CONFIGRET returnCode;

   PCI_CONFIG_HEADER_0 pciConfigSpace;
   
   switch (cfFuncName) {

      // ---------------------------------------------------------------------
      // for the CONFIG_START case, we find and store the card's resource 
      // configuration information, allocate the audio buffers for the card,
      // 
      // ---------------------------------------------------------------------
      case CONFIG_START:

         #ifdef DEBUG
            Debug_Printf_Service("Korg 1212 Driver: Received Config Start message\n");
         #endif // DEBUG

         // ----------------------------------------------------------------
         // get the PCI configuration space, and make sure the command
         // register has the bus master bit enabled.
         // ----------------------------------------------------------------
         GetPCIConfigData(devNode,                 // our device
                          0,                       // start at offset 0
                          (DWORD*)&pciConfigSpace, // pointer to receiving buffer
                          pciConfigSpaceSize       // get the whole thing
         );

         pciConfigSpace.Command = (PCI_CMD_MEM_SPACE_ENABLE_BIT |
                                   PCI_CMD_BUS_MASTER_ENABLE_BIT);
                                   
         SetPCIConfigData(devNode,                 // our device
                          0,                       // start at offset 0
                          (DWORD*)&pciConfigSpace, // pointer to receiving buffer
                          pciConfigSpaceSize       // set the whole thing
         );

         // ----------------------------------------------------------------
         // configure the card.
         // ----------------------------------------------------------------
         returnCode = startConfiguration(devNode);

         #ifdef DEBUG
         if (returnCode != CR_SUCCESS) {
            Debug_Printf_Service("Korg 1212 Driver: I/O startConfiguration failed.\n");
            return returnCode;         
         }
         else {
            // ----------------------------------------------------------------
            // now see what the PCI configuration space reports
            // ----------------------------------------------------------------
//            PrintPCIConfigData(pciConfigSpace);
         }
         #endif // DEBUG

         return(returnCode);


      case CONFIG_TEST:
         #ifdef DEBUG
            Debug_Printf_Service("Korg 1212 Driver: Received Config Test message\n");
         #endif // DEBUG
         return(CR_SUCCESS);

      case CONFIG_STOP:
         #ifdef DEBUG
            Debug_Printf_Service("Korg 1212 Driver: Received Config Stop message\n");
         #endif // DEBUG
         returnCode = stopConfiguration(devNode);
         return(returnCode);

      case CONFIG_REMOVE:
         #ifdef DEBUG
            Debug_Printf_Service("Korg 1212 Driver: Received Config Remove message\n");
         #endif // DEBUG
         // deallocate per instance data.
         returnCode = stopConfiguration(devNode);
         return(returnCode);

      case CONFIG_SHUTDOWN:
         #ifdef DEBUG
            Debug_Printf_Service("Korg 1212 Driver: Received Config Shutdown message\n");
         #endif // DEBUG
         // deallocate per instance data.
         returnCode = stopConfiguration(devNode);
         return(returnCode);

      default:
         #ifdef DEBUG
            if (cfFuncName < NUM_CONFIG_COMMANDS) {
               Debug_Printf_Service("Korg 1212 Driver: Unsupported Config message - %s\n",
                                    lpszConfigName[cfFuncName]
               );
            }
            else {
               Debug_Printf_Service("Korg 1212 Driver: Unsupported Config message - 0x%x\n",
                                    cfFuncName
               );
            }
         #endif // DEBUG
         return(CR_DEFAULT);
   }
}

#pragma warning (default:4100)      // Parameter unused



