//---------------------------------------------------------------------------
//
//  Module:   cnfgmgr.h
//
//  Description:
//
//
//---------------------------------------------------------------------------
//
//  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
//  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
//  PURPOSE.
//
//  Copyright (c) 1994 - 1995 Microsoft Corporation.	All Rights Reserved.
//
//---------------------------------------------------------------------------

#define QUOTE(x) #x
#define QQUOTE(y) QUOTE(y)
#define REMIND(str) __FILE__ "(" QQUOTE(__LINE__) ") : " str


// Sturctures for bankGetCaps API
typedef struct sSoundDef {
	char Name[16];
	DWORD Prio;
	DWORD Size;
	DWORD SBnb;
	} SOUNDDEF, *LPSOUNDDEF;

typedef struct sBankCaps {
	DWORD TotalSize;
	DWORD FreeSize;
	DWORD	BanksNb;
	SOUNDDEF SBankDef[8];
	} BANKCAPS, *LPBANKCAPS;


// external function prototypes

CONFIGRET DREAM_Set_Config
(
    DWORD           dn,
    WORD            wBaseMPU401,
    WORD            wIRQ,
	WORD			DreamCard
) ;

VOID DREAM_Remove_Config
(
    DEVNODE         dn
) ;

BOOL DREAM_IsOwned
(
    DEVNODE         dn
) ;



// Dream Error Codes
#define DREAMERR_UNREF		1
#define DREAMERR_OUTOFMEM	2
#define DREAMERR_INVADD     3
#define DREAMERR_INVCOUNT	4
#define DREAMERR_ABORT		5
#define DREAMERR_NOTSUPPORTED		6
#define DREAMERR_INVCOM		7    
#define DREAMERR_FILE_NOT_FOUND	8 
#define	DREAMERR_CANNOTDELETE	9

//*********** DREAM functions *****************
//
//	startup.asm

void SendCrystal(BYTE data);

//		files function

DWORD cOpen(DWORD FileName, WORD FileSeg);
BOOL cRead(DWORD handle, DWORD buffer, DWORD BytesNumber);
DWORD cSeek(DWORD handle, DWORD offset, BYTE Method);
BOOL cClose(DWORD handle);
DWORD GetTime();
void RemModPostFX(WORD wBaseMPU401);

// validata.asm
void WriteP16(WORD wMpuAdd, BYTE bData, WORD Offset);
DWORD MPU401_Command_Read(WORD wMpuAdd);

// cnfgmgr.c
BOOL run94init(WORD wBaseMPU401);



//---------------------------------------------------------------------------
//  End of File: cnfgmgr.h
//---------------------------------------------------------------------------
