        page    60, 132

;******************************************************************************
        title   API.ASM - Ring 3 Driver Interfaces
;******************************************************************************
;  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
;  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
;  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
;  PURPOSE.
;
;  Copyright (c) 1994 - 1995 Microsoft Corporation.	All Rights Reserved.
;******************************************************************************
;
;   Title:    DREAM.386 - MICROSOFT MPU-401 386 Driver
;
;   Module:   API.ASM - Application Programming Interface
;
;   Version:  4.00
;******************************************************************************
;
;   Functional Description:
;      Provides V86/PM API for DOS apps or Windows driver.
;
;******************************************************************************

        .386p

;==============================================================================
;                             I N C L U D E S
;==============================================================================

        .xlist
        include vmm.inc
        include debug.inc
        include shell.inc
        include dreamvxd.inc
        include equates.inc
        .list

EXTRN ghlMSMI:DWORD                              ; MPU401 Info list
EXTRN _BkCaps : DWORD

EXTRN DREAM_Acquire:NEAR
EXTRN DREAM_Release:NEAR

EXTRN _vxdAlloc:NEAR 
EXTRN _vxdFree:NEAR  
EXTRN _vxdLoadSB:NEAR  
EXTRN _vxdLoadFW:NEAR
EXTRN _bankGetCaps:NEAR  
EXTRN _DelSoundBank:NEAR  
EXTRN _bankSetPriority:NEAR
EXTRN _Change3DPrimaryVolume:NEAR
EXTRN _cvReInit:NEAR

EXTRN _DrvOwn:WORD
      
;==============================================================================
;                       P A G E A B L E   D A T A
;==============================================================================

VxD_PAGEABLE_DATA_SEG

;------------------------------------------------------------------------------
;                 A P I   D I S P A T C H   T A B L E
;------------------------------------------------------------------------------
dwAddress	dd	0ffffffffh			; to store address return by vxdAlloc


DREAM_API_TABLE LABEL DWORD
        dd  OFFSET32 API_Get_Version
        dd  OFFSET32 MPU401_API_Get_Info
        dd  OFFSET32 MPU401_API_Acquire
        dd  OFFSET32 MPU401_API_Release
		dd	OFFSET32 API_Cv_Fw
		dd	OFFSET32 API_Dummy
DREAM_API_MAX       equ ($-DREAM_API_TABLE)/4

DREAM_9407_TABLE LABEL DWORD
        dd  OFFSET32 API_Mem_Alloc   
        dd  OFFSET32 API_Mem_Free       
        dd  OFFSET32 API_Load_Sb     
        dd  OFFSET32 API_Load_Fw
		dd  OFFSET32 API_Del_Sb
		dd  OFFSET32 API_Change_Prio
		dd  OFFSET32 API_Get_Caps
		dd	OFFSET32 API_DS_Vol
DR9407_API_MAX       equ ($-DREAM_9407_TABLE)/4

DREAM_Func_Tables LABEL DWORD
        dd  1,                  OFFSET32 DREAM_API_Table
        dd  DR9407_API_MAX,                  OFFSET32 DREAM_9407_TABLE
        dd  0,                  OFFSET32 DREAM_API_Fail
        dd  DREAM_API_MAX,   OFFSET32 DREAM_API_Table
DREAM_FUNC_HANDLERS_MAX equ ($-DREAM_Func_Tables)/8

VxD_PAGEABLE_DATA_ENDS

;==============================================================================
;                        P A G E A B L E   C O D E
;==============================================================================

VxD_PAGEABLE_CODE_SEG

;---------------------------------------------------------------------------;
;
;   DREAM_API_Handler
;
;   DESCRIPTION:
;       This is the single entry point for a VM (pmode or rmode) to make
;       the SB16 driver's life easier
;
;   ENTRY:
;       EBX = Current VM Handle
;       EBP = Pointer to Client Register Structure.
;
;       Client_DX = Function number
;
;       And API specific Client_?? registers.
;
;   EXIT:
;       Client_EFLAGS _PLUS_ any API specific Client_?? registers.
;
;   USES:
;       FLAGS
;
;---------------------------------------------------------------------------;

BeginProc DREAM_API_Handler, PUBLIC


        movzx   eax, [ebp.Client_DX]
        cmp     ah, DREAM_FUNC_HANDLERS_MAX
        jae     SHORT DREAM_API_Fail
        movzx   ecx, ah
        shl     ecx, 3
        lea     ecx, DREAM_Func_Tables[ ecx ]
        movzx   eax, al
        cmp     eax, dword ptr [ecx]
        jae     SHORT DREAM_API_Fail
        mov     ecx, dword ptr [ecx + 4]
        call    dword ptr [ecx][eax * 4]
        jc      SHORT DREAM_API_Fail

DREAM_API_Success:
        and     [ebp.Client_Flags], not CF_Mask ; clear carry
		ret

DREAM_API_Fail:
        or      [ebp.Client_Flags], CF_Mask     ; set carry
        ret

EndProc DREAM_API_Handler

BeginDoc
;---------------------------------------------------------------------------;
;
;   API_Get_Version, PMAPI, RMAPI
;
;   DESCRIPTION:
;       Version call for API entry point
;
;   ENTRY:
;       EBX = Current VM Handle
;       EBP = Pointer to Client Register Structure.
;
;       Client_DX = DREAM_API_Get_Version (0)
;
;   EXIT:
;       Client_EFLAGS = carry clear
;       Client_AX = Version
;
;   USES:
;       FLAGS, EAX
;
;---------------------------------------------------------------------------;
EndDoc
BeginProc API_Get_Version

        Assert_Client_Ptr ebp

        cCall   DREAM_Get_Version              ; get version in EAX
        mov     [ebp.Client_AX], ax             ; dump it in client's AX
        clc
        ret

EndProc API_Get_Version


BeginDoc
;---------------------------------------------------------------------------;
;
;   MPU401_API_Acquire, PMAPI, RMAPI
;
;   DESCRIPTION:
;       Assigns ownership of MPU401 to a VM
;
;   ENTRY:
;       EBX = Current VM Handle (VM to assign ownership to)
;       EBP = Pointer to Client Register Structure.
;
;       Client_AX = MPU401 base port to acquire
;       Client_DX = DREAM_API_Acquire
;
;   EXIT:
;       Carry clear if no error, set otherwise
;
;       IF Client_EFLAGS = carry clear
;           success, ownership assigned
;       ELSE Client_EFLAGS = carry set
;           fail, Client_AX is error code:
;
;           DREAM_API_Err_Bad_Base_Port
;               The base port given is not virtualized by this VxD.
;
;           DREAM_API_Err_Already_Owned 
;               The hardware is currently owned by another VM.
;
;   USES:
;       Flags, EAX, EDX, ESI
;
;---------------------------------------------------------------------------;
EndDoc
BeginProc MPU401_API_Acquire

        Assert_Client_Ptr ebp

        movzx   edx, [ebp.Client_AX]            ; MPU401 base in EDX

        Trace_Out "DREAM: DREAM_API_Acquire: IOAddress=#DX"

        or      edx, edx 
        jz      SHORT MMA_Bad_Port_Exit

        cCall   _DREAM_Get_pMSMI_From_XXX, <edx, pMSMI_FromMPU401>
        or      edi, edi                        ; Q: valid base port?
        jz      SHORT MMA_Bad_Port_Exit         ;    N: fail

        mov     ecx, [edi.msmi_dwMPU401OwnerLast]

        ;
        ; EAX = flags
        ; EBX = VM handle to own MPU401
        ; ECX = Last owner
        ; EDX = MPU401 base to acquire
        ; EDI = pMSMI
        ;

        mov     [ebp.Client_AX], 0              ; assume success
        call    DREAM_Acquire                ; assign ownership
        jc      SHORT MMA_Already_Owned
		
		; Owned by driver
		mov	[_DrvOwn], 1

        ret

MMA_Already_Owned:
        mov     [ebp.Client_AX], DREAM_API_Err_Already_Owned
        jmp     SHORT MMA_Error_Exit

MMA_Bad_Port_Exit:
        mov     [ebp.Client_AX], DREAM_API_Err_Bad_Base_Port
        Debug_Out "DREAM: DREAM_API_Acquire: bad base port address--failing!"

MMA_Error_Exit:
        Debug_Out "DREAM: DREAM_API_Acquire: Failing..."
        stc
        ret

EndProc MPU401_API_Acquire

BeginDoc
;---------------------------------------------------------------------------;
;
;   MPU401_API_Release, PMAPI, RMAPI
;
;   DESCRIPTION:
;       Releases ownership of an owned MPU401 so other VM's can use it.
;       Only the current owning VM can release the MPU401.
;
;   ENTRY:
;       EBX = Current VM Handle (VM to release ownership)
;       EBP = Pointer to Client Register Structure.
;
;       Client_AX = MPU401 base port to release
;       Client_DX = DREAM_API_Release
;
;   EXIT:
;       Carry clear if no error, set otherwise
;
;       IF Client_EFLAGS = carry clear
;           success, ownership released
;       ELSE Client_EFLAGS = carry set
;           fail, Client_AX is error code:
;
;           DREAM_API_Err_Bad_Base_Port
;               The base port given is not virtualized by this VxD.
;
;           DREAM_API_Err_Not_Yours
;               The MPU401 is NOT owned by caller's VM.
;
;   USES:
;       Flags, EAX, EDX, ESI
;
;---------------------------------------------------------------------------;
EndDoc
BeginProc  MPU401_API_Release

        Assert_Client_Ptr ebp

        movzx   edx, [ebp.Client_AX]            ; MPU401 base in EDX

        Trace_Out "DREAM: DREAM_API_Release: IOAddress=#DX"

        or      edx, edx
        jz      SHORT MMR_Bad_Port_Exit

        cCall   _DREAM_Get_pMSMI_From_XXX, <edx, pMSMI_FromMPU401>
        or      edi, edi                        ; Q: valid base port?
        jz      SHORT MMR_Bad_Port_Exit         ;    N: fail

        mov     ecx, [edi.msmi_dwMPU401OwnerCur]

        cmp     ecx, ebx                        ; Q: is MPU401 owned by VM?
        je      SHORT MMR_Release               ;   Y: then release it

        ;
        ; Currently owned by another VM (or not owned).
        ;

        mov     [ebp.Client_AX], DREAM_API_Err_Not_Yours
        jmp     SHORT MMR_Error_Exit

        ;
        ; EAX = flags
        ; EBX = VM handle to release
        ; ECX = current owning VM of hardware
        ; EDX = SS base to release
        ;

MMR_Release:
        call    DREAM_Release                ; release ownership

        mov     [ebp.Client_AX], 0              ; success
        clc
		; not Owned by driver
		mov	[_DrvOwn], 0
        ret

MMR_Bad_Port_Exit:
        mov     [ebp.Client_AX], DREAM_API_Err_Bad_Base_Port

MMR_Error_Exit:
        stc           
        ret

EndProc MPU401_API_Release

BeginDoc
;---------------------------------------------------------------------------;
;
;   MPU401_Get_Info, PMAPI, RMAPI
;
;   DESCRIPTION:
;       This function is used to get information about the Synthesis
;       support of this VxD.
;
;   ENTRY:
;       Client_ES = selector/segment of DREAMINFO structure
;       Client_BX = offset of DREAMINFO structure
;       Client_AX = flags
;           DREAM_API_GetInfoF_DevNode specifies the devnode used to
;           retrieve information.  This flag must be specified, all
;           others are invalid.
;
;       Client_ECX = DevNode
;
;   EXIT:
;       IF carry clear
;           success
;           Client_AX = non-zero
;           Client_ES:BX ->filled in DREAMINFO structure
;       ELSE carry set
;           Client_AX = 0
;
;   USES:
;       Flags, EAX, EBX, ECX, ESI, EDI
;
;---------------------------------------------------------------------------;
EndDoc
BeginProc MPU401_API_Get_Info

        pushfd

        Assert_Client_Ptr ebp

        Trace_Out "DREAM: DREAM_API_Get_Info"

        mov     ax, [ebp.Client_AX]
        cmp     ax, DREAM_API_GetInfoF_DevNode
        jne     SHORT MAGI_Exit_Failure

        mov     ecx, [ebp.Client_ECX]
        Trace_Out "DREAM: DREAM_API_Get_Info: specified devnode #ECX"
        
MAGI_No_DevNode:
        cli
        mov     esi, ghlMSMI 
        or      esi, esi
        jz      SHORT MAGI_Exit_Failure
        VMMCall List_Get_First
        jz      SHORT MAGI_Exit_Failure

MAGI_Get_DevNode:
        mov     edi, [eax.hwl_pMSMI]
        cmp     [edi.msmi_dn], ecx
        je      SHORT MAGI_Got_DevNode
        VMMCall List_Get_Next
        jz      SHORT MAGI_Exit_Failure
        jmp     SHORT MAGI_Get_DevNode

MAGI_Got_DevNode:
        popfd
        pushfd
        mov     esi, edi
        Client_Ptr_Flat edi, ES, BX
        cmp     edi, -1
        je      SHORT MAGI_Exit_Failure

        ;
        ; Check the DREAMINFO structure size if too big, fail.
        ; If too small, assume we've added information to the
        ; structure, and this app doesn't recognize it - only
        ; copy what they've asked for...
        ;

        mov     ecx, [edi]
        or      ecx, ecx
        jz      SHORT MAGI_Exit_Failure
        cmp     ecx, (size DREAMINFO)
        ja      SHORT MAGI_Exit_Failure

        mov     [edi.msmi_wHardwareOptions], 0
        mov     ax, [esi.msmi_wIOAddressMPU401]
        mov     [edi.msmi_wIOAddressMPU401], ax
        mov     al, [esi.msmi_bIRQ]
        mov     [edi.msmi_bIRQ], al
        mov     eax, [esi.msmi_dn]
        mov     [edi.msmi_dn], eax

        mov     [ebp.Client_AX], 1          ; success
        popfd
        clc
        ret

MAGI_Exit_Failure:

        Debug_Out "DREAM: DREAM_API_Get_Info: function FAILED!!"
        mov     [ebp.Client_AX], 0          ; failed
        popfd
        stc
        ret

EndProc MPU401_API_Get_Info


;		API 9407

BeginDoc
;---------------------------------------------------------------------------;
;
;   API_Mem_Alloc, PMAPI, RMAPI
;
;   DESCRIPTION:
;       This function is used to allocate a memory space in the 9407 memory
;
;   ENTRY:
;		Client_AX +
;       Client_BX = Size of the block to reserve
;       Client_CX= Type of the block to reserve
;          
;
;   EXIT:
;       IF carry clear
;           success
;           Client_DX+Client_AX = Address of the reserved block
;			Client_CX = 0
;       ELSE carry set
;           Client_DX=Client_AX = ffffh
;			Client_CX = Error code (cf. dream.h)
;
;   USES:
;       Flags, all registers
;
;---------------------------------------------------------------------------;
BeginProc API_Mem_Alloc

        Assert_Client_Ptr ebp   
		xor		eax, eax
		mov     ax, [ebp.Client_CX]
		mov     bx, [ebp.Client_AX]
		shl		ebx, 16
		mov     bx, [ebp.Client_BX]   
		cCall _vxdAlloc, <ebx, eax,OFFSET32 dwAddress>
        mov     [ebp.Client_CX], ax             ; return value
		or		ax, ax
		jnz		ma_error  
		mov		edx, [dwAddress]
		mov		ax, dx
		shr		edx, 16
		mov		[ebp.Client_DX], dx			; no error , edx<-- Address
		mov		[ebp.Client_AX], ax			; no error , edx<-- Address
		clc
		jmp		ma_Exit
ma_error:
		mov		[ebp.Client_DX],0ffffh
		mov		[ebp.Client_AX],0ffffh
        stc
ma_Exit:
        ret

EndProc API_Mem_Alloc   


BeginDoc
;---------------------------------------------------------------------------;
;
;   API_Mem_Free, PMAPI, RMAPI
;
;   DESCRIPTION:
;       This function is used to free a memory space in the 9407 memory
;
;   ENTRY:
;		Client_AX +
;       Client_BX = Address of the block to free
;          
;
;   EXIT:            
;		Client_AX=error code if failed
;		Client_AX=0 if succeed
;
;   USES:
;       Flags, all registers
;
;---------------------------------------------------------------------------;
BeginProc API_Mem_Free

        Assert_Client_Ptr ebp
		mov     bx, [ebp.Client_AX]
		shl		ebx, 16
		mov     bx, [ebp.Client_BX]
		cCall _vxdFree, <ebx>
        mov     [ebp.Client_AX], ax             ; return value
        ret

EndProc API_Mem_Free

BeginDoc
;---------------------------------------------------------------------------;
;
;   API_Load_Sb, PMAPI, RMAPI
;
;   DESCRIPTION:
;       This function is used to load o sound bank in 9407 board.
;
;   ENTRY:
;		Client_ES +
;       Client_DI = Pointer on the sound bank file (.94b) name.
;          
;
;   EXIT:            
;		Client_AX=error code if failed
;		Client_AX=0 if succeed
;
;   USES:
;       Flags, all registers
;
;---------------------------------------------------------------------------;
BeginProc API_Load_Sb

        Assert_Client_Ptr ebp
        xor		eax, eax
        mov		ebx, eax
		mov     bx, [ebp.Client_ES]
		mov     ax, [ebp.Client_DI]
		cCall _vxdLoadSB, <eax, ebx>
        mov     [ebp.Client_AX], ax             ; return value
        ret

EndProc API_Load_Sb


BeginDoc
;---------------------------------------------------------------------------;
;
;   API_Load_Fw, PMAPI, RMAPI
;
;   DESCRIPTION:
;       This function is used to load a new firmware in 9407 board.
;
;   ENTRY:
;		Client_ES +
;       Client_DI = Pointer on the firmware file (.bin) name.
;          
;
;   EXIT:            
;		Client_AX=error code if failed
;		Client_AX=0 if succeed
;
;   USES:
;       Flags, all registers
;
;---------------------------------------------------------------------------;
BeginProc API_Load_Fw

        Assert_Client_Ptr ebp
        xor		eax, eax
        mov		ebx, eax
		mov     bx, [ebp.Client_ES]
		mov     ax, [ebp.Client_DI]
		cCall _vxdLoadFW, <eax, ebx>
        mov     [ebp.Client_AX], ax             ; return value
        ret

EndProc API_Load_Fw


BeginDoc
;---------------------------------------------------------------------------;
;
;   API_Cv_Fw, PMAPI, RMAPI
;
;   DESCRIPTION:
;       This function is used by CV97 to load a init firmware & Sound Bank
;
;
;   EXIT:            
;		Client_AX=error code if failed
;		Client_AX=0 if succeed
;
;
;---------------------------------------------------------------------------;
BeginProc API_Cv_Fw

		cCall _cvReInit
        mov     [ebp.Client_AX], ax             ; return value
        ret

EndProc API_Cv_Fw

BeginDoc
;---------------------------------------------------------------------------;
;
;   API_Dummy, PMAPI, RMAPI
;
;   DESCRIPTION:
;       This function is used by CV97.
;
;---------------------------------------------------------------------------;
BeginProc API_Dummy

        ret

EndProc API_Dummy


BeginDoc
;---------------------------------------------------------------------------;
;
;   API_Del_Sb, PMAPI, RMAPI
;
;   DESCRIPTION:
;       This function is used to unload a sb from 9407 board.
;
;   ENTRY:
;		Client_AX = Sound Bank Number
;          
;
;   EXIT:            
;		Client_AX=error code if failed
;		Client_AX=0 if succeed
;
;   USES:
;       Flags, all registers
;
;---------------------------------------------------------------------------;
BeginProc API_Del_Sb

        Assert_Client_Ptr ebp
		Trace_Out "Unload API"
		xor		eax, eax
		mov     ax, [ebp.Client_AX]
		cCall _DelSoundBank, <eax>
        mov     [ebp.Client_AX], ax             ; return value
	    ret

EndProc API_Del_Sb

BeginDoc
;---------------------------------------------------------------------------;
;
;   API_Change_Prio, PMAPI, RMAPI
;
;   DESCRIPTION:
;       This function is used to change the priority of a sb in memory.
;
;   ENTRY:
;		Client_AX = Sound Bank Number
;		Client_BX = Priority to set
;          
;
;   EXIT:            
;		Client_AX=error code if failed
;		Client_AX=0 if succeed
;
;   USES:
;       Flags, all registers
;
;---------------------------------------------------------------------------;
BeginProc API_Change_Prio

        Assert_Client_Ptr ebp
		xor		eax, eax
		mov		ebx, eax
		mov     ax, [ebp.Client_AX]
		mov     bx, [ebp.Client_BX]

		cCall _bankSetPriority, <eax, ebx>
        mov     [ebp.Client_AX], ax             ; return value
        ret

EndProc API_Change_Prio

BeginDoc
;---------------------------------------------------------------------------;
;
;   API_Get_Caps, PMAPI, RMAPI
;
;   DESCRIPTION:
;       This function is used to change the priority of a sb in memory.
;
;   ENTRY:
;		Client_ES +
;       Client_DI = Pointer on the BANKCAPS structure
;
;   EXIT:            
;		Client_AX=error code if failed
;		Client_AX=0 if succeed
;
;   USES:
;       Flags, all registers
;
;---------------------------------------------------------------------------;
BeginProc API_Get_Caps

        Assert_Client_Ptr ebp
		Trace_Out "enter asm"
		
		cCall _bankGetCaps
        mov     [ebp.Client_AX], ax             ; return value
		cmp		ax, 0
		jnz		gtExit
		mov		edi, 0
		push	es
		mov		es,[ebp.Client_ES]
		mov     di, [ebp.Client_DI]
		lea		esi, _BkCaps
		mov		ecx, 76h
	rep	movsw
		pop		es
gtExit:
		Trace_Out "ret"
		ret

EndProc API_Get_Caps



;---------------------------------------------------------------------------;
;
;   API_DS_Vol, PMAPI, RMAPI
;
;   DESCRIPTION:
;       This function is used to check if DSound is running and change primary volume
;
;   ENTRY:
;		Client_AX=Volume. (If Volume>0xff, no volume to apply).
;		Client_BX=BaseAddress
;
;   EXIT:            
;		Client_AX=0 if DirectSound is running
;				 1 if not
;   USES:
;       Flags, all registers
;
;---------------------------------------------------------------------------;
BeginProc API_DS_Vol

        Assert_Client_Ptr ebp
		Trace_Out "API_DS_Vol"
		
		xor		eax, eax
		mov		ax, [ebp.Client_BX]
		cCall   _DREAM_Get_pMSMI_From_XXX, <eax, pMSMI_FromMPU401>
        or      edi, edi
        jz      SHORT NoDirectSound

		mov     ax, [edi.msmi_DsRunning]
        or      ax, ax                        ; Q: is Direct Sound running?
        jz     SHORT NoDirectSound				    ;   N 
		
		; Direct Sound enabled
		xor		eax, eax
		mov		ax, [ebp.Client_AX]		; Volume
		cmp		ax, 0ffh
		ja		DirectSound				; no volume set required
		; 
		cCall	_Change3DPrimaryVolume, <eax>

		jmp		DirectSound

NoDirectSound:
		mov     [ebp.Client_AX], 1             ; no Direct Sound (Default)
		Trace_Out "ret"
		ret

DirectSound:
		mov     [ebp.Client_AX], 0             ; Direct Sound enabled
		Trace_Out "ret"
		ret
EndProc API_DS_Vol


VxD_PAGEABLE_CODE_ENDS

end
