// mixer driver data
int mixerNb;
MIXERCAPS MixCaps;
HMIXER hmx[8];
UINT uMxId=0;
int midiInNb;
int midiOutNb;
int waveInNb;
int waveOutNb;
int auxNb;
MIXERLINE mixLine,mxLine[8];
MIXERCONTROL mxCtrl[32];
MIXERLINECONTROLS mxLCtrl[16];
int cConnections=0;
MIXERCONTROLDETAILS mxCtrlD[16];
MIXERCONTROLDETAILS_UNSIGNED detVal[16][2];
UINT MicMin,MicMax,MicVol,MicPan;
UINT LineMin,LineMax,LineVol,LinePan;
UINT CDMin,CDMax,CDVol,CDPan;


int MicId,LineId,CDId;
int dwMicId,dwLineId,dwCDId;


int GetMixerValues(HWND);
int GetLineId(HMIXER hmix,LPSTR linename);
int GetLineDetails(HMIXER hmx,LPMIXERLINE pmxLine,LPMIXERLINECONTROLS pmxLCtrl,LPMIXERCONTROL pmxCtrl,LPMIXERCONTROLDETAILS pmxCtrlD,MIXERCONTROLDETAILS_UNSIGNED *pdetVal);
unsigned int GetMSMixVol(int LineId,int chanNb);
unsigned int GetMSMixPan(int LineId);
//***************************************************************
int GetMixerValues(HWND hWnd)
{
int i;
MMRESULT mmres;
char txt[255];
int ConnectedMixerId=-1;


mixerNb=mixerGetNumDevs();
if(mixerNb==0)
{
	FrameStatus[0]=0;
	return(0);
}
for (i=0;i<mixerNb;i++)
    { 
    mmres=mixerGetDevCaps(i, (LPMIXERCAPS) &MixCaps,sizeof(MIXERCAPS));
	strcpy(txt,MixCaps.szPname);
	strupr(txt);
	if(strstr(txt,szExtMixName))
		ConnectedMixerId=i;
    }
if(ConnectedMixerId==-1)
	{
	bExtMixer=FALSE;
	FrameStatus[0]=0;
	return(-1);
	}
//mmres=mixerOpen((LPHMIXER)&hmx[0],uMxId,0,0,MIXER_OBJECTF_MIXER);

mmres=mixerOpen((LPHMIXER)&hmx[0],uMxId,hWnd,0,CALLBACK_WINDOW);
MicId=GetLineId(hmx[0],(LPSTR)MicTxt);
LineId=GetLineId(hmx[0],(LPSTR)LineTxt);
CDId=GetLineId(hmx[0],(LPSTR)CDTxt);

GetLineDetails(hmx[0],&mxLine[0],&mxLCtrl[0],&mxCtrl[0],&mxCtrlD[0],&detVal[0][0]);
if(MicId!=-1)
{
	dwMicId=mxCtrlD[MicId].dwControlID;
	MicMin=mxLCtrl[MicId].pamxctrl->Bounds.lMinimum;
	MicMax=mxLCtrl[MicId].pamxctrl->Bounds.lMaximum;
	MicVol=detVal[MicId][0].dwValue;
}
else
{
	MicMin=0;
	MicMax=0;
	MicVol=0;
}
if(LineId!=-1)
{
	dwLineId=mxCtrlD[LineId].dwControlID;
	LineMin=mxLCtrl[LineId].pamxctrl->Bounds.lMinimum;
	LineMax=mxLCtrl[LineId].pamxctrl->Bounds.lMaximum;
	LineVol=GetMSMixVol(LineId,2);
	LinePan=GetMSMixPan(LineId);
	if(LinePan==-1)
		LinePan=63;
}
else
{
	LineMin=0;
	LineMax=0;
	LineVol=0;
	LinePan=0;
}
if(CDId!=-1)
{
	dwCDId=mxCtrlD[CDId].dwControlID;
	CDMin=mxLCtrl[CDId].pamxctrl->Bounds.lMinimum;
	CDMax=mxLCtrl[CDId].pamxctrl->Bounds.lMaximum;
	CDVol=GetMSMixVol(CDId,2);
	CDPan=GetMSMixPan(CDId);
	if(CDPan==-1)
		CDPan=63;
}
else
{
	CDMin=0;
	CDMax=0;
	CDVol=0;
	CDPan=0;
}
return(1);
}
//*****************************************************
int GetLineId(HMIXER hmix,LPSTR linename)
{
//MIXERLINE mxline;
int cConx,i,res1;//,res2;
MMRESULT mmres;
char text1[50];
char text2[50];

strcpy(text1,strupr(linename));
mixLine.cbStruct=sizeof(MIXERLINE);
mmres=mixerGetLineInfo(hmix,(LPMIXERLINE) &mixLine,MIXER_OBJECTF_HMIXER);
cConx=mixLine.cConnections;
for (i=0;i<cConx;i++)
	{
	mxLine[0].cbStruct=sizeof(MIXERLINE);
	mxLine[0].dwSource=i;
	mmres=mixerGetLineInfo(hmix,(LPMIXERLINE) &mxLine[0],MIXER_GETLINEINFOF_SOURCE);
	strcpy(text2,strlwr(mxLine[0].szShortName));
	strupr(text2);
	res1=strstr(text2,text1);

	if (res1 != NULL)
		return(i);
	}
return(-1);
}

//*********************************************************
int GetLineDetails(HMIXER hmx,LPMIXERLINE pmxLine,LPMIXERLINECONTROLS pmxLCtrl,LPMIXERCONTROL pmxCtrl,LPMIXERCONTROLDETAILS pmxCtrlD,MIXERCONTROLDETAILS_UNSIGNED *pdetVal)
{
MMRESULT mmres;
int i;

mixLine.cbStruct=sizeof(MIXERLINE);
mmres=mixerGetLineInfo(hmx,(LPMIXERLINE)&mixLine,MIXER_OBJECTF_HMIXER);
cConnections=mixLine.cConnections;
for (i=0;i<cConnections;i++)
	{
	pmxLine->cbStruct=sizeof(MIXERLINE);
	pmxLine->dwSource=i;
	mmres=mixerGetLineInfo(hmx,(LPMIXERLINE) pmxLine,MIXER_GETLINEINFOF_SOURCE);

	pmxLCtrl->cbStruct=sizeof(MIXERLINECONTROLS);
	pmxLCtrl->pamxctrl=(LPMIXERCONTROL)pmxCtrl;
	pmxLCtrl->cControls=pmxLine->cControls;
	pmxLCtrl->dwLineID=pmxLine->dwLineID;
	pmxLCtrl->cbmxctrl=sizeof(MIXERCONTROL);
	mmres=mixerGetLineControls(hmx,(LPMIXERLINECONTROLS)pmxLCtrl,MIXER_GETLINECONTROLSF_ALL);

	pmxCtrlD->paDetails=pdetVal;
	pmxCtrlD->cbDetails=sizeof(MIXERCONTROLDETAILS_UNSIGNED);
	pmxCtrlD->cbStruct=sizeof(MIXERCONTROLDETAILS);
	pmxCtrlD->dwControlID=pmxCtrl->dwControlID;
	pmxCtrlD->cChannels=pmxLine->cChannels;
	mmres=mixerGetControlDetails(hmx,(LPMIXERCONTROLDETAILS)pmxCtrlD,MIXER_GETCONTROLDETAILSF_VALUE);

	pmxLine++;
	pmxLCtrl++;
	pmxCtrl++;	
	pmxCtrlD++;
	pdetVal+=2;

	}
}

//**************************************
unsigned int GetMSMixVol(int LineId,int chanNb)
{
unsigned int vol;
	if (chanNb==1)
		vol=detVal[LineId][0].dwValue;
	else if(chanNb==2)
		vol=max(detVal[LineId][0].dwValue,detVal[LineId][1].dwValue);
	else
		vol=0;

return(vol);
}
//*********************************************
unsigned int GetMSMixPan(int LineId)
{
double pan;
unsigned int left,right;
left=detVal[LineId][0].dwValue;
right=detVal[LineId][1].dwValue;
if(right-left!=0)
	pan=(double)63-(double)63*(((double)left-(double)right)/(double)max(right,left)) + (double)0.5;
else
{
	if(right==0)
		pan=-1;
	else
		pan=63;
}
	
return((unsigned int)pan);
}