        page 60, 132
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   dreamirq.asm
;                                                                       
;	This file contains some tools to write and read through the mpu401 port and
;	IRQ entry point (dspISR).         
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        .286             
                       
        .xlist  
        include mpu401.inc                                   
        include cmacros.inc                   
        include windows.inc
        include mmsystem.inc
        include mmddk.inc
        include dream94.inc
        .list

        ?PLM=1                          ; Pascal call convention
        ?WIN=0                          ; NO! Windows prolog/epilog code
        public	_BRFlag
		public	gwPort
		public  _gwMidiInPersistence, _gwEOICommands
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   extrn declarations         
;                                              
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
           
	   
	                              
        externA <__AHINCR>                  ; kernel
        externFP <wodDMAStart>         ; wavefix.c       
        externFP <EnableMidi>         ; midia.asm      
        externW <_CloseChannel>         ; wavefix.c  
;        externFP <dmaAllocateBuffer>        ; wavea.asm      
;        externFP <dmaFreeBuffer>        ; wavea.asm
        externFP <wodPostAllHeaders>        ; wavefix.c
        externNP <widFillBuffer>            ; wavefix.c
        externNP <midByteRec>               ; midifix.c
        externW <_StopRecord>             ; midiin.c     
       ; externW <gwEOICommands>             ; inita.asm
        ;externW <gwMidiInPersistence>       ; inita.asm
        externB <_MidiOut>              ; midifix.c
        externB <gbMidiInFlags>             ; midia.asm  
        externFP <StackEnter>               ; from MMSYSTEM.DLL
        externFP <StackLeave>

         ; MOD variables
         externB <_gbModAnsByte>		; waveout.c  
         externW <_gwModAnsNb>		; waveout.c
         externB <_gbModAnsLong>		; waveout.c     
         
         ; WRT_MEM, READ_MEM
         externW <DataMode>		; wavea.asm     
         externW <DataOff>		; wavea.asm  
         externW <DataSeg>		; wavea.asm   
         externW <DataCount>		; wavea.asm
         externB <_Ack_Ok>		; waveout.c  1=acknowledge received, 2=abort received 
         externB <_IntUsed>   
         externB <_UartAc>
		 externW <_EndBuffer>		; wavefix.c
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   segmentation
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

IFNDEF SEGNAME
        SEGNAME equ <_TEXT>
ENDIF

createSeg %SEGNAME, CodeSeg, word, public, CODE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   data segment
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sBegin Data                

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;   DMA buffer data. Note that the DMA buffer is split in two
;   so we can ping-pong between two actual buffers
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -; 
	    globalD gdwOldISR,           0
	    globalW gwPort,			-1
		globalW	_gwMidiInPersistence,	50
		globalW _gwEOICommands,	0
		globalW wForAfter,		0	; memorize number of byte to copy after   
        globalB bNchannel,			0  ; Channel number    
        globalB gbOpenChan,			0	; Number of open channels
        globalB RemainB1,			0; Is there a byte remaining between 2 page? (used in MemCopySrc)
        globalB RemainR,			0;  idem for record
ByteRemaining	db 		0,0,0,0,0,0,0,0,0  ;to store remaining byte
_BRFlag			db		0,0,0,0,0,0,0,0,0  ; is there 	a remaining byte?
sEnd DATA                      

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   code segment
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sBegin CodeSeg

        assumes cs, CodeSeg
        assumes ds, DATA

if DBG

cProc AssertBreak <FAR, PUBLIC> <>
cBegin
        int     3
cEnd

endif 
 


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; @doc INTERNAL
;
; @asm ReadP16  Read a byte from the mpu401 data port.
;
; If time out occurs before a data is ready then the carry flag
;     is set and no value is returned; otherwise, the carry flag is cleared
;     and the data value returned in AL.
;
; @comm The timeout value is very machine dependent.
;
; @comm USES: FLAGS, AL--all other registers are preserved. 
;	modify 18-12-95
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, Data
        assumes es, nothing

        public ReadP16
ReadP16 proc far


        push    cx
        push    dx

        mov     dx, [gwPort]
        add     dx, MPU401_REG_STATUS  ; point to data available status port
        mov     cx, 1000                ; set time out value
read1:
        in      al, dx                  ; get status
        test      al, DSR                  ; Q: DSR clr
        je      read2                   ;   Y: jump if data ready

        loop    read1

        ; timed out
        stc 
        jmp     read3

read2:
        dec     dx						 ; DATA
        in      al, dx                  ; get data byte
        clc
        D1 < READ #al>
read3:
        pop     dx
        pop     cx

        ret

ReadP16 endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; @doc INTERNAL
;
; @asm WriteP16		 Write a command or data byte to the mpu401 port.
;
; @reg AL | The byte to be written. 
;		dx address
;      
; Carry is set on exit the port is not available for writing.
;	 
;
; @comm Uses only FLAGS--all other registers are preserved.  
;
;Modify 12-12-95
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, Data
        assumes es, nothing

        public WriteP16
WriteP16	proc far

		push	bx
        mov     bx, [gwPort]
        add     bx, MPU401_REG_STATUS     ; point to  status port
        cmp		bx, dx
        je		ClearMidiOut
		add		bx, COM_OFFSET
		cmp		bx, dx
		jne		write_it
ClearMidiOut:
        ;			write on command port	
        mov		[_MidiOut], 0			; MidiOut =FALSE
write_it:
        push    cx
        push    dx

        push    ax                      ; save data byte to write...

        mov     dx, bx

        xor     cx, cx                  ; timeout loop counters
        mov     ah, 10
dspwr1:
        in      al, dx
        test     al, DRR                  ; test busy bit 
        jz		dspwr2                    ; OK
        loop    dspwr1                  ; loop if not timed out
        dec     ah
        jnz     dspwr1
        D1 <WriteP16 : TIME OUT>
        stc                             ; set carry to show time out
        pop     ax                      ; dump the data 
        pop		dx
        jmp     dspwr3

dspwr2:
        pop     ax                      ; get the data byte 
        pop		dx   
        D1 <W : #al in #dx>
        out     dx, al                  ; write it (same port)
        clc                             ; no error

dspwr3:
        pop     cx  
        pop		bx
        ret
        
WriteP16 endp     
   

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; @doc INTERNAL 
;
; @asm void | modDataWrite | This function writes a byte to the midi port.
;
; @parm BYTE | bDataByte | The byte to be written.
;
; @rdesc BOOL | 
;
; @comm This function polls the hardware (no choice with this card) so
;     it may take a while.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, Data
        assumes es, nothing

cProc modDataWrite <NEAR, PASCAL, PUBLIC> <>
        ParmB   bDataByte
cBegin

        D3 <{dw>
        push	dx
         
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
; Note that we must enter a critical section
;   because an interrupt between the MIDIWR command and writing the
;   data byte will break (from wave input/output during MIDI output).
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;

        EnterCrit                       ; !!! Trashes BX !!!

        mov		dx, [gwPort]			;	Data register
        mov     al, bDataByte           ; send midi data
        D4      <#AL>
        call    WriteP16

        LeaveCrit                       ; !!! Trashes BX !!!

mdw_Exit:

        D3 <}>
        pop		dx
        xor     ax, ax                  ; always succeed for now

cEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;		ISR  		- INTERRUPT PROCEDURE
;
; @asm dspISR | This function services interrupts from the DSP.
;
;		This function handles interrupt. It dispatch it according to irq type 
;			(midi, wave, mod, general device)
;modify 18-12-95
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

isr_Srv_Table label word
        dw  offset isr_Int_MIDI_Input   ; INT_Midi input      equ 0
        dw  offset isr_Int_Wave_Output  ; INT_WAVEOUT   equ 1
        dw  offset isr_Int_Mod_Play   ; INT_Mode player    equ 2
        dw  offset isr_Int_Gen_device   ; general device irq    equ 3

        assumes ds, nothing
        assumes es, nothing

        public dspISR
dspISR proc far
                                                  
        push    ds
        push    ax
        mov     ax, DGROUP              ; set up local DS
        mov     ds, ax
        assumes ds, Data
        D1 <IRQ>
	 
        mov     al, [_IntUsed]
        or      al, al                  ; Q: expecting an interrupt?   
        jnz		isr_Handle_Interrupt
        ;Unexpected Int       
        D1 <UNEXPECTED-INTERRUPT>  
        mov		dx, gwPort
        in		al, dx     ; read the data to free the port (Win95 only)
        jmp		EndIsr               ;    Y: don't read data port
        
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;   dispatch the interrupt to the correct handler...
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;

isr_Handle_Interrupt:
        cCall   StackEnter              ; switch to another stack
        sti                             ; enable interrupts on new stack
        push    es
        pusha
        
        D3 <(v2>   
        mov		dx,	[gwPort]
        add		dx,	MPU401_REG_STATUS
        in		al,	dx                              
        D1<status:#al in #dx>

        mov		bl,	al             
        shr 	bx,	MPX    
        and		bx,	3 
        D1 <MPX=#bx>
        cmp		bl,	4                   ;	WAVE int ?
        jae		isr_Exit	                ; no, jump
        
dispat :
		mov     di, bx                                                      
		add		di, di              ; convert to table index
        call    isr_Srv_Table[di]       ; service the interrupt

        D3 <)>

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;   NOTE: We switch back to our original stack BEFORE EOI'ing.  This way
;   we don't use too many stacks; if interrupts are pending that will fire
;   just after the EOI.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;

isr_Exit:

        popa
        pop     es

        cli                             ; turn off ints for EOI
        cCall   StackLeave              ; get back to original stack
EndIsr:
        mov     ax, [_gwEOICommands]     ; get EOI commands for slave & master
        or      al, al                  ; Q: need to EOI slave? (IRQ's 8-15)
        jz      isr_EOI_Master          ;   N: just do master (IRQ's 0-7)

        out     PIC_EOI_SLAVE, al       ; EOI the slave first--then master

isr_EOI_Master:                                  

        mov     al, ah                  ; move master EOI command to AL
        out     PIC_EOI_MASTER, al

        pop     ax
        pop     ds
        assumes ds, nothing

        iret

dspISR endp

                               	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	Mod IRQ
;   
;	IRQ received indicate a data is available on data port. We're expecting
;	gwModAnsNb byte yet to complete the 'message'. For example, if a long integer
;	is expected (ex : answer from GET_MMT), gwModAnsNb is 4 when the first byte arrives,
;	3, when the second byte arrived and so on...
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

isr_Int_Mod_Play proc near 
;
; We are waiting for  _gwModAnsNb bytes (1, 4, or 5).
;	If 1, it is put in _gbModAnsByte
;	If 4, It is put in _gbModAnsLong (table of 4 byte)
;	If 5, the 4 first bytes are send in _gbModAnsLong and the last one in _gbModAnsByte
;   clc
	mov		cx, [_gwModAnsNb]    ; nb of bytes to receive  
	D1 < To receive #cx> 
	          
	cmp		cx, 1				 ; just one byte
	je		onebyte
	mov		di, 0
	cmp		cx, 4                 ; <4 byte expected
	jae		FillLong     
	call	ReadP16				  ; Yes, error, nb of bytes expected less than 4 and different from 1
                                  ; so read byte arrive and exit
    stc							; set carry
    jmp     IsrModPlayExit
FillLong:                       ; put 4 bytes in long
	mov		ah, 10					; counter
modReadNext: 
	dec		ah
	jz		IsrModPlayExit		; error can't read next byte
	call	ReadP16              ; next byte arrived in al  
	jc		modReadNext          ; loop until byte read
	mov		_gbModAnsLong[di], al 
	D1< #al>
    dec		cx
	inc		di
	cmp		di, 4
	jne     FillLong
	cmp		cx, 0				 ; remain one byte?
	je		IsrModPlayExit			; no , exit
onebyte:
	mov		ah, 10					; counter
modReadNext2: 
	dec		ah
	jz		IsrModPlayExit		; error can't read next byte
	call	ReadP16              ; next byte arrived in al  
	jc		modReadNext2          ; loop until byte read 
	mov		[_gbModAnsByte], al
IsrModPlayExit: 
	D1 <_gwModAnsNb>
	mov		[_gwModAnsNb], 0
	ret
isr_Int_Mod_Play	endp 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;
;   isr_Int_MIDI_Input
;
;   This routine is called to service a MIDI input interrupt.  The hardware
;   has not been touched since the interrupt was generated, so the status
;   register must be read, etc.
;
;   STATE:
;       DS is set to DGROUP.
;       All non-extended registers are saved.
;       Interrupts are ENABLED.
;       We are on a safe stack for callbacks.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
        assumes ds, Data
        assumes es, nothing

        public isr_Int_MIDI_Input
isr_Int_MIDI_Input proc near
        D1 <MIDI input> 
        ; If no midi In and no midi out open send data receive for output
        
        test    [gbMidiInFlags], MIF_ALLOCATED  
        jnz		Midi_Open  
        call	ReadP16                                  ; no midi in open
        cmp 	al, 0feh
        jne		notuartac    
        mov		[_UartAc], 1
notuartac:                                     
        jmp		isr_Int_MIDI_Input_Exit
Midi_Open:
        mov     si, [_gwMidiInPersistence]
        mov     dx, [gwPort] 			; point to data available status port 
        add		dx, MPU401_REG_STATUS
isr_Int_MIDI_Input_Loop:

        in      al, dx                  ; get status  
        cmp 	al, 0feh
        jne		notuartac2    
        mov		[_UartAc], 1
notuartac2:                    
        D2 <Status #al in #dx  > 
        test      al, DSR                  ; Q: MSB set (ie data ready)?
        jne     isr_Int_MIDI_Input_Exit ;   N: no more data ready...
            
        shr 	ax,	MPX    
        and		ax,	3 
        jnz		isr_Int_MIDI_Input_Exit
		
		dec     dx 					  ; DX = data port
        in      al, dx                  ; get data byte
        D2 < #al>
        test    [gbMidiInFlags], MIF_STARTED		; Midi input started 
        jz		notstart
        D2 < St> 
        push	dx
        cCall   midByteRec, <ax>        ; !!! trashes AX, BX, CX, DX, and ES
        pop		dx
notstart:
        inc     dx                ; restore status port 
        dec     si
        jnz     isr_Int_MIDI_Input_Loop

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;   We are bailing out because we have been in here for a long time; we 
;   will be back after allowing interrupts to kick on other devices.  There
;   is a good chance of losing data if we do this too frequently--this is
;   why there is a 'MIDIInPersistence=xxxx' key.  However, DEF_PERSISTENCE
;   should be sufficient in most circumstances (currently defined as 50).
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;

        D1 <TKO>                        ; Technical Knock Out!

isr_Int_MIDI_Input_Exit:
        D1 <end midi>
        ret

isr_Int_MIDI_Input endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;
;   isr_Int_Wave_Input
;
;   This routine is called to service a Wave input interrupt.  
;	By this interrupt, the board informs the driver that an half buffer
;		(WaveBufferSizeIn/2) has just been filled.
;	We call the widFillBuffer (wavefix.c) function to copy it in one of the buffer
;	provided by application to driver. 
;
;   STATE:
;       DS is set to DGROUP.
;       All non-extended registers are saved.
;       Interrupts are ENABLED.
;       We are on a safe stack for callbacks.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
        assumes ds, Data
        assumes es, nothing

        public isr_Int_Wave_Input
isr_Int_Wave_Input proc near
                                                      
        mov		ax, [_StopRecord]
        cmp		ax, 0			; record allowed?
        jnz		isr_Int_Wave_Input_Exit
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;   copy the current data and toggle ping/pong... note that auto-DMA is
;   already at work with the opposite buffer.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;D1<Call widfill>
        cCall   widFillBuffer
        ;D1<return from widfill>
isr_Int_Wave_Input_Exit:
        ret

isr_Int_Wave_Input endp                                                

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;
;   isr_Int_Wave_Output
;
;   This routine is called to service a Wave output interrupt.  The hardware
;   has not been touched since the interrupt was generated, so the status
;   register must be read.
;   
;	Actually, this function first check if it's a record (in this case, the isr_Int_Wave_Input
;	function is called), or o play interrupt.
;	A Play interrupt occurs when the board is ready to accept one half buffer data
;	(size=WaveBufferSize/2). The function wodDMAStart (wavefix.c) is called to
;	transfert data from data buffer provided by application (WODM_WRITE) to 9407 board.
;
;   STATE:
;       DS is set to DGROUP.
;       All non-extended registers are saved.
;       Interrupts are ENABLED.
;       We are on a safe stack for callbacks.
;    
;	modify : 18-12-95
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
        assumes ds, Data
        assumes es, nothing

        public isr_Int_Wave_Output
isr_Int_Wave_Output proc near      
        
        call	ReadP16

        cmp		al, 8                                    
        jbe		Dma_Request

        ; See if it is a close acknowledge
        mov		bl, al		; save al
        and		al, 0f0h
        cmp		al, 0c0h    ; close ack?
        jne     isr_Int_Wave_Out_Exit	; no, bad data!
        ; close ack  
        and		bx, 000fh				; channel nb
        D1<Close ack : channel #bx>     
        shl		bx, 1					; index for words table                                                   
        mov		_CloseChannel[bx], 1    ; close will be made the next time the driver is called
        jmp     isr_Int_Wave_Out_Exit
Dma_Request:

        ;D1 <DMA BUFFER rq from P16, Data read : #al>    
        mov		[bNchannel], al 
        test	al,	08h   	; Wave in IT ?
        jz		forOutput
		;D1 <Wave Input>
        call	isr_Int_Wave_Input
        jmp		isr_Int_Wave_Out_Exit
forOutput:
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;   Read the next data block and set up for next interrupt.  gbDMABuffer
;   is reset here to reflect either a new buffer or no more to do.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;

isr_Int_Wave_Out_Go:
		mov		bl, [bNChannel]
		mov		bh, 0
        cCall   wodDMAStart, < bx >
        D1 <Data copied : #ax>
isr_Int_Wave_Out_Exit:

        ret

isr_Int_Wave_Output endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;
;   isr_Int_Gen_Device
;
;   A general device interrupt is generated when a general command implied 
;	acknowledge. This routine just read the data to cut off interrupt and
;	if it is an acknowledge, the flag Ack_Ok is set.
;	
;
;   STATE:
;       DS is set to DGROUP.
;       All non-extended registers are saved.
;       Interrupts are ENABLED.
;       We are on a safe stack for callbacks.
;    
;	create : 04-07-96
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
        assumes ds, Data
        assumes es, nothing

        public isr_Int_Gen_Device
         
isr_Int_Gen_device proc near                   
		call ReadP16  
		D1 <gen device data=#al> 
		cmp		al, ACKNOW
		je		SendDatas  
		D1 < not ac>
		cmp		al, MEM_ABORT
		jne	    exit_gen_dev    
		mov		[_Ack_Ok], 2         ;	Abort received
		jmp		exit_gen_dev
SendDatas:  
		D1 <AC>
		mov		[_Ack_Ok], 1         ;	acknowledge received
		cmp		[DataMode], 1		; Write mem                   
		jne		notWrite  
		mov		cx, [DataCount]
		shl		cx, 1  
		mov		ax,7fh            ; not a wave record!
		cCall	Dmaxfer, <DataSeg,DataOff,cx,ax>   
		mov		[DataMode], 0
		jmp    exit_gen_dev
notWrite:
		cmp		[DataMode], 2		; Write mem                   
		jne		notRead                       
		mov		cx, [DataCount]
		shl		cx, 1  
		mov		ax,7fh            ; not a wave record!  
		D1<record>
		cCall	dmaRecord, <DataSeg,DataOff,cx,ax> 
		mov		[DataMode], 0
notRead:
exit_gen_dev : 
       ret
isr_Int_Gen_Device endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	Proc DMAxfer
;	Called at interrupt time to service wave output. This function is called by 
;	wodDMAStart (wavefix.c). This function send wCount data to the board
;	through DMA port.	 	
;   enter : 
;			LPVOID lpSrc
;			WORD wCount	Nb of bytes to copy
;           
;	exit :	Returns the source pointer advanced by <p cnt> bytes.
;
; @comm This function handles segment crossings in the source
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
		assumes ds, nothing            
		
cProc DMAxfer <NEAR, PASCAL, PUBLIC> <ds, si, di>
        ParmD   lpSrc
        ParmW   wCount  
        ParmW	Chan
cBegin                                  
		push	ds          
		pop		es			; es= data segment
        DE1 <DMA xfer >  
        
		mov		es:[RemainB1], 0 
        lds     si, lpSrc             ; get source pointer            
      	;DE1 < wave ds=#ds  #si, data es=#es>
		
        mov     cx, wCount            ; cx is count of bytes
        or		cx, cx
        jnz		noex0
        jmp    mcs_Exit1              ; copy no bytes--return current pointer...
noex0:
        cld                          ; let's not assume this    
        mov		bx, Chan
        cmp		bx, 8                    ; Wave ?
        jae     NothingRemaing1			; Not a wave dma. 
        test 	es:_BRFlag[bx], TRUE			; Is there a byte remaining from last data transfert?
        jz		NothingRemaing1			; NO, 
        mov		al, es:ByteRemaining[bx]		; yes, retreive the byte
        mov		ah, ds:[si]                 ; complete the word
        mov		dx,	es:[gwPort]             ; dma address
      	add		dx,	2 
                                               
        out		dx, ax ; ... and send it
        mov		es:_BRFlag[bx], FALSE
        inc		si   
        dec		cx
NothingRemaing1:
        ;DE1 <Check for seg. cross>
        mov     ax, si                ; check for a segment cross in the source
        add     ax, cx
        sbb     dx, dx                ; if C dX=FFFF, NC dX=0000
        and     ax, dx                ;
        sub     cx, ax                ; CX contains amount to copy now, AX has
                                      ; ...amount to copy later
        mov		es:[wForAfter], ax    
        DE1 <to write later : #ax>
        
        cmp		cx, 0
        jnz     noex1
        jmp		mcs_Exit1
noex1:    
		;DE1 <Send xfer>   
		mov		es:[RemainB1], 0			; assume even bytes number to copy now
        ; copy the memory
      	mov		dx,	es:[gwPort]
      	add		dx,	2   
mcs_Copy_It1:   
		;DE1 <copy #cx bytes> 
		shr     cx, 1      
		jnc		noremain2
		mov		es:[RemainB1], 1       ; 1 byte remain in Page change  
noremain2:
		or		cx, cx
		jnz	    cxnotzero1
		jmp		mcs_Exit1 
cxnotzero1:                       
		rep		outsw
        test	es:[RemainB1], 1          ; Is there a byte remaining in this page?
        jz		noremain1				; No, jump 
        DE1 <remain>
        mov		al, ds:[si]           ; take the remaining byte
        inc		si
noremain1: 
		;DE1 <si :#si>       
        or      si, si                ; check for a segment wrap
        jnz     mcs_Exit1
        DE1 <second pass>
        mov     cx, es:[wForAfter]
		jcxz	NoPlMore
		jmp		continue_pl
NoPlMore:
		cmp		_EndBuffer, 1
		je		mcs_Exit1
continue_pl:
        mov		bx, ds
        add     bx, __AHINCR 
        mov		ds, bx                  ; new buffer seg
        test	es:[RemainB1],1
        jnz 	remainok1	
        jmp		mcs_Copy_It1  
remainok1:
        mov		ah, ds:[si]
        out		dx, ax					; send the word that is on the 2 page
        inc		si  
        dec		cx
        mov		es:[RemainB1], 0			; no more Remaining Nyte
        jmp     mcs_Copy_It1

mcs_Exit1: 
		mov		bx, Chan
        cmp		bx, 8                    ; Wave record?
        jae		notWaveRem1
        test	es:[RemainB1], 1
        jz     notWaveRem1
        mov		es:_BRFlag[bx], TRUE			;no byte remaining
        mov		es:ByteRemaining[bx], al 
notWaveRem1:
		mov     dx, ds                ; DX:AX = advanced source pointer
        mov     ax, si
      ; DX:AX = advanced source pointer
        DE1 <return : #dx  #ax>
cEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; @doc INTERNAL 
;
; @asm LPVOID | dmaRecord   Block memory copy.
; 
;	Called at interrupt time to service wave input. This function is called by 
;	widFillBuffer (wavefix.c). This function send wCount data from the board
;	through DMA port.	 
;  lpDst | Destination.
;
;  wCount | Number of bytes to copy.
;
; @rdesc Returns the destination pointer advanced by <p wCount> bytes.
;
; @comm This function handles segment crossings in the destination *only*.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, data
        assumes es, nothing

cProc dmaRecord <NEAR, PASCAL, PUBLIC> <es, si, di>
        ParmD   lpDst               
        ParmW   wCount 
        ParmW	Chan
cBegin
        ;D1 <DMA REC>    
        cld                             ; let's not assume this
        mov		[RemainR], 0
        les     di, lpDst               ; get dest pointer 
        ;D1 <es=#es    di=#di>
        mov     cx, wCount              ; cx is count of bytes        
        D1<count=#cx>

        mov		bx, Chan  
        D2 <chan=#bx>
        cmp		bx, 8                    ; Wave record?
        jne     NothingRemaing			; Not Wave Record
        test 	_BRFlag[8], TRUE			; Is there a byte remaining from last data transfert?
        jz		NothingRemaing			; NO, 
        mov		ah, ByteRemaining[8]		; yes, retreive the byte
        mov		es:[di], ah              ; ... and send it
        mov		_BRFlag[8], FALSE
        inc		di                            
        dec		cx
NothingRemaing:
        mov     ax, di                  ; check for a segment cross in the dest
        add     ax, cx
        sbb     bx, bx                  ; if C BX=FFFF, NC BX=0000
        and     ax, bx                  ;
        sub     cx, ax                  ; CX contains amount to copy now, AX has
        
        mov		[wForAfter], ax          ; ...amount to copy later
        D2 <   For after #ax   now #cx>
                
        mov		dx,	[gwPort]
		add		dx,	DMA_REG                                       
rec_Copy_It:
		or		cx, cx  
		jnz		notnull
        jmp    rec_Exit
notnull:  
        ;D1 <Copy it  es=#es>
        shr     cx, 1                   ; copy the memory   
        jnc		noremainrec
		mov		[RemainR], 1       ; 1 byte remain in Page change  
		D1 <Remain set cx/2=#cx>
noremainrec:
		or		cx, cx
		jnz	    cxnotzeror
		jmp		rec_Exit 
cxnotzeror:
		rep     insw    

        test	[RemainR], 1          ; Is there a byte remaining in this page?
        jz		RecEven				; No, jump 
        D1 <remain>
        in		ax, dx         ; take the next word
        mov		es:[di],al                                                  
        inc		di
RecEven:
        or      di, di                  ; check for a segment wrap
        jnz     rec_Exit

        mov     cx, [wForAfter]                  ; cross huge boundary
        jcxz	NoRecMore
		jmp		continue
NoRecMore:
		cmp		_EndBuffer, 1
		je		rec_Exit
continue:
		mov     bx, es
        add     bx, __AHINCR
        mov     es, bx 
        test	[RemainR], 1
        jnz		notrec
        jmp		rec_Copy_It  
notrec:        
        D1<for after #cx es inc>
        mov		es:[di], ah                                        
        dec		cx
        inc		di 
        mov		[RemainR], 0
        jmp     rec_Copy_It

rec_Exit:   
		mov		bx, Chan
        cmp		bx, 8                    ; Wave record?
        jne		notWaveRem
        test	[RemainR], 1
        jz     notWaveRem
        mov		_BRFlag[8], TRUE			;no byte remaining
        mov		ByteRemaining[8], ah 
notWaveRem:
        mov     dx, es                  ; DX:AX = advanced dest pointer
        mov     ax, di
       D1 <return #dx #ax>  
cEnd


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; @doc INTERNAL 
;
; @asm DmaFinish   
; 
;	Called at interrupt time to service wave input. This function is called by 
;	widFillBuffer (wavefix.c) to complete the dma in the bad case which occurs
;	when we haveb't got enough buffer to put recorded datas.
;  
;  wCount | Number of bytes to copy.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, data     

cProc DmaFinish <FAR, PASCAL, PUBLIC> <>
        ParmW   wCount
cBegin
		mov		cx, wCount 
		D1<----------------* DMA finish #cx *--------->
		mov		dx,	[gwPort]
		add		dx,	DMA_REG      
DmaLoop:
		in		ax, dx
		loop	DmaLoop
cEnd



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	FreeMpuPort
;
; This function is called when openning a device in order to read 
;	data which could prevent mpu from working
;  
;		return 0 if succeed, 1 if failed
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, data     

cProc FreeMpuPort <FAR, PASCAL, PUBLIC> <>        
cBegin   
		mov		cx, 0
ReadLoop:  
		mov		dx, [gwPort]
        inc		dx  						; Status
        
        push	cx
        mov		cx, 10000   
tempo:        
        in		al,	dx   
        loop	tempo  
        pop		cx
        test    al, DSR
        jne		nothing_to_read
        dec		dx							; data
        in		al,	dx
        loop	ReadLoop   
        mov		ax, 1
        jmp		fmpExit
nothing_to_read:
		mov		ax, 0
fmpExit:
cEnd
		

;---------------------------------------------------------------------------;
;
;   LPFUNC SetInterruptVector( bIRQ ,new)
;
;   DESCRIPTION:
;       This function takes the IRQ and sets the appropriate interrupt
;       vector; and returns the pointer to the previous handler of the
;       IRQ.
;
;   ENTRY:
;       ParmB   bIRQ        :   The IRQ (0 - 15) to install handler for.
;       ParmB   New			:  1->set dspISR as interrupt proc
;								0->reset old isr proc
;   EXIT:
;       DX:AX   :   The return value is the previous interrupt handler.
;
;   USES:
;       Flags, AX, BX, DX, ES
;
;
;---------------------------------------------------------------------------;

        assumes ds, Data
        assumes es, nothing

cProc SetInterruptVector <FAR, PUBLIC> <>
        ParmB   bIRQ
        ParmB   New
cBegin

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;   convert IRQ to interrupt vector...
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        mov     al, bIRQ
        mov     ah, 08h
        cmp     al, ah                  ; Q: slave or master IRQ?
        jl      isv_Continue

        mov     ah, (70h - 08h)         ;   slave

        public isv_Continue
isv_Continue:

        add     al, ah                  ; AL = interrupt vector

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;   get old interrupt vector (AL == interrupt vector)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;

        mov     ah, 35h
        int     21h                     ; get the old vector in es:bx

        nop
        push    es                      ; save for a bit
        push    bx


;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;   set new interrupt vector (AL == interrupt vector)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;

        mov     ah, 25h
        push    ds 
        pop		es
        push	es
        
        assumes ds, nothing
        test New, 1
        jz		resetOld 
        push	cs
        pop		ds
        mov     dx, offset dspISR
        jmp		setvect
resetOld: 
		mov     dx, es:[gdwOldISR].off
        mov     ds, es:[gdwOldISR].sel  
setvect:
        int     21h                     ; set the new vector
        pop     ds

        pop     ax                      ; restore old ISR for return value
        pop     dx                      ; ... DX:AX is old handler
        mov     es:[gdwOldISR].sel, dx
        mov     es:[gdwOldISR].off, ax
cEnd

sEnd CodeSeg

        end                      
 
 
 
