
/****************************************************************************
 *
 *   dream94.h
 *                                                                        
 *
 ***************************************************************************/
// options
//#undef DEBUG  
//#define GUI
#include "drmpu401.h"
#include "mixer.h"

#ifdef DEBUG
    #define static
#endif      
#define NbMemBlocks		64			// Blocks number in memory mapping table   
#define COM_OFFSET		4	
#define GET_MMT		3			// Get Memory mapping table address   
#define SET_MMT		4			// Set Memory mapping table address 

#define DreamVxdId		0x6969

//Id
#ifdef GUI
	#define Mid		148			//Canam Computer Id
	#define MiPid	0x100
	#define MoPid	0x200
	#define WiPid	0x300
	#define WoPid	0x400
//	#define	MidiNb	1
#else
	#define Mid		0			//Canam Computer Id
	#define MiPid	0
	#define MoPid	0
	#define WiPid	0
	#define WoPid	0
//	#define	MidiNb	2
#endif
// Wave State
#define FREE		0    
#define ENDIT		1     
#define WSTART		2         
#define PAUSE		3 
#define	ASK_CLOSE	4 
#define	CLOSE_RQ	5  
#define	RESET		9 
#define ASK_PAUSE		6 
#define MAINVOL			7
#define REC_MODE		8
#define RECVOL			0x0A
#define AUDL_VOL		0x34
#define AUDR_VOL		0x35

#define MIDI_ALLOC		1

// Waves
#define END_XFER		0x43  
#define W_PITCH			0x44      
#define W_FILT_FC		0x4a  
#define W_FILT_Q		0x4b  

#define CMD_MODE		0xbe

//Equalizer - 3D
#define EQ_LBL	0x10
#define SUR_VOL	0x30  
#define GM_VOL	0x38   
#define GM_PAN	0x39

//MOD PLAYER
#define VOI_OPEN	0x52		// Open a voice channel  
#define GET_VOI		0x51		// Get number of available voices
#define GET_POS		0x5c		//  Return position of current reading


// MOD COMMAND
#define  START	0x54				
#define  STOP	0x55			
#define  CLOSE	0x53		

#define P_SIZE          0x1000
#define DRIVER_VERSION          0x02
#define MAX_ERR_STRING          250      /* max length of string table errors */
#define DLG_CONFIG              42       /* dialog box resource id */

#define DSP_VERSION_REQD        0x0200   /* DSP version required for driver */
#define DSP_VERSION_PRO         0x0300   /* DSP version for the Pro card */

#ifndef DRVCNF_RESTART
    #define DRVCNF_CANCEL       0x0000   /* DRV_CANCEL */
    #define DRVCNF_OK           0x0001   /* DRV_OK */
    #define DRVCNF_RESTART      0x0002   /* DRV_RESTART */
#endif

/****************************************************************************

       typedefs

 ***************************************************************************/

typedef struct MemBlDefTyp_t {
	WORD Type;
	long Address;
	}MemBlDefTyp;
	
/* per allocation structure for midi */
typedef struct portalloc_tag {
    DWORD               dwCallback;     /* client's callback */
    DWORD               dwInstance;     /* client's instance data */
    HMIDIOUT            hMidi;          /* handle for stream */
    DWORD               dwFlags;        /* allocation flags */
}PORTALLOC, NEAR *NPPORTALLOC;

typedef struct tMIDIMSGCLIENT {
    BYTE        fSysEx;
    BYTE        bStatus;

    BYTE        bBytesLeft;
    BYTE        bBytePos;

    DWORD       dwShortMsg;
    DWORD       dwMsgTime;
    DWORD       dwRefTime;

    DWORD       dwCurData;
    LPMIDIHDR   lpmhQueue;

} MIDIINMSGCLIENT, NEAR *NPMIDIINMSGCLIENT, *PMIDIINMSGCLIENT, FAR *LPMIDIINMSGCLIENT;

/* per allocation structure for wave */
typedef struct wavealloc_tag {
    DWORD               dwCallback;     /* client's callback */
    DWORD               dwInstance;     /* client's instance data */
    HANDLE              hWave;          /* handle for stream */
    DWORD               dwFlags;        /* allocation flags */
    DWORD               dwByteCount;    /* byte count since last reset */
    PCMWAVEFORMAT       pcmwf;          /* format of wave data */ 
}WAVEALLOC, NEAR * NPWAVEALLOC, FAR * LPWAVEALLOC;

typedef char huge *HPSTR;

/****************************************************************************

       strings - all non-localized strings can be found in initc.c

 ***************************************************************************/

#ifndef NOSTR
extern char far STR_PORT[];
extern char far STR_INT[];
extern char far STR_DRIVERNAME[];
extern char far STR_INIFILE[];
extern char far STR_PRODUCTNAME[];
  
#endif /* NOSTR */

/*  Error strings... */
#define IDS_ERRTWODRIVERS       1
#define IDS_ERRMCANOTSUPPORTED  2
#define IDS_ERROLDVDMAD         3
#define IDS_ERRBADPORT          4
#define IDS_ERRBADVERSION       5
#define IDS_ERRBADINT           6

#define IDS_ERRBADCONFIG        16
#define IDS_WARNPROCARD         17
#define IDS_WARNTHUNDER         18 
#define IDS_DREAMWAVE 			32            
#define IDS_DREAMWAV1 			IDS_DREAMWAVE         
#define IDS_DREAMWAV2 			IDS_DREAMWAVE +1
#define IDS_DREAMWAV3 			IDS_DREAMWAVE +2     
#define IDS_DREAMWAV4 			IDS_DREAMWAVE +3        
#define IDS_DREAMWAV5 			IDS_DREAMWAVE +4
#define IDS_DREAMWAV6 			IDS_DREAMWAVE +5      
#define IDS_DREAMWAV7 			IDS_DREAMWAVE +6
#define IDS_DREAMWAV8 			IDS_DREAMWAVE +7

#define IDS_DREAMREC 			63 
#define IDS_DREAMMIDIIN 		64
#define IDS_DREAMMIDIOUT 		65     
#define IDS_DREAMMIDIOUT2 		66     

/*  Product description strings - for this driver, they are all the */
/*  same text, so make all ID's equal */
/*#define IDS_SNDBLSTPRODUCT      32
#define IDS_SNDBLSTWAVEIN       IDS_SNDBLSTPRODUCT
#define IDS_SNDBLSTWAVEOUT      IDS_SNDBLSTPRODUCT      */

 
// for dream API
#define EQU_LL					0x10			// Set Equalizer  


/****************************************************************************

       globals

 ***************************************************************************/

/* in initc.c */
extern HANDLE    ghModule;      /* our module handle */

/* in wavefix.c */
extern HPSTR     hpCurInData;   /* points to data block of current input hdr */
extern DWORD     dwCurInCount;  /* bytes left in current input block */
extern HPSTR     CurData[8];     /* points to data block of current output hdr */
extern DWORD     CurCount[8];    /* bytes left in current output block */
extern LPWAVEHDR LoopStart[8];   /* pointer to first block of a loop */
extern DWORD     LoopCount[8];   /* count for current loop */
extern BYTE      bBreakLoop[8];    /* set to non-zero to break loop */
extern LPWAVEHDR lpWOQueue[8];     /*in WAVEFIX.C! wave output data buffer queue */
extern LPWAVEHDR DeadHeads[8];    /* wave output dead data headers */
extern LPWAVEHDR glpWIQueue;     /* wave input data buffer queue */


/* in midifix.c */
extern PORTALLOC gMidiInClient;  /* input client information structure */

/* in sndblst.asm */
extern BYTE      gfEnabled;      /* has the card been enabled? */


/***************************************************************************

    prototypes

***************************************************************************/

/* commona.asm */
extern void FAR  PASCAL MemCopy(LPVOID lpDst, LPVOID lpSrc, WORD cnt);
extern void FAR PASCAL SetwPort();

/* midia.asm */
extern void FAR PASCAL midStart(void);
extern void FAR PASCAL midStop(void);    
extern void FAR PASCAL EnableMidi(void);
extern void FAR PASCAL CritEnter(void);
extern void FAR PASCAL CritLeave(void);
extern WORD FAR PASCAL modAcquireHardware(void);
extern WORD FAR PASCAL modReleaseHardware(void);
extern WORD FAR PASCAL midAcquireHardware(void);
extern WORD FAR PASCAL midReleaseHardware(void);

/* wavea.asm */  
extern void FAR PASCAL SetVolume(WORD,WORD,WORD);
extern void FAR PASCAL SetAuxVolume(WORD,WORD,WORD);
extern void   FAR  PASCAL SetSampleRate(WORD);
extern void FAR PASCAL wodWrite(LPWAVEHDR,WORD);   
extern void FAR  PASCAL wClose(WORD);   
extern void FAR  PASCAL wStart(WORD);
extern WORD FAR PASCAL wAcquireHardware(WORD,WORD);
extern WORD  FAR PASCAL MemCopySrc(WORD Page, WORD, LPVOID,WORD,WORD);
extern WORD  FAR PASCAL MemCopyDst(WORD Page, WORD, LPVOID,WORD);
extern DWORD FAR PASCAL GetMMTAdd();   
extern void NEAR PASCAL SetMMTAdd(DWORD address);    
extern BOOL FAR PASCAL WaitAcknowledge(BYTE Ack);
extern void FAR PASCAL SendCommand(BYTE Type,BYTE End,WORD OffsetAdd);
extern void FAR PASCAL SendParam(BYTE Type,BYTE End,WORD OffsetAdd);
extern void NEAR PASCAL VoiceMemory(BYTE Voice, BYTE Format, BYTE Bank,DWORD Start,BYTE BkLoop,
				DWORD Loop,BYTE BkEnd,DWORD End);  
extern void NEAR PASCAL SetModPosition(BYTE Voice, BYTE bank, DWORD offset); 

/* dreamirq.asm */
extern BOOL NEAR PASCAL modDataWrite(BYTE);
extern LPVOID NEAR PASCAL DMAxfer(LPVOID lpSrc, WORD cnt,WORD); 
extern LPVOID NEAR PASCAL dmaRecord(LPVOID lpDst, WORD cnt,WORD);     
extern void FAR PASCAL DmaFinish(WORD cnt);
extern WORD FAR PASCAL FreeMpuPort();


/* midifix.c */
extern void  FAR  PASCAL midiCallback(NPPORTALLOC pPort, WORD msg, DWORD dw1, DWORD dw2);
extern DWORD FAR  PASCAL _loadds modMessage(WORD id, UINT msg, DWORD dwUser, DWORD dwParam1, DWORD dwParam2);
BYTE CheckMix(BYTE VolL, BYTE VolR,LPWORD nTodiv);
/* midiin.c */
extern void  NEAR PASCAL midSendPartBuffer(void);
extern DWORD FAR  PASCAL _loadds midMessage(WORD id, UINT msg, DWORD dwUser, DWORD dwParam1, DWORD dwParam2);

/* midiout.c */                                                               
extern void FAR PASCAL modGetDevCaps(MDEVICECAPSEX FAR * lpCaps,WORD id);

/* wavefix.c */
extern void FAR  PASCAL waveCallback(NPWAVEALLOC pWave, WORD msg, DWORD dw1);
extern void FAR  PASCAL wodBlockFinished(LPWAVEHDR lpHdr);
extern WORD NEAR PASCAL widFillBuffer();
extern void FAR  PASCAL widBlockFinished(LPWAVEHDR lpHdr);   

/* wavein.c */
void  NEAR PASCAL widSendPartBuffer(void);
extern DWORD FAR  PASCAL _loadds widMessage(WORD id, UINT msg, DWORD dwUser, DWORD dwParam1, DWORD dwParam2);
extern void FAR PASCAL widGetDevCaps(MDEVICECAPSEX FAR * lpCaps);

/* waveout.c */
void FAR PASCAL wodGetDevCaps(MDEVICECAPSEX FAR * lpCaps, WORD id);
extern DWORD NEAR PASCAL waveGetPos(NPWAVEALLOC, LPMMTIME lpmmt, WORD wSize,BYTE bpersamp,BYTE Stereo);
extern DWORD FAR  PASCAL _loadds wodMessage(WORD id, UINT msg, DWORD dwUser, DWORD dwParam1, DWORD dwParam2);
void FAR PASCAL WaveClose(WORD noChannel);  
BOOL CheckFreeSize();


/*apivxd.c*/
WORD FAR PASCAL _loadds DirectSoundVolumeCheck(WORD Volume, WORD BaseAddress);

/****************************************************************************

       Configuration support

 ***************************************************************************/

#define IDC_FIRSTINT  0x100
#define IDC_2         0x100
#define IDC_10         0x101
#define IDC_5         0x102
#define IDC_7         0x103
#define IDC_4         0x104
#define IDC_6         0x105
#define IDC_LASTINT   0x103

#define IDC_FIRSTPORT 0x201
#define IDC_300       0x201
#define IDC_320       0x202
#define IDC_330       0x203
#define IDC_332       0x204
#define IDC_334       0x205
#define IDC_336       0x206
#define IDC_LASTPORT  0x206

#define IDC_PORTGRP   0x401
#define IDC_INTGRP    0x402

/****************************************************************************

       Debug output

 ***************************************************************************/
#ifdef DEBUG
   extern WORD  wDebugLevel;     /* debug level */

   #define D1(sz) if (wDebugLevel >= 1) (OutputDebugString(STR_CRLF),OutputDebugStr(sz))
   #define D2(sz) if (wDebugLevel >= 2) (OutputDebugString(STR_SPACE),OutputDebugStr(sz))
   #define D3(sz) if (wDebugLevel >= 3) (OutputDebugString(STR_SPACE),OutputDebugStr(sz))
   #define D4(sz) if (wDebugLevel >= 4) (OutputDebugString(STR_SPACE),OutputDebugStr(sz))
#else
   #define D1(sz) 0
   #define D2(sz) 0
   #define D3(sz) 0
   #define D4(sz) 0
#endif

/****************************************************************************

       Assert

 ***************************************************************************/
#ifdef DEBUG
    extern void FAR PASCAL AssertBreak(void);
    #define AssertF(exp) \
        if ((exp) == 0)  \
        { \
            D1("AssertF failed (" #exp ")"); \
            AssertBreak(); \
        }

    #define AssertT(exp) \
        if ((exp) != 0)  \
        { \
            D1("AssertT failed (" #exp ")"); \
            AssertBreak(); \
        }
#else
    #define AssertBreak()
    #define AssertF(exp) 
    #define AssertT(exp) 
#endif
