/*******************************************************************/
/* Copyright 1995 Crystal Semiconductor Corp., ALL RIGHTS RESERVED */
/*   Program name: WAVE.EXE                                        */
/*   Purpose:      Wave Play/Record with DMA or PIO.               */
/*                 Reads/Writes WAVE format files direct to disk   */
/*                 Unlimited length.                               */
/*   Written by:   Richard Vail for Crystal Semiconductor          */
/*   History: 1.0  2/17/95:  Created by Dick Vail                  */
/*            1.01 3/10/95:  Added TIO - timer int driven pio      */
/*            1.1  3/15/95:  Added volume hot keys                 */
/*                                                                 */
/*******************************************************************/
#include <ctype.h>
#include <io.h>
#include <fcntl.h>
#include <conio.h>
#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <math.h>
#include <graph.h>

typedef unsigned char BYTE;
typedef unsigned int  WORD;
typedef unsigned long DWORD;

#define CS4231          0
#define CS4231A         1
#define CS4232          2
#define CS4232A         3

#define TRUE            1
#define FALSE           0

#define LEFT_COLOR      9               //blue
#define RIGHT_COLOR     12              //red

#define PLAY            1
#define RECORD          2
#define CAPTURE         3

#define STEREO          2
#define MONO            1

extern void ExitErrorMsg(char *);
extern struct _videoconfig vc;
extern int debug;
extern int toprow, leftcol, bottomrow, rightcol;
extern int clipleft;
extern int clipright;
extern int output_leftvol;
extern int output_rightvol;
extern int program_mode;
extern int full_duplex;
extern int peakscrolling;
extern int peakmonitor;
extern BYTE format_reg;
extern BYTE capture_format_reg;

BYTE bLeftMaxPeak=0, bRightMaxPeak=0;
int wLeftMaxPeak=0, wRightMaxPeak=0;

/******************************************************************/
void PEAKdisplay(WORD peaks, int nChannels)
{  register short lpeak, rpeak, i;
	BYTE bar1[80], bar2[80];
	short savecolor;
	struct rccoord savepos;

	savecolor = _settextcolor(LEFT_COLOR);
	if (peaks != 0)
	{  if (nChannels == MONO)
		{  lpeak = (peaks & 0x7F) * sizeof(bar1) / 100;//scale peak to bar size
			if ((program_mode==PLAY) && (full_duplex==0))
				lpeak = (lpeak * output_leftvol) / 100;
			for (i=0; i<sizeof(bar1); i++)
			{  if (i<lpeak)
					bar1[i] = 0xDE;
				else
					bar1[i] = 0x20;
			}
			if (lpeak == 0)
				bar1[0] = 0xDD;
			else if (lpeak >= sizeof(bar1))
				bar1[sizeof(bar1) - 1] = 0x10;
			if (clipleft)
			{  bar1[sizeof(bar1) - 1] = 0xDB;
				clipleft = 0;
			}
			if (peakscrolling)
				savepos = _settextposition(bottomrow, 1);
			else
				savepos = _settextposition(1, 1);
			_outmem((unsigned char _far *)bar1, sizeof(bar1));
		}
		else
		{  if (peakmonitor==1)     //outside in
			{  lpeak = ((peaks >> 8) & 0x7F) * (sizeof(bar1) / 2) / 100;//scale peak to bar size
				rpeak = (peaks & 0x7F) * (sizeof(bar1) / 2) / 100;//scale peak to bar size
				if ((program_mode==PLAY) && (full_duplex==0))
				{  lpeak = (lpeak * output_leftvol) / 100;
					rpeak = (rpeak * output_rightvol) / 100;
				}
				memset(bar1, 0x20, sizeof(bar1));
				memset(bar1, 0xDE, lpeak);
				memset(&bar1[sizeof(bar1) - rpeak], 0xDD, rpeak);
				if (lpeak == 0)
					bar1[0] = 0xDD;
				else if (lpeak >= (sizeof(bar1) / 2))
					bar1[(sizeof(bar1) / 2) - 1] = 0xDB;
				if (rpeak == 0)
					bar1[sizeof(bar1) - 1] = 0xDE;
				else if (rpeak >= (sizeof(bar1) / 2))
					bar1[(sizeof(bar1) / 2)] = 0xDB;
				if (clipleft)
				{  bar1[(sizeof(bar1) / 2) - 1] = 0x10;
					clipleft = 0;
				}
				if (clipright)
				{  bar1[(sizeof(bar1) / 2)] = 0x11;
					clipright = 0;
				}
				if (peakscrolling)
					savepos = _settextposition(bottomrow, 1);
				else
					savepos = _settextposition(1, 1);
				_outmem((unsigned char _far *)bar1, (sizeof(bar1) / 2));
				_settextcolor(RIGHT_COLOR);
				_outmem((unsigned char _far *)&bar1[(sizeof(bar1) / 2)], (sizeof(bar1) / 2));
			}
			else if (peakmonitor==2)        //middle out
			{  lpeak = ((peaks >> 8) & 0x7F) * (sizeof(bar1) / 2) / 100;//scale peak to bar size
				rpeak = (peaks & 0x7F) * (sizeof(bar1) / 2) / 100;//scale peak to bar size
				if ((program_mode==PLAY) && (full_duplex==0))
				{  lpeak = (lpeak * output_leftvol) / 100;
					rpeak = (rpeak * output_rightvol) / 100;
				}
				memset(bar1, 0x20, sizeof(bar1));
				memset(&bar1[(sizeof(bar1) /2) - lpeak], 0xDD, lpeak);
				memset(&bar1[sizeof(bar1) / 2], 0xDD, rpeak);
				if (lpeak == 0)
					bar1[(sizeof(bar1) / 2) - 1] = 0xDE;
				else if (lpeak >= (sizeof(bar1) / 2))
					bar1[0] = 0xDB;
				if (rpeak == 0)
					bar1[(sizeof(bar1) / 2)] = 0xDD;
				else if (rpeak >= (sizeof(bar1) / 2))
					bar1[sizeof(bar1) - 1] = 0xDB;
				if (clipleft)
				{  bar1[0] = 0x11;
					clipleft = 0;
				}
				if (clipright)
				{  bar1[sizeof(bar1) - 1] = 0x10;
					clipright = 0;
				}
				if (peakscrolling)
					savepos = _settextposition(bottomrow, 1);
				else
					savepos = _settextposition(1, 1);
				_outmem((unsigned char _far *)bar1, (sizeof(bar1) / 2));
				_settextcolor(RIGHT_COLOR);
				_outmem((unsigned char _far *)&bar1[(sizeof(bar1) / 2)], (sizeof(bar1) / 2));
			}
			else if (peakmonitor==3)        //two bar left side
			{  lpeak = ((peaks >> 8) & 0x7F) * sizeof(bar1) / 100;  //scale peak to bar size
				rpeak = (peaks & 0x7F) * sizeof(bar2) / 100;    //scale peak to bar size
				if ((program_mode==PLAY) && (full_duplex==0))
				{  lpeak = (lpeak * output_leftvol) / 100;
					rpeak = (rpeak * output_rightvol) / 100;
				}
				memset(bar1, 0xDE, lpeak);
				memset(bar2, 0xDE, rpeak);
				memset(&bar1[lpeak], 0x20, sizeof(bar1) - lpeak);
				memset(&bar2[rpeak], 0x20, sizeof(bar2) - rpeak);
				if (lpeak == 0)
					bar1[0] = 0xDD;
				else if (lpeak >= sizeof(bar1))
					bar1[sizeof(bar1) - 1] = 0xDB;
				if (rpeak == 0)
					bar2[0] = 0xDD;
				else if (rpeak >= sizeof(bar1))
					bar2[sizeof(bar2) - 1] = 0xDB;
				if (clipleft)
				{  bar1[sizeof(bar1) - 1] = 0x10;
					clipleft = 0;
				}
				if (clipright)
				{  bar2[sizeof(bar2) - 1] = 0x10;
					clipright = 0;
				}
				savepos = _settextposition(1, 1);
				_outmem((unsigned char _far *)bar1, sizeof(bar1));
				_settextposition(2, 1);
				_settextcolor(RIGHT_COLOR);
				_outmem((unsigned char _far *)bar2, sizeof(bar2));
			}
		}
	}
	else
	{  memset(bar1, 0x20, sizeof(bar1));
		savepos = _settextposition(1, 1);
		if (peakscrolling)
			_settextposition(bottomrow, 1);
		_outmem((unsigned char _far *)bar1, sizeof(bar1));
		if (peakmonitor==3)
		{  _settextposition(2, 1);
			_outmem((unsigned char _far *)bar1, sizeof(bar1));
		}
	}
	_settextposition(savepos.row, savepos.col);
	_settextcolor(savecolor);
}

/******************************************************************/
WORD getpeaks(BYTE _far *buffer, WORD buffersize)
{
// register WORD i, j;
	static BYTE log10[101]=
	{
//     0, 0,15,23,30,34,38,42,45,47,//actual
//    50,52,53,55,57,58,60,61,62,63,//actual
		 0, 3, 7,11,15,19,23,27,31,35,//smoothed
		39,43,47,51,55,58,60,61,62,63,//smoothed
		65,66,67,68,69,69,70,71,72,73,
		73,74,75,75,76,77,77,78,78,79,
		80,80,81,81,82,82,83,83,84,84,
		84,85,85,86,86,87,87,87,88,88,
		88,89,89,89,90,90,90,91,91,91,
		92,92,92,93,93,93,94,94,94,94,
		95,95,95,95,96,96,96,96,97,97,
		97,97,98,98,98,98,99,99,99,99,100
	};
	void PEAK4M(BYTE _far *buffer, WORD buffersize);
	void PEAK4S(BYTE _far *buffer, WORD buffersize);
	void PEAK8M(BYTE _far *buffer, WORD buffersize);
	void PEAK8S(BYTE _far *buffer, WORD buffersize);
	void PEAK8UM(BYTE _far *buffer, WORD buffersize);
	void PEAK8US(BYTE _far *buffer, WORD buffersize);
	void PEAK8AM(BYTE _far *buffer, WORD buffersize);
	void PEAK8AS(BYTE _far *buffer, WORD buffersize);
	void PEAK16M(BYTE _far *buffer, WORD buffersize);
	void PEAK16S(BYTE _far *buffer, WORD buffersize);

	switch ((full_duplex ? (capture_format_reg >> 4) : (format_reg >> 4)))
	{  case 0://linear 8bit pcm mono
			PEAK8M(buffer, buffersize);
//       for (i=0;i<buffersize;i++)
//       {  if (buffer[i] < 0x80)
//             bLeftMaxPeak = max(bLeftMaxPeak, 127 - buffer[i]);
//          else
//             bLeftMaxPeak = max(bLeftMaxPeak, buffer[i] & 0x7F);
//       }
			if (debug==2)
				printf("\n       bLeftMaxPeak=%2.2X return=%2.2X ", bLeftMaxPeak, log10[bLeftMaxPeak*100/128]);
			bLeftMaxPeak = log10[bLeftMaxPeak * 100 / 128];
			return(bLeftMaxPeak | 0x80);
		case 1://linear 8bit pcm stereo
			PEAK8S(buffer, buffersize);
//       for (i=0;i<buffersize;i+=2)
//       {  if (buffer[i] < 0x80)
//             bLeftMaxPeak = max(bLeftMaxPeak, 127 - buffer[i]);
//          else
//             bLeftMaxPeak = max(bLeftMaxPeak, buffer[i] & 0x7F);
//          if (buffer[i+1] < 0x80)
//             bRightMaxPeak = max(bRightMaxPeak, 127 - buffer[i+1]);
//          else
//             bRightMaxPeak = max(bRightMaxPeak, buffer[i+1] & 0x7F);
//       }
			if (debug==2)
			{  printf("\n       bLeftMaxPeak=%2.2X return=%2.2X ", bLeftMaxPeak, log10[bLeftMaxPeak*100/128]);
				printf("bRightMaxPeak=%2.2X return=%2.2X", bRightMaxPeak, log10[bRightMaxPeak*100/128]);
			}
			bLeftMaxPeak = log10[bLeftMaxPeak * 100 / 128];
			bRightMaxPeak = log10[bRightMaxPeak * 100 / 128];
			return(((WORD)bLeftMaxPeak << 8) | bRightMaxPeak | 0x8080);
		case 2://ulaw 8bit companded mono
			PEAK8UM(buffer, buffersize);
//       for (i=0;i<buffersize;i++)
//          bLeftMaxPeak = max(bLeftMaxPeak, 127 - (buffer[i] & 0x7F));
			if (debug==2)
				printf("\n       bLeftMaxPeak=%2.2X return=%2.2X ", bLeftMaxPeak, bLeftMaxPeak*100/128);
			bLeftMaxPeak = bLeftMaxPeak * 100 / 128;
			return(bLeftMaxPeak | 0x80);
		case 3://ulaw 8bit companded stereo
			PEAK8US(buffer, buffersize);
//       for (i=0;i<buffersize;i+=2)
//       {  bLeftMaxPeak = max(bLeftMaxPeak, 127 - (buffer[i] & 0x7F));
//          bRightMaxPeak = max(bRightMaxPeak, 127 - (buffer[i+1] & 0x7F));
//       }
			if (debug==2)
			{  printf("\n       bLeftMaxPeak=%2.2X return=%2.2X ", bLeftMaxPeak, bLeftMaxPeak*100/128);
				printf("bRightMaxPeak=%2.2X return=%2.2X", bRightMaxPeak, bRightMaxPeak*100/128);
			}
			bLeftMaxPeak = bLeftMaxPeak * 100 / 128;
			bRightMaxPeak = bRightMaxPeak * 100 / 128;
			return(((WORD)bLeftMaxPeak << 8) | bRightMaxPeak | 0x8080);
		case 4://linear 16bit pcm little endian mono
		case 12://linear 16bit pcm big endian mono
			PEAK16M(buffer, buffersize);
//       for (i=0,j=0,wbuffer=(int *)buffer;i<buffersize;i+=2,j++)
//          wLeftMaxPeak = max(wLeftMaxPeak, wbuffer[j]);
			if (debug==2)
				printf("\n       wLeftMaxPeak=%4.4X return=%4.4X ", wLeftMaxPeak, log10[wLeftMaxPeak*100L/32768L]);
			bLeftMaxPeak = log10[wLeftMaxPeak * 100L / 32768L];
			return(bLeftMaxPeak | 0x80);
		case 5://linear 16bit pcm little endian stereo
		case 13://linear 16bit pcm big endian stereo
			PEAK16S(buffer, buffersize);
//       for (i=0,j=0,wbuffer=(int *)buffer;i<buffersize;i+=4, j+=2)
//       {  wLeftMaxPeak = max(wLeftMaxPeak, wbuffer[j]);
//          wRightMaxPeak = max(wRightMaxPeak, wbuffer[j+1]);
//       }
			if (debug==2)
			{  printf("\n       wLeftMaxPeak=%4.4X return=%4.4X ", wLeftMaxPeak, log10[wLeftMaxPeak*100L/32768L]);
				printf("wRightMaxPeak=%4.4X return=%4.4X", wRightMaxPeak, log10[wRightMaxPeak*100L/32768L]);
			}
			bLeftMaxPeak = log10[wLeftMaxPeak * 100L / 32768L];
			bRightMaxPeak = log10[wRightMaxPeak * 100L / 32768L];
			return(((WORD)bLeftMaxPeak << 8) | bRightMaxPeak | 0x8080);
		case 6://alaw 8bit companded mono
			PEAK8AM(buffer, buffersize);
//       for (i=0;i<buffersize;i++)
//          bLeftMaxPeak = max(bLeftMaxPeak, 0x55 ^ buffer[i]);//approximation
			if (debug==2)
				printf("\n       bLeftMaxPeak=%2.2X return=%2.2X ", bLeftMaxPeak, bLeftMaxPeak*100/128);
			bLeftMaxPeak = bLeftMaxPeak * 100 / 128;
			return(bLeftMaxPeak | 0x80);
		case 7://alaw 8bit companded stereo
			PEAK8AS(buffer, buffersize);
//       for (i=0;i<buffersize;i+=2)
//       {  bLeftMaxPeak = max(bLeftMaxPeak, 0x55 ^ buffer[i]);//approximation
//          bRightMaxPeak = max(bRightMaxPeak, 0x55 ^ buffer[i+1]);
//       }
			if (debug==2)
			{  printf("\n       bLeftMaxPeak=%2.2X return=%2.2X ", bLeftMaxPeak, bLeftMaxPeak*100/128);
				printf("bRightMaxPeak=%2.2X return=%2.2X", bRightMaxPeak, bRightMaxPeak*100/128);
			}
			bLeftMaxPeak = bLeftMaxPeak * 100 / 128;
			bRightMaxPeak = bRightMaxPeak * 100 / 128;
			return(((WORD)bLeftMaxPeak << 8) | bRightMaxPeak | 0x8080);
		case 10://adpcm 4bit mono
			PEAK4M(buffer, buffersize);
			bLeftMaxPeak = log10[bLeftMaxPeak * 100 / 128];
			return(bLeftMaxPeak | 0x80);
		case 11://adpcm 4bit stereo
			PEAK4S(buffer, buffersize);
			bLeftMaxPeak = log10[bLeftMaxPeak * 100 / 128];
			bRightMaxPeak = log10[bRightMaxPeak * 100 / 128];
			return(((WORD)bLeftMaxPeak << 8) | bRightMaxPeak | 0x8080);
		case 8://reserved
		case 9://reserved
		case 14://reserved
		case 15://reserved
			printf("\nInvalid data format encountered.");
			return(0x8080);
	}
	return(0);
}


