//==========================================================================
//
//	title		: define functions to WOD
//	company		: YAMAHA
//	author		: Taichi Sugiyama
//	create Data : 30/Sep/99
//
//==========================================================================
#include "define.h"


static DWORD	dwDefSR[8] = {
			100, 2000, 8000, 11025, 16000, 22050, 32000, 48000
};


//#define	TRACE_WODPROC
#ifdef TRACE_WODPROC
#define	DPF(X)		cprintf("TRACE_WODPROC:");cprintf X
#define	dprintf(X)	cprintf X
#else
#define	DPF(X)
#define	dprintf(X)
#endif


//==========================================================================
//	calculate Format
//
//	argument
//		bChannel	: channel
//		bBit		: bit
//
//	return
//		Format
//
//==========================================================================
static DWORD	CalcFormat(BYTE bChannel, BYTE bBit)
{
	DWORD	dwFormat;

	dwFormat = 0x00000000;
	if(bChannel > 1)
		dwFormat |= 0x00010000;
	if(bBit < 16)
		dwFormat |= 0x80000000;

	return dwFormat;
}


//==========================================================================
//	calculate PgLoopEnd
//
//	argument
//		dwFormat		: format
//		dwBuffLength	: length of buffer
//
//	return
//		PgLoopEnd
//
//==========================================================================
static DWORD	CalcPgLoopEnd(DWORD dwFormat, DWORD dwBuffLength)
{
	DWORD	dwPgLoopEnd;

	dwPgLoopEnd = dwBuffLength;
	if(dwFormat & 0x00010000)
		dwPgLoopEnd >>= 1;
	if((dwFormat & 0x80000000) == 0x00000000)
		dwPgLoopEnd >>= 1;

	return dwPgLoopEnd;
}


//==========================================================================
//	calculate PgDelta
//
//	argument
//		dwSR	: sampling rate
//
//	return
//		PgDelat
//
//==========================================================================
static DWORD	CalcPgDelta(DWORD dwSR)
{
	double	lftmp;
	DWORD	dwPgDelta;

	lftmp = (double)dwSR/(double)DEF_SAMPLINGRATE;
	lftmp *= 1048576.0;		// lftmp * 2.0^20.0
	dwPgDelta = (DWORD)lftmp << 8;

	DPF(("dwPgDelta:%08lX\n\r", dwPgDelta));
	return dwPgDelta;
}


//==========================================================================
//	calculate LpfK
//
//	argument
//		dwSR	: sampling rate
//
//	return
//		LpfK
//
//==========================================================================
static DWORD	CalcLpfK(DWORD dwSR)
{
	DWORD	i;
	DWORD	dwLpfK;
	DWORD	dwVal[8] = {
		0x00570000, 0x06AA0000, 0x18B20000, 0x20930000, 
		0x2B9A0000, 0x35A10000, 0x3EAA0000, 0x40000000
	};


	if(dwSR == 44100)
		dwLpfK = 0x4646000;
	else {
		for(i=0; i<8; i++) {
			if(dwSR <= dwDefSR[i]) {
				dwLpfK = dwVal[i];
				break;
			}
		}
	}	

	return dwLpfK;
}


//==========================================================================
//	calculate LpfQ
//
//	argument
//		dwSR	: sampling rate
//
//	return
//		LpfQ
//
//==========================================================================
static DWORD	CalcLpfQ(DWORD dwSR)
{
	DWORD	i;
	DWORD	dwLpfQ;
	DWORD	dwVal[8] = {
		0x35280000, 0x34A70000, 0x32020000, 0x31770000, 
		0x31390000, 0x31C90000, 0x33D00000, 0x40000000
	};


	if(dwSR == 44100)
		dwLpfQ = 0x370A0000;
	else {
		for(i=0; i<8; i++) {
			if(dwSR <= dwDefSR[i]) {
				dwLpfQ = dwVal[i];
				break;
			}
		}
	}	

	return dwLpfQ;
}


//==========================================================================
//	setup WOD bank register
//
//	argument
//		pWod	: pointer to WOD information
//
//	return
//
//==========================================================================
void	SetupWodBankRegister(PWODINFO pWod)
{
	DWORD	i;
	DWORD	dwFormat;


	DPF(("SetupWodBankRegister")); 

	//	set bank1 & bank2
	for(i=0; i<2; i++) {
		dwFormat = CalcFormat(pWod->bChannel, pWod->bBit);

		//	44.1KHz
		if(pWod->dwSampling == 44100)
			dwFormat |= 0x10000000;

		pWod->lpWodBank[i]->dwFormat = dwFormat;					//	Format
		pWod->lpWodBank[i]->dwLoopDefault = 0x0000000;				//	LoopDefault
		pWod->lpWodBank[i]->dwPgBase = pWod->dwBuffBaseAdr;			//	PgBase
		pWod->lpWodBank[i]->dwPgLoop = 0x0000000;					//	PgLoop
		pWod->lpWodBank[i]->dwPgLoopEnd =	\
					 CalcPgLoopEnd(dwFormat, pWod->dwBuffLength);	//	PgLoopEnd
		pWod->lpWodBank[i]->dwPgLoopFrac = 0x00000000;				//	PgLoopFrac
		pWod->lpWodBank[i]->dwEgGainEnd = 0x40000000;				//	EgGainEnd
		pWod->lpWodBank[i]->dwLpfQ = CalcLpfQ(pWod->dwSampling);	//	LpfQ
		pWod->lpWodBank[i]->dwStatus = 0x00000000;					//	Status
		pWod->lpWodBank[i]->dwNumOfFrames = 0x00000000;				//	NumOfFrames
		pWod->lpWodBank[i]->dwLoopCount = 0x00000000;				//	LoopCount
		pWod->lpWodBank[i]->dwPgStart = 0x00000000;					//	PgStart
		pWod->lpWodBank[i]->dwPgStartFrac = 0x00000000;				//	PgStartFrac
		pWod->lpWodBank[i]->dwPgDelta = \
		pWod->lpWodBank[i]->dwPgDeltaEnd = CalcPgDelta(pWod->dwSampling);	//	PgDelat
		pWod->lpWodBank[i]->dwLpfK = \
		pWod->lpWodBank[i]->dwLpfKEnd = CalcLpfK(pWod->dwSampling);			//	LpfK
		pWod->lpWodBank[i]->dwEgGain = 0x40000000;					//	EgGain
		pWod->lpWodBank[i]->dwLpfD1 = \
		pWod->lpWodBank[i]->dwLpfD2 = 0x00000000;							//	LpfDx

		pWod->lpWodBank[i]->dwRchGain = 	\
		pWod->lpWodBank[i]->dwLchGain = 	\
		pWod->lpWodBank[i]->dwRchGainEnd = 	\
		pWod->lpWodBank[i]->dwLchGainEnd = 	\
		pWod->lpWodBank[i]->dwEffect1Gain = \
		pWod->lpWodBank[i]->dwEffect2Gain = \
		pWod->lpWodBank[i]->dwEffect3Gain = \
		pWod->lpWodBank[i]->dwEffect1GainEnd = \
		pWod->lpWodBank[i]->dwEffect2GainEnd = \
		pWod->lpWodBank[i]->dwEffect3GainEnd = 0x00000000;

		if(pWod->bChannel < 2) {
			switch(pWod->bLineFlag) {
				case 0: // main
					pWod->lpWodBank[i]->dwLchGain = \
					pWod->lpWodBank[i]->dwRchGain = \
					pWod->lpWodBank[i]->dwLchGainEnd = \
					pWod->lpWodBank[i]->dwRchGainEnd = 0x40000000;
					break;

				case 1:	// AC3
					pWod->lpWodBank[i]->dwEffect2Gain = \
					pWod->lpWodBank[i]->dwEffect3Gain = \
					pWod->lpWodBank[i]->dwEffect2GainEnd = \
					pWod->lpWodBank[i]->dwEffect3GainEnd = 0x40000000;
					break;


				default :	// front & 
					pWod->lpWodBank[i]->dwLchGain = \
					pWod->lpWodBank[i]->dwRchGain = \
					pWod->lpWodBank[i]->dwEffect2Gain = \
					pWod->lpWodBank[i]->dwEffect3Gain = \
					pWod->lpWodBank[i]->dwLchGainEnd = \
					pWod->lpWodBank[i]->dwRchGainEnd = \
					pWod->lpWodBank[i]->dwEffect2GainEnd = \
					pWod->lpWodBank[i]->dwEffect3GainEnd = 0x40000000;
					break;
			}
		}
		else {
			if(pWod->bChFlag) {
				pWod->lpWodBank[i]->dwFormat |= 0x00000001; 
				
				switch(pWod->bLineFlag) { // right channel
					case 0: // main
						pWod->lpWodBank[i]->dwRchGain = \
						pWod->lpWodBank[i]->dwRchGainEnd = 0x40000000;
						break;

					case 1:	// AC3
						pWod->lpWodBank[i]->dwEffect3Gain = \
						pWod->lpWodBank[i]->dwEffect3GainEnd = 0x40000000;
						break;


					default :	// front & 
						pWod->lpWodBank[i]->dwRchGain = \
						pWod->lpWodBank[i]->dwEffect3Gain = \
						pWod->lpWodBank[i]->dwRchGainEnd = \
						pWod->lpWodBank[i]->dwEffect3GainEnd = 0x40000000;
						break;
				}
			}
			else {
				switch(pWod->bLineFlag) { // left channel
					case 0: // main
						pWod->lpWodBank[i]->dwLchGain = \
						pWod->lpWodBank[i]->dwLchGainEnd = 0x40000000;
						break;

					case 1:	// AC3
						pWod->lpWodBank[i]->dwEffect2Gain = \
						pWod->lpWodBank[i]->dwEffect2GainEnd = 0x40000000;
						break;


					default :	// front & 
						pWod->lpWodBank[i]->dwLchGain = \
						pWod->lpWodBank[i]->dwEffect2Gain = \
						pWod->lpWodBank[i]->dwLchGainEnd = \
						pWod->lpWodBank[i]->dwEffect2GainEnd = 0x40000000;
						break;
				}
			}
		}
	}

	dprintf(("/End\n\r"));
}


//==========================================================================
//	fill WOD buffer
//
//	argument
//		lpbBuffer	: pointer to WOD buffer
//		dwLength	: fill size
//		pdinfo		: fill data information.
//
//	return
//		1, if no data
//
//==========================================================================
BYTE	fillWodBuffer(LPBYTE lpbBuffer, DWORD dwLength, PDATAINFO pdinf)
{
	BYTE	bTmp;
	DWORD	i;
	DWORD	dwDataSize;


	DPF(("\n\rfillWodBuff(%08lX/%08lX/%08lX)", dwLength, pdinf->dwDataSize, pdinf->dwRemain));

	bTmp = (pdinf->bBit > 8)? 0x00 : 0x80;
	dwDataSize = (DWORD)min(dwLength, pdinf->dwRemain);

	//---- fill 0 ----------------------------------------------------------
	for(i=0; i<dwLength; i++) {
		*(lpbBuffer + i) = bTmp;
	}

	//---- fill data -------------------------------------------------------
	for(i=0; i<dwDataSize; i++) {
		fread(&bTmp, sizeof(BYTE), 1, pdinf->fp);
		*(lpbBuffer + i) = bTmp;
		pdinf->dwRemain--;
	}

	if(pdinf->dwRemain == 0L) {
		dprintf(("/NoData/End\n\r"));
		return 1;
	}
	dprintf(("/End\n\r"));
	return 0;
}


//==========================================================================
//	WOD procedure
//
//	argument
//		phwi	: pointer to hardware information
//		pdinf	: pointer to data information
//
//	return
//
//==========================================================================
void	WodProc(PHWINFO phwi, PDATAINFO pdinf)
{
	BYTE			bQuit = 1;
	BYTE			bEndFlag = 0;
	BYTE			bBankFlag = 0;
	DWORD			i;
	DWORD			dwHalfSize;
	WODBANK far*	pWod;


	phwi->lpdWodCtrlTable[0] = (DWORD)pdinf->bChannel;
	for(i=0; i<pdinf->bChannel; i++) {
		phwi->wodinfo[i].bLineFlag = 0;
		phwi->wodinfo[i].bChFlag = i;
		phwi->wodinfo[i].bChannel = pdinf->bChannel;
		phwi->wodinfo[i].bBit = pdinf->bBit;
		phwi->wodinfo[i].dwSampling = pdinf->dwSampling;
		phwi->wodinfo[i].dwBuffBaseAdr = phwi->dwWodBuffBase;
		phwi->wodinfo[i].dwBuffLength = phwi->dwWodBuffByteSize;
		SetupWodBankRegister(&phwi->wodinfo[i]);
		phwi->lpdWodCtrlTable[i + 1] = phwi->wodinfo[i].dwBankBaseAdr;
	}

	//---- fill data -------------------------------------------------------
	fillWodBuffer(phwi->lpbWodBuffer, phwi->dwWodBuffByteSize, pdinf);

	//---- start playback --------------------------------------------------
	phwi->bIntFlag = 0x00;
	dwHalfSize = phwi->dwWodBuffByteSize >> 1;

	if(pdinf->dwSampling == 44100)
		Hw_WriteRegDword(phwi, YDSXGR_BUF441OUTVOL, 0x3FFF3FFF);
	else
		Hw_WriteRegDword(phwi, YDSXGR_NATIVEDACOUTVOL, 0x3FFF3FFF);

	Hw_Start(phwi);
	while(bQuit) {
		if(phwi->bIntFlag) {
			pWod = ((phwi->dwBankSelect) ? phwi->wodinfo[0].lpWodBank[1] : phwi->wodinfo[0].lpWodBank[0]);
			if(bBankFlag) {
				if(pWod->dwPgStart < (pWod->dwPgLoopEnd >> 1)) {
					if(fillWodBuffer(phwi->lpbWodBuffer + dwHalfSize, dwHalfSize, pdinf))
						bEndFlag++;
					bBankFlag = 0;
				}
			}
			else {
				if(pWod->dwPgStart >= (pWod->dwPgLoopEnd >> 1)) {
					if(fillWodBuffer(phwi->lpbWodBuffer, dwHalfSize, pdinf))
						bEndFlag++;
					bBankFlag = 1;
				}
			}
			cprintf(" remain    : %08lx\r", pdinf->dwRemain);
			phwi->bIntFlag = 0x00;
		}
		if(bEndFlag > 2) {
			bQuit = 0;
		}
		if(kbhit() && (getch() == 0x1B)) {
			bQuit = 0;
		}
	}
	Hw_WriteRegDword(phwi, YDSXGR_NATIVEDACOUTVOL, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_BUF441OUTVOL, 0x00000000);
	Hw_Stop(phwi);
}
