//==========================================================================
//
//	title		: define functions to interrupt
//	company		: YAMAHA
//	author		: Taichi Sugiyama
//	create Data : 30/Sep/99
//
//==========================================================================
#include <dos.h>
#include <string.h>
#include "dpmi.h"
#include "define.h"


extern	HWINFO	hwi;
extern void	__interrupt rmhandler( void );


#define TRACE_INTPROC
#ifdef TRACE_INTPROC
#define	DPF(X)		cprintf("TRACE_INTPROC:");cprintf X
#define	dprintf(X)	cprintf X
#else
#define	DPF(X)
#define	dprintf(X)
#endif


//==========================================================================
//	end of interrupt
//
//	argument
//		bIrq	: interrupt number
//
//	return
//
//==========================================================================
void	eoi( BYTE  bIrq )
{
	if ( bIrq > 7 )
		outp( 0xA0, 0x20 );
	outp( 0x20, 0x20 );
}


//==========================================================================
//	setup interrupt
//
//	argument
//		phwi	: pointer to hardware information
//
//	return
//		everytime 0
//
//==========================================================================
void	(interrupt far NativeIntProc)(void)
{
	DWORD	dwStatus;

	dwStatus = Hw_ReadRegDword(&hwi, YDSXGR_STATUS);
	if(dwStatus & 0x80000000) {
		Hw_WriteRegDword(&hwi, YDSXGR_STATUS, 0x80000000);
		dwStatus = Hw_ReadRegDword(&hwi, YDSXGR_MODE);
		Hw_WriteRegDword(&hwi, YDSXGR_MODE, (DWORD)(dwStatus | 0x00000002));
		hwi.bIntFlag |= YDSXG_DEFINT;
		hwi.dwBankSelect = Hw_ReadRegDword(&hwi, YDSXGR_CTRLSELECT);
	}

	dwStatus = Hw_ReadRegDword(&hwi, YDSXGR_INTFLAG);
	if(dwStatus & 0x00000001) {
		Hw_WriteRegDword(&hwi, YDSXGR_INTFLAG, 0xFFFFFFFF);
		hwi.bIntFlag |= YDSXG_TIMERINT;
	}

	if(hwi.bIntFlag) {
		eoi(hwi.bIrq);
	}
	else {
		*(hwi.lpwPassFlag) = 0;
		hwi.lpOldFunc();
	}
}


//==========================================================================
//	setup interrupt
//
//	argument
//		phwi	: pointer to hardware information
//
//	return
//		everytime 0
//
//==========================================================================
int	SetupInterrupt(PHWINFO phwi)
{
	BYTE	bNum;
	BYTE	bAdr;
	BYTE	bVectAdr;
	WORD	wSeg;
	void*	lpvFunc;


	if(phwi->bIrq > 7) {
		bNum = phwi->bIrq - 8;
		bAdr = 0xA1;
		bVectAdr = 0x70 + bNum;
	}
	else {
		bNum = phwi->bIrq;
		bAdr = 0x21;
		bVectAdr = 0x08 + bNum;
	}

	_disable();
	phwi->bOldMask = inp(bAdr);
	outp(bAdr, phwi->bOldMask & ~(1 << bNum));
	phwi->lpOldFunc = _dos_getvect(bVectAdr);
	_dos_setvect(bVectAdr, NativeIntProc);

	//---- protect mode vector ----------------------------------------
	phwi->lpOldFunc20 = _dos_getvect(0x20);
	sprintf(phwi->bNewFunc20, "%c%c%c", 0xCD, bVectAdr, 0xCF );
	_dos_setvect(0x20, (void( interrupt far*)())phwi->bNewFunc20);

	//---- real mode vector -------------------------------------------
	DPMIAllocRMMemory(0x8, &wSeg, &phwi->wIntSel);
	lpvFunc = (void *)((DWORD)wSeg << 4);
	memcpy(lpvFunc, (void*)rmhandler, 0x80);
	DPMIGetRMVector(bVectAdr, &phwi->wIntRMSeg, &phwi->wIntRMOff);
	DPMISetRMVector(bVectAdr, wSeg, 0L);

	*(WORD*)(((DWORD)wSeg << 4 ) + 0x74) = phwi->wIntRMSeg;
	*(WORD*)(((DWORD)wSeg << 4 ) + 0x72) = phwi->wIntRMOff;
	phwi->lpwPassFlag = (WORD*)(((DWORD)wSeg << 4) + 0x70);
	*phwi->lpwPassFlag = 0;

	_enable();

	return 0;
}


//==========================================================================
//	uninstall interrupt
//
//	argument
//		phwi	: pointer to hardware information
//
//	return
//		everytime 0
//
//==========================================================================
int	UninstallInterrupt(PHWINFO phwi)
{
	BYTE	bNum;
	BYTE	bAdr;
	BYTE	bVectAdr;


	if(phwi->bIrq > 7) {
		bNum = phwi->bIrq - 8;
		bAdr = 0xA1;
		bVectAdr = 0x70 + bNum;
	}
	else {
		bNum = phwi->bIrq;
		bAdr = 0x21;
		bVectAdr = 0x08 + bNum;
	}

	_disable();
	_dos_setvect(bVectAdr, phwi->lpOldFunc);
	_dos_setvect(0x20, phwi->lpOldFunc20);
	DPMISetRMVector(bVectAdr, phwi->wIntRMSeg, phwi->wIntRMSeg);
	DPMIFreeRMMemory(phwi->wIntSel);
	outp(bAdr, phwi->bOldMask);
	_enable();

	return 0;
}
