// This Code is for hardware function demonstration purposes only
// Leipzig 02-19-98 (c) 1998 marian GbR Leipzig

VxD_LOCKED_CODE_SEG

;------------------------------------------------------------------------------
; Interrupt Serviceroutine
;
; ENTRY:
;       EAX = IRQ Handle
;       EBX = Current VM Handle
;       EDX = ggf. reference data = Card instance
;
;------------------------------------------------------------------------------

BeginProc VxD_ISR, HIGH_FREQ


        cli

   ; Reset Interrupt Request Signal at Card

        mov       EDI,[EDX+TCard.Control]
        mov       ECX,[EDX+TCard.CtrlStat]
        or        ECX,IntReset
        mov       [EDI],ECX
        and       ECX, NOT IntReset
        mov       [EDI],ECX

    ; Free Interrupt at Mainboard INT Controller

        VxDcall   VPICD_Phys_EOI

    ; Check Software IntDisabled

        cmp       [EDX+TCard.IntDisabled],0
        jne       ISR_Err_DI

    ; Check Reentrance Flag

        cmp       [EDX+TCard.IntInUse],True
        je short  ISR_Err_IU

    ; Set Reentrance Flag

        mov       [EDX+TCard.IntInUse],True

        sti

ISR_Process:
        inc       [EDX+TCard.IntCount]

        push      EDX
        pCall     DATATRANSFER,EDX
        pop       EDX

        cli
        mov       [EDX+TCard.IntInUse],False

ISR_Done:
        clc
        sti
        ret

EndProc VxD_ISR

VxD_LOCKED_CODE_ENDS

