##************************************************************************
##**
##**  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
##**  ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED
##**  TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR
##**  A PARTICULAR PURPOSE.
##**
##**  Copyright (C) 1993 - 1995 Microsoft Corporation. All Rights Reserved.
##**
##**  makefile
##**
##**  to build a debug version:
##**       NMAKE
##**  to build a non debug version:
##**       NMAKE DEBUG=NO
##**
##**  HISTORY:
##**     04/12/94       created.
##**
##************************************************************************

!ifdef MASTER_MAKE
BUILD_BITS=16
BUILD_TYPE=mmedia
!INCLUDE $(DDKROOT)\master.mk
!endif


INCLUDES=-I..\..\inc

SUBDIR  =mydll
BASE    =k1212wav
NAME    =K1212WAV
EXT     =drv
GOALS   =$(NAME).$(EXT) $(NAME).sym
LIBS    =mmsystem.lib
OBJS    =wid.obj     \
         wod.obj     \
         init.obj    \
         drvproc.obj


AINCS =
CINCS =

!if "$(DEBUG)" == "NO"
COPT    = $(DEF) 
AOPT    = $(DEF)
LOPT    = 
!else
COPT    =-Zi -DDEBUG $(DEF)
AOPT    =-Zi -DDEBUG  $(DEF)
LOPT    =
!endif

# rc -r cmd line is really close to the 128-byte limit, so changed 0x0004L to 4L
ROPT =  $(DEF) /dDS_CONTEXTHELP^=0x2000L #from sdk\inc32\winuser.h

CC      =cl -c -W3 -nologo -Oxws -Zp -Gs $(COPT) -DIS_16 $(INCLUDES)
ASM     =ml -c -Zm -D?QUIET -D?MEDIUM $(AOPT) -DIS_16 $(INCLUDES)
LINK    =link $(LOPT) /ALIGN:16 /OUT:$(NAME).$(EXT) /MAP /DEF:..\K1212WAV.DEF
RC      =rc -r $(ROPT) -DIS_16 $(INCLUDES)
RCLINK  =rc $(ROPT) $(INCLUDES)

goal: makedir $(GOALS)

makedir:
   @md $(SUBDIR) >nul
   @cd $(SUBDIR)
        

init.obj        : ..\$*.c
        @$(CC) ..\$*.c

drvproc.obj     : ..\$*.c
        $(CC) ..\$*.c

wid.obj        : ..\$*.c
        $(CC) ..\$*.c

wod.obj        : ..\$*.c
        $(CC) ..\$*.c


$(NAME).res:  ..\$(BASE).rc ..\$(BASE).rcv
        $(RC) -fo$@ ..\$(BASE).rc

$(NAME).$(EXT) $(NAME).map: $(OBJS) ..\$(NAME).def $(NAME).res
        $(LINK) @<<
$(OBJS)
$(LIBS)
<<
        $(RCLINK) $*.res $*.$(EXT)

$(NAME).sym: $(NAME).map
        mapsym $(NAME).map


clean:
   -@cd $(SUBDIR)
        -@del *.obj
        -@del *.pdb
        -@del *.map
        -@del *.sym
        -@del $(NAME).$(EXT)
        -@del *.res
   -@cd..
   -@rd $(SUBDIR)
