//*****************************************************************************
//* Name:
//*      1212pci.c
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file contains the definitions of PCI specific functions.
//*
//* Modification Log:
//*
//*      1.1   11/21/96 Bill
//*      Initial version created.  
//*
//*
//* Copyright (c) 1996 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#include <vtoolsc.h>
#include <vmm.h>
#include <debug.h>
#include <vmmreg.h>
#include <configmg.h>

#ifndef  K1212CARD_H
#include "1212card.h"
#endif
#ifndef  K1212CFG_H
#include "1212cfg.h"
#endif
#ifndef  K1212CM_H
#include "1212cm.h"
#endif
#ifndef  K1212PCI_H
#include "1212pci.h"
#endif



//*************************************************************************
//*
//* GetPCIConfigData 
//*
//* This function loads the PCI configuration space into the memory
//* space pointed to by ConfigDataBuffer.
//* 
//* Exported.
//*
//* Returns:    Standard config manager return value.
//*
//*************************************************************************
CONFIGRET GetPCIConfigData(DEVNODE  Devnode, 
                           DWORD    StartByteOffset, 
                           DWORD*   ConfigDataBuffer, 
                           ULONG    nBytes)
{
   return CONFIGMG_Call_Enumerator_Function(Devnode, 
                                            PCI_ENUM_FUNC_GET_DEVICE_INFO,
                                            StartByteOffset,
                                            ConfigDataBuffer,
                                            nBytes,
                                            0
          );
}



//*************************************************************************
//*
//* SetPCIConfigData 
//*
//* This function Writes the PCI configuration space from the memory
//* buffer pointed to by ConfigDataBuffer.
//* 
//* Exported.
//*
//* Returns:    Standard config manager return value.
//*
//*************************************************************************
CONFIGRET SetPCIConfigData(DEVNODE  Devnode, 
                           DWORD    StartByteOffset, 
                           DWORD*   ConfigDataBuffer, 
                           ULONG    nBytes)
{
   return CONFIGMG_Call_Enumerator_Function(Devnode, 
                                            PCI_ENUM_FUNC_SET_DEVICE_INFO,
                                            StartByteOffset,
                                            ConfigDataBuffer,
                                            nBytes,
                                            0
          );
}



#ifdef DEBUG
//*************************************************************************
//*
//* PrintPCIConfigData 
//*
//* This function Writes the PCI configuration space from the memory
//* buffer pointed to by ConfigDataBuffer.
//* 
//* Exported.
//*
//* Returns:    Nothing
//*
//*************************************************************************
void PrintPCIConfigData(PCI_CONFIG_HEADER_0 ConfigData)
{
   Debug_Printf_Service("\nKorg 1212 Driver: PCI Config space is:\n");
   Debug_Printf_Service("  VendorID\t=\t%04x\tDeviceID=\t%04x\n", 
                        ConfigData.VendorID, 
                        ConfigData.DeviceID
   );
   Debug_Printf_Service("  Command\t=\t%04x\tStatus\t=\t%04x\n", 
                        ConfigData.Command, 
                        ConfigData.Status
   );
   Debug_Printf_Service("  RevisionID\t=\t%02x\tProgIf\t=\t%02x\n",
                        ConfigData.RevisionID,
                        ConfigData.ProgIf
   );
   Debug_Printf_Service("  SubClass\t=\t%02x\tBaseClass =\t%02x\n", 
                        ConfigData.SubClass, 
                        ConfigData.BaseClass
   ); 
   Debug_Printf_Service("  CacheLineSize\t=\t%02x\n", 
                        ConfigData.CacheLineSize
   );
   Debug_Printf_Service("  LatencyTimer\t=\t%02x\n", 
                        ConfigData.LatencyTimer
   );
   Debug_Printf_Service("  HeaderType\t=\t%02x\n", 
                        ConfigData.HeaderType
   );  
   Debug_Printf_Service("  BIST\t\t=\t%02x\n",
                        ConfigData.BIST
   );         
   Debug_Printf_Service("  BaseAddresses[0],[1] =\t%08x %08x\n", 
                        ConfigData.BaseAddresses[0], 
                        ConfigData.BaseAddresses[1]
   );
   Debug_Printf_Service("  BaseAddresses[2],[3] =\t%08x %08x\n", 
                        ConfigData.BaseAddresses[2], 
                        ConfigData.BaseAddresses[3]
   );
   Debug_Printf_Service("  BaseAddresses[4],[5] =\t%08x %08x\n", 
                        ConfigData.BaseAddresses[4], 
                        ConfigData.BaseAddresses[5]
   );
   Debug_Printf_Service("  CardBusCISPtr\t=\t%08x\n", 
                        ConfigData.CardBusCISPtr
   );
   Debug_Printf_Service("  SubsystemVendorID =\t%04x\n", 
                        ConfigData.SubsystemVendorID
   );
   Debug_Printf_Service("  SubsystemID\t=\t%04x\n", 
                        ConfigData.SubsystemID
   );
   Debug_Printf_Service("  ROMBaseAddress =\t%08x\n", 
                        ConfigData.ROMBaseAddress
   );
   Debug_Printf_Service("  InterruptLine\t=\t%02x\n", 
                        ConfigData.InterruptLine
   );
   Debug_Printf_Service("  InterruptPin\t=\t%02x\n", 
                        ConfigData.InterruptPin
   );
   Debug_Printf_Service("  MinimumGrant\t=\t%04x\n", 
                        ConfigData.MinimumGrant
   ); 
   Debug_Printf_Service("  MaximumLatency =\t%04x\n", 
                        ConfigData.MaximumLatency
   );
}
#endif  // DEBUG

#pragma warning (default:4100)      // Parameter unused



