#ifndef _IWCORE_H
#define _IWCORE_H
//#############################################################################
//
//  Remarks: This files defines DDK variable "iw" which is to hold resource
//           data and operational data for DDK applications. This variable
//           is of type IWAVE. The data stored here will be IO space, DMA
//           and IRQ information and vectors to callback functions registered
//           by a DDK application. This variable "iw" is the heart of a
//           DDK application. It is initialized here to default values that
//           correspond to the old Gravis UltraMax board. The codec is based
//           at 0x32C, the synth at 0x320, sound blaster base is at 0x220,
//           the record and play dma channels are defaulted to 1, the synth
//           IRQ line is defaulted to 11, the MIDI IRQ line is defaulted to
//           5. All callback vectors are set to point to the default function.
//
//#############################################################################
IWAVE iw={
	0,                      // InterWave stat flags
	0x32C,                  // Default Base Port for Codec
	0x170,                  // Default Base Port for External Device
	0x220,                  // Default Compatibility Base Port
	0x320,                  // MIDI and Synth Base Port (P3XR)
	0x300,                  // Gen Purpose Reg. 1 Address Register (P401AR)
	0x201,                  // Game Ctrl normally at 0x201
	0x376,                  // Base for ATAPI I/O Space
	0x388,                  // Base port for AdLib. It should be 0x388
	0x203,                  // Default PnP read data port
	0x323,                  // Default Gen Index Reg at P3XR+0x03
	0x324,                  // Default 16-bit data port at P3XR+0x04
	0x325,                  // Default 8-bit data port at P3XR+0x05
	0x322,                  // Synth Voice Select at P3XR+0x02 
	0x32D,                  // Codec Indexed Data Port at PCODAR+0x01
	0x32E,                  // Codec Stat Reg 1 at PCODAR+0x02 
	0x32F,                  // Playback or Record Data Reg at PCODAR+0x03
	0x320,                  // GMCR or GMSR at P3XR+0x00
	0x321,                  // GMTDR or GMRDR at P3XR+0x01
	0x327,                  // LMBDR at P3XR+0x07 (LMBDR)
	0,                      // Card Select Number
	0x6C,                   // Codec Operation Mode
	1,                      // DMA Chan 1 (local mem/sys & codec record)
	1,                      // DMA Chan 2 (codec play)
	0,                      // Ext Dev DMA channel
	14,                     // Number of voices
	0L,                     // Vendor ID and Product Identifier
	(DMA  *)NULL,           // Pointer to Chan 1 DMA structure
	(DMA  *)NULL,           // Pointer to Chan 2 DMA structure
	(DMA  *)NULL,           // Pointer to Ext Dev Chan DMA structure
	7,                      // Synth IRQ number 
	5,                      // MIDI IRQ number
	15,                     // Ext Dev IRQ 
	0,                      // MPU401 Dev IRQ number
	0,                      // Blaster/AdLib IRQ number
	(IRQ  *)NULL,           // Pointer to Synth IRQ structure
	(IRQ  *)NULL,           // Pointer to MIDI IRQ structure
	(IRQ  *)NULL,           // Pointer to Ext Dev IRQ structure
	0x00000000,             // Address of First Free LM Block
	0L,                     // Amount of LM reserved by app.
	0,                      // Synth Mode
	0,                      // Total LM in Kbytes
#ifdef __HIGHC__
	(_real_int_handler_t)0, // Old synth real-mode Interrrupt address
	(_real_int_handler_t)0, // Old midi real-mode Interrrupt address
#endif
#ifdef __PHARL__
	0L,                     // Old synth real-mode vector
	0L,                     // Old midi real-mode vector
	{0L,0},                 // FARPTR to Synth Handler
	{0L,0},                 // FARPTR to Midi Handler
#else
	(PVI)NULL,              // Old Synth Interrupt Address
	(PVI)NULL,              // Old MIDI Interrupt Vector
#endif
#ifndef __SC__
	(PFV)IwaveDefFunc,      // midi_mx_func vector
	(PFV)IwaveDefFunc,      // midi_rcv_func vector
	(PFV)IwaveDefFunc,      // timer1_func vector
	(PFV)IwaveDefFunc,      // timer2_func vector
	(PFV)IwaveDefFunc,      // wavetable_func vector
	(PFV)IwaveDefFunc,      // volume_func vector
	(PFV)IwaveDefFunc,      // play_dma_func vector
	(PFV)IwaveDefFunc,      // rec_dma_func vector
	(PFV)IwaveDefFunc,      // ext_dma_func vector
	(PFV)IwaveDefFunc,      // codec_timer_func vector
	(PFV)IwaveDefFunc,      // codec_play_func vector
	(PFV)IwaveDefFunc,      // codec_rec_func vector
#else
	(PFA)IwaveDefFunc,      // midi_mx_func vector
	(PFA)IwaveDefFunc,      // midi_rcv_func vector
	(PFA)IwaveDefFunc,      // timer1_func vector
	(PFA)IwaveDefFunc,      // timer2_func vector
	(PFA)IwaveDefFunc,      // wavetable_func vector
	(PFA)IwaveDefFunc,      // volume_func vector
	(PFA)IwaveDefFunc,      // play_dma_func vector
	(PFA)IwaveDefFunc,      // rec_dma_func vector
	(PFA)IwaveDefFunc,      // ext_dma_func vector
	(PFA)IwaveDefFunc,      // codec_timer_func vector
	(PFA)IwaveDefFunc,      // codec_play_func vector
	(PFA)IwaveDefFunc,      // codec_rec_func vector
#endif
};
#endif
