//#######################################################################
// FILE: iwcc.h
//#######################################################################
#ifndef __IWCC_H__
#define __IWCC_H__

#ifdef __SC__
#define SYMANTEC
#endif

#ifdef _MSC_VER
#define MSOFTC
#endif
//##########################################################################
//  BORLAND C
//##########################################################################
#ifdef __BORLANDC__
#ifdef __MSDOS__            //16-bit compiler
#define __BC16__
#define ENTER_CRITICAL          asm pushf; asm cli;
#define ENTER_CRITICAL_ON       asm pushf; asm sti;
#define LEAVE_CRITICAL          asm popf;
#define LEAVE_CRITICAL_ON LEAVE_CRITICAL
#define INTERRUPT               static void interrupt
#endif
#ifdef __FLAT__             //32-bit compiler
#pragma off(check_stack)
#define __BC32__
#define __PHARL__           //PharLap's TNT DOS Extender
#define PROTECTED_MODE
#define FLAT_MODEL
#define ENTER_CRITICAL      EnterCritical()    // Defined in iwpharl.asm
#define LEAVE_CRITICAL      LeaveCritical()
#define _peek  PharPeek                        // Defined in iwpharl.asm
#define _peekw PharPeekW
#define _poke  PharPoke
#define _pokew PharPokeW
#define far
#define INTERRUPT static void
#endif
#endif
//##########################################################################
//  SYMANTEC C/C++ Version 6.1
//##########################################################################
#ifdef __SC__
#define far                     __far
#define FAR                     __far
#if __INTSIZE == 4
#define far
#define FAR  						  
#define FLAT_MODEL
#define PROTECTED_MODE
#define __DOS_MEMORY__
#define __SC_PROTECT__
#define REGS                    _REGS
#define farmalloc               malloc
#define farfree                 free
#define AX(r)                   ((r).e.eax)
#define BX(r)                   ((r).e.ebx)
#define CX(r)                   ((r).e.ecx)
#define DX(r)                   ((r).e.edx)
#define SI(r)                   ((r).e.esi)
#define DI(r)                   ((r).e.edi)
#endif
#define INTERRUPT               static void far
#define ENTER_CRITICAL          asm pushf; asm cli;
#define LEAVE_CRITICAL          asm popf;
#endif
//##########################################################################
//  MICROSOFT C COMPILERS
//##########################################################################
#ifdef MSOFTC
#define asm                  _asm
#define interrupt            _interrupt
#define far                  _far
#define FAR                  _far
#define ENTER_CRITICAL       _asm pushf; _asm cli;
#define ENTER_CRITICAL_ON    _asm pushf; _asm sti;
#define LEAVE_CRITICAL       _asm popf;
#define LEAVE_CRITICAL_ON    LEAVE_CRITICAL
#define INTERRUPT            static void _interrupt _far
#undef  FLAT_MODEL
#define farmalloc            _fmalloc
#define farfree              _ffree
#endif
//##########################################################################
//  WATCOM C COMPILER
//##########################################################################
#ifdef __WATCOMC__
#define far             __far
#ifdef __FLAT__
#undef  far
#define far  
#define FAR
#define FLAT_MODEL
#define PROTECTED_MODE
#define __DOS_MEMORY__
#define farmalloc       malloc
#define farfree         free
#else
#endif
#define interrupt       __interrupt
#define INTERRUPT       static void __interrupt __far
#define ENTER_CRITICAL IRQ_PUSH_OFF()
#define AX(r)           ((r).x.eax)
#define BX(r)           ((r).x.ebx)
#define CX(r)           ((r).x.ecx)
#define DX(r)           ((r).x.edx)
#define SI(r)           ((r).x.esi)
#define DI(r)           ((r).x.edi)
#define _peek  inp
#define _peekw inpw
#define _poke  outp
#define _pokew outpw
extern void IRQ_PUSH_OFF (void);
#pragma aux IRQ_PUSH_OFF =      \
    "pushfd",                   \
    "cli";
#define ENTER_CRITICAL_ON IRQ_PUSH_ON()
extern void IRQ_PUSH_ON (void);
#pragma aux IRQ_PUSH_ON =       \
    "pushfd",                   \
    "sti";
#define LEAVE_CRITICAL IRQ_POP()
extern void IRQ_POP (void);
#pragma aux IRQ_POP =   \
    "popfd";
#define LEAVE_CRITICAL_ON LEAVE_CRITICAL
#endif
//##########################################################################
//  METAWARE'S HIGH C COMPILER
//##########################################################################
#ifdef __HIGHC__
#define __PHARL__
#define _peek  _inp
#define _peekw _inpw
#define _poke  _outp
#define _pokew _outpw
#define farfree         free
#define farmalloc       malloc
#pragma On (Globals_volatile)
#define far                     _Far
#define FAR                     
#define INTERRUPT               _Far _INTERRPT void
#define FLAT_MODEL
#define PROTECTED_MODE
#define OPCODE_NOP              0x90
#define OPCODE_PUSHF            0x9c
#define OPCODE_CLI              0xfa
#define OPCODE_STI              0xfb
#define OPCODE_POPF             0x9d
#define ENTER_CRITICAL          _inline(OPCODE_PUSHF);\
										  _inline(OPCODE_CLI);
#define ENTER_CRITICAL_ON       _inline(OPCODE_PUSHF);\
										  _inline(OPCODE_STI);
#define LEAVE_CRITICAL          _inline(OPCODE_POPF);
#endif
#endif
