// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#ifndef _SHARED_H_
#define _SHARED_H_

#define PC_IMPLEMENTATION 1

#include <portcls.h>
#include <stdunk.h>
#include "drvdbg.h"

//
// standard Digigram includes
//
#include "pcxini_e.h"

#define MAX_STREAM  32
#define DS_FAKED_APPINDEX   0


// use same as AC97 (could be max 1FFFFF)
#define MAX_DSBUFF_SIZE     0x1FFFFF

/*****************************************************************************
 * Structures and Typedefs
 */

typedef struct _SUB_DEVICE_INFO {
    PWCHAR waveName;
    PWCHAR topoName;
    WORD  channelFirst;
    WORD  channelCount;
    GUID  deviceNameGuid;
} SUB_DEVICE_INFO, * PSUB_DEVICE_INFO;

//
// Pin Defininition goes here
// We define all the possible pins in the AC97 CoDec and some "virtual" pins
// that are used for the topology to connect special functionality like 3D.
//
enum TopoPins
{
	// Dests
    PIN_LINEOUT = 0,

    // Sources
    PIN_WAVEOUT_SOURCE,

#define  PIN_WAVEOUT_NUMBER     2

    // Sources
    PIN_DIGITALIN,

    // Dests
    PIN_WAVEIN_DEST,

#define  PIN_WAVEIN_NUMBER      2

    PIN_TOP_ELEMENT,            // number of pins
    PIN_INVALID
};

#ifdef DBG_VIEWER
// In case we print some debug information about the pins, we use the names
// defined here.
const PCHAR TopoPinStrings[] =
{
    "PIN_LINEOUT",

    "PIN_WAVEOUT_SOURCE",

    "PIN_DIGITALIN",

    "PIN_WAVEIN_DEST",

    "PIN_TOP_ELEMENT",              // should never dump this
    "PIN_INVALID"                   // or this either
};
#endif


//
// Node Definition goes here.
// We define all the possible nodes here (nodes are black boxes that represent
// a functional block like bass volume) and some virtual nodes, mainly volume
// controls, that are used to represent special functionality in the topology
// like 3D controls (exposed as volumes) or to give the user volume controls
// for each possible record line. In that case, the volume is placed in front
// of the record selector (mux). The topology is not parsed correctly if there
// are no volume controls between the pins and a muxer. Also, these virtual
// controls only represent volumes and no mutes, cause mutes wouldn't be dis-
// played by sndvol32.
// ATTN: DON'T  change without first looking at the table in ac97reg.h!!!
//
enum TopoNodes
{
    NODE_MASTEROUT_VOLUME = 0,
    NODE_MASTEROUT_MUTE,

#define NODE_WAVEOUT_NUMBER     2

    NODE_DIGITALIN_VOLUME,
    NODE_INPUT_SELECT,

#define NODE_WAVEIN_NUMBER      2

    NODE_TOP_ELEMENT,       // number of nodes
    NODE_INVALID
};

#ifdef DBG_VIEWER
// In case we print some debug information about the nodes, we use names
// defined here.
const PCHAR NodeStrings[] =
{
    "MASTEROUT_VOLUME",
    "MASTEROUT_MUTE",

    "DIGITALIN_VOLUME",
    "INPUT_SELECT",

    "TOP_ELEMENT",      // should never dump this
    "INVALID"           // or this
};
#endif

//
// The pins used for the wave miniport connection.
//
enum WavePins
{
    WAVE_PIN_WAVEOUT = 0,

    WAVE_PIN_WAVEOUT_BRIDGE,

#define WAVE_PIN_WAVEOUT_NUMBER     2

    WAVE_PIN_WAVEIN_BRIDGE,

    WAVE_PIN_WAVEIN,

#define WAVE_PIN_WAVEIN_NUMBER      2

    WAVE_PIN_TOP_ELEMENT,               // number of pins

    WAVE_PIN_INVALID
};


#ifdef DBG_VIEWER
// In case we print some debug information about the pins, we use the names
// defined here.
const PCHAR WavePinStrings[] =
{
    "WAVE_PIN_WAVEOUT",

    "WAVE_PIN_WAVEOUT_BRIDGE",

    "WAVE_PIN_WAVEIN_BRIDGE",

    "WAVE_PIN_WAVEIN",

    "TOP_ELEMENT",              // should never dump this
    "INVALID"                   // or this either
};
#endif

//
// The nodes used for the wave miniport connection.
//

enum WaveNodes
{
    WAVE_NODE_WAVEOUT_DAC = 0,

#define WAVE_NODE_WAVEOUT_NUMBER    1

    WAVE_NODE_WAVEIN_ADC,

#define WAVE_NODE_WAVEIN_NUMBER     1

    WAVE_NODE_TOP_ELEMENT,      // should never dump this
    WAVE_NODE_INVALID           // or this
};

#ifdef DBG_VIEWER
const PCHAR WaveNodeStrings[] =
{
    "NODE_WAVEOUT_DAC",

    "NODE_WAVEIN_ADC",

    "TOP_ELEMENT",      // should never dump this
    "INVALID"           // or this
};
#endif

/*****************************************************************************
 * Function prototypes
 */

class CMiniportWaveICH;

/*****************************************************************************
 * NewAdapterCommon()
 *****************************************************************************
 * Create a new adapter common object.
 */
NTSTATUS NewAdapterCommon
(
    OUT     PUNKNOWN *  Unknown,
    IN      REFCLSID,
    IN      PUNKNOWN    UnknownOuter    OPTIONAL,
    IN      POOL_TYPE   PoolType
);

/*****************************************************************************
 * Class definitions
 */

/*****************************************************************************
 * IAdapterCommon
 *****************************************************************************
 * Interface for adapter common object.
 */
DECLARE_INTERFACE_(IAdapterCommon,IUnknown)
{
    STDMETHOD_(NTSTATUS,Init)
    (   THIS_
        IN      PRESOURCELIST   ResourceList,
        IN      PDEVICE_OBJECT  DeviceObject,
        IN      LPGENERAL_INFO  GeneralInfo,
        IN      WORD            BoardIndex
    )   PURE;

    STDMETHOD_(NTSTATUS,InitDSP)
    (
        THIS_
        IN  PDEVICE_OBJECT DeviceObject,
        IN  LPGENERAL_INFO GeneralInfo,
        IN  WORD           BoardIndex
    )   PURE;

    STDMETHOD_(WORD, GetBoardIndex)
    (   THIS_
    )   PURE;
    STDMETHOD_(NTSTATUS, GetBoardType)
    (   THIS_
        OUT     PWORD       PmPFamilyType,
        OUT     PWORD       PmPTypeNotAliased,
        OUT     PWORD       PmPOptions
    )   PURE;
    STDMETHOD_(WORD, ConvertDSound2Driver)
    (   THIS_
        IN LONG PmDSound,
        IN TopoNodes PmType
    )   PURE;
    STDMETHOD_(LONG, ConvertDriver2DSound)
    (   THIS_
        IN WORD PmDriverLevel,
        IN TopoNodes PmType
    )   PURE;

    STDMETHOD_(ULONG, GetWaveOutNumber)
    (   THIS_
    )   PURE;
    STDMETHOD_(ULONG, GetWaveInNumber)
    (   THIS_
    )   PURE;
    STDMETHOD_(ULONG, GetMaxWaveInOutNumber)
    (   THIS_
    )   PURE;

    STDMETHOD_(NTSTATUS, SetBoardClock)
    (
        THIS_
        IN      DWORD   PmFrequency,
		IN		DWORDLONG PmInPipeMask,
		IN		DWORDLONG PmOutPipeMask
    )   PURE;

    STDMETHOD_(BOOL, GetCurrentClock)
    (   THIS_
		IN		DWORDLONG PmMaskPipeIN,
		IN		DWORDLONG PmMaskPipeOUT,
        OUT     LPDWORD PmPFrequency,   
        OUT     LPBOOL  PmPFrequencyLocked,
        OUT     LPBYTE  PmPClockType,
        OUT     LPWORD  PmPSyncInNum
    )   PURE;

    STDMETHOD_(NTSTATUS, ReleaseClockSettings)
    (
        THIS_
		IN		DWORDLONG PmInPipeMask,
		IN		DWORDLONG PmOutPipeMask
    )   PURE;

    STDMETHOD_(VOID*,GetProtocolPtrAsVoid)
	(  THIS_
    )  PURE;

    STDMETHOD_(VOID*,GetIOCommandsPtrAsVoid)
	(  THIS_
    )  PURE;

    STDMETHOD_(VOID,AcquireBoardLock)
    (   THIS_
        IN  PKIRQL  PmPOldIrql
    )   PURE;

    STDMETHOD_(VOID,ReleaseBoardLock)
    (   THIS_
        IN  PKIRQL  PmPOldIrql
    )   PURE;

    STDMETHOD_(VOID,AcquireBoardLockAtDpcLevel)
    (   THIS_
    )   PURE;

    STDMETHOD_(VOID,ReleaseBoardLockAtDpcLevel)
    (   THIS_
    )   PURE;

};

typedef IAdapterCommon *PADAPTERCOMMON;

/*****************************************************************************
 * IMiniportTopologyICH
 *****************************************************************************
 * Interface for topology miniport.
 */
DECLARE_INTERFACE_(IMiniportTopologyICH,IMiniportTopology)
{
    // Set the indexes for board and device references
    //
    STDMETHOD_(VOID,MyVery1stInit)
    (THIS_
        IN      USHORT  BoardIndex,
        IN      USHORT  DeviceNumber,
        IN      USHORT  PmChannelFirst,
        IN      USHORT  PmChannelCount,
        IN      LPGUID  PmDeviceNameGuid
     )PURE;

    STDMETHOD_(NTSTATUS,GetPhysicalConnectionPins)
    (THIS_
        IN ULONG  Index,
        OUT PULONG  Wave
    )PURE;

    // Used for DRM:
    STDMETHOD_(void, SetDrmFlags)
    (   THIS_
        IN      BOOL,
        IN      BOOL
    )   PURE;

    STDMETHOD_(NTSTATUS,StartActualNodeSettings)
    (THIS_
        IN  WORD    PmChannelNum,
        IN  BOOLEAN PmCapture
    )PURE;

    STDMETHOD_(VOID,StopActualNodeSettings)
    (THIS_
        IN  WORD    PmChannelNum,
        IN  BOOLEAN PmCapture
    )PURE;

};
typedef IMiniportTopologyICH *PMINIPORTTOPOLOGYICH;

/*****************************************************************************
 * IMiniportWaveICH
 *****************************************************************************
 * Interface for wave miniport.
 */
DECLARE_INTERFACE_(IMiniportWaveICH,IMiniportWavePci)
{
    // Set the indexes for board and device references
    //
    STDMETHOD_(VOID,MyVery1stInit)
    (THIS_
        IN      USHORT  BoardIndex,
        IN      USHORT  DeviceNumber,
        IN      USHORT  PmChannelFirst,
        IN      USHORT  PmChannelCount,
        IN      LPGUID  PmDeviceNameGuid,
        IN      BOOL    PmConnectInterrupt
     )PURE;

    STDMETHOD_(NTSTATUS,GetPhysicalConnectionPins)
    (THIS_
        IN  ULONG   Index,
        OUT PULONG  Wave
    )PURE;

    STDMETHOD_(VOID,SetTopologyRef)
    (THIS_
        IN  PMINIPORTTOPOLOGYICH    PmTopologyRef
    )PURE;

    STDMETHOD_(NTSTATUS,PropertyHandlerComponentId)
    (THIS_
        IN PPCPROPERTY_REQUEST  PropertyRequest
    )PURE;

    STDMETHOD_(NTSTATUS,PropertyHandlerProposedFormat)
    (THIS_
        IN PPCPROPERTY_REQUEST  PropertyRequest
    )PURE;
};
typedef IMiniportWaveICH *PMINIPORTWAVEICH;


/*****************************************************************************
 * Guids for the Interfaces
 *****************************************************************************
 */

// {77481FA0-1EF2-11d2-883A-0080C765647D}
DEFINE_GUID(IID_IAdapterCommon,
0x77481fa0, 0x1ef2, 0x11d2, 0x88, 0x3a, 0x0, 0x80, 0xc7, 0x65, 0x64, 0x7d);

// {245AE964-49C8-11d2-95D7-00C04FB925D3}
DEFINE_GUID(IID_IMiniportTopologyICH,
0x245ae964, 0x49c8, 0x11d2, 0x95, 0xd7, 0x0, 0xc0, 0x4f, 0xb9, 0x25, 0xd3);

// {7E30C523-724B-11d3-9675-00104BBA728D}
DEFINE_GUID(IID_IMiniportWaveICH,
0x7e30c523, 0x724b, 0x11d3, 0x96, 0x75, 0x0, 0x10, 0x4b, 0xba, 0x72, 0x8d);

#endif  //_SHARED_H_
