// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************


// Include files
// *************

#include "drvdef.h"
#include "drvdbg.h"

#include "nt_lib.h"

// FS - 01/04/1997 - START MODIFYING
#include "api_hdl.h"

// Add a WaitQueue to release pending events when cancelled
LIST_ENTRY WaitQueue ;
KSPIN_LOCK WaitQueueSpinLock ;
// FS - 01/04/1997 - END MODIFYING


// MBR (17/02/2003)
// needs to be imported from the driver's main file !
//
#ifdef __cplusplus
extern "C" {
#endif

EXTERN VOID ProtectAndSync( PVOID, PKIRQL );
EXTERN VOID UnProtectAndSync( PVOID, PKIRQL );

#ifdef __cplusplus
}
#endif

// STATIC VOID IrpCancelRoutine()
// ******************************
//
//  Input Parameters :
//  ******************
//
//  IN PDEVICE_OBJECT PmDeviceObject :   the device object
//  IN PIRP PmIrp                    :   the IRP of an asynchronous command
//
// ****************************************************************************
//
//  Cancel an IRP. Note that this routine is called with the cancel spin lock
// held
//
// ****************************************************************************
STATIC  VOID    IrpCancelRoutine(
    IN  PDEVICE_OBJECT  PmDeviceObject  ,
    IN  PIRP            PmIrp           )
{
    KIRQL   LcOldIrql       ;
    DWORD   LcBufferLength  ;

    DOUT( DBG_PRINT, ("Cancelling IRP"));

    // Getting queue spinlock
    // -------------------------------------------------
    KeAcquireSpinLock( &WaitQueueSpinLock, &LcOldIrql );

    // Now remove the irp from the queue completely
    // -----------------------------------------------
    RemoveEntryList( &PmIrp->Tail.Overlay.ListEntry );

    // Release the spin lock
    // ---------------------
    KeReleaseSpinLock( &WaitQueueSpinLock, LcOldIrql );

    // Release the cancel spin lock
    // ----------------------------
    IoReleaseCancelSpinLock( PmIrp->CancelIrql );

    // Synchronize execution of DPCs and others incoming DevIoctl
    // ----------------------------------------------------------
    ProtectAndSync( PmDeviceObject->DeviceExtension, &LcOldIrql);

    // Release the request buffer from driver structures
    // -------------------------------------------------
    APHCancel( PmIrp->AssociatedIrp.SystemBuffer, &LcBufferLength ) ;

    // allow DPC and DevIoctl again
    // ----------------------------
    UnProtectAndSync( PmDeviceObject->DeviceExtension, &LcOldIrql);

    // Cancel and complete the IRP
    // ---------------------------
    // ## MBR (2001/01/11) Information for Error Status was filled by
    //                     APHCancel in SystemBuffer: ED_CANCELLED.
    //                     return not STATUS_CANCELLED but STATUS_SUCCESS
    //                     to copy this info back to api !!
    PmIrp->IoStatus.Status = STATUS_SUCCESS ;

    // FS - 01/04/1997
    // Buffer length is not null: at least the reply header
    // must be copied back to the user
    // ----------------------------------------------------
    PmIrp->IoStatus.Information = LcBufferLength ;

    IoCompleteRequest( PmIrp, IO_NO_INCREMENT );
}


// ****************************************************************************
// VOID      WNTSetEvent()
// ***********************
//
//  Input Parameters :
//  ******************
//
//  IN PDWORD   PmIrp   :   the IRP of an asynchronous command
//
// ****************************************************************************
VOID    WNTSetEvent(
    IN  PDWORD  PmIrp , NTSTATUS PmStatus  )
{
    PIRP    LcIrp = (PIRP) PmIrp    ;
    KIRQL   LcCancelIrql, LcOldIrql ;

    if ( LcIrp != NULL )
    {
        DOUT( DBG_PRINT, ("!"));

        // Before let's clear the cancel routine
        // -------------------------------------
        IoAcquireCancelSpinLock( &LcCancelIrql )   ;

        if ( LcIrp->Cancel)
        {
            DOUT( DBG_PRINT, ("!! Already canceled !!"));
            IoReleaseCancelSpinLock( LcCancelIrql );
            return;
        }

        IoSetCancelRoutine( LcIrp, NULL )       ;
        IoReleaseCancelSpinLock( LcCancelIrql );

        // FS - 01/04/1997 - START MODIFYING
        // Getting queue spinlock
        KeAcquireSpinLock( &WaitQueueSpinLock, &LcOldIrql ) ;

        // Now remove the irp from the queue completely.
        RemoveEntryList( &LcIrp->Tail.Overlay.ListEntry ) ;

        // Release the spin lock.
        KeReleaseSpinLock (&WaitQueueSpinLock, LcOldIrql) ;
        // FS - 01/04/1997 - END MODIFYING

        // Now complete the pending request
        // --------------------------------
        LcIrp->IoStatus.Status = PmStatus     ;

        // ## FS (FA #168) -- In a multi-thread context
        // WindowsNT post an APC to complete the Request
        // for the originating thread. Hence this APC
        // need a boost to ensure it will be handled
        // before the current synchronous driver request
        // gets back into user-mode
        //
        IoCompleteRequest( LcIrp, IO_SOUND_INCREMENT ) ;
    }
    else
    {
        DOUT( DBG_PRINT, ("!! Cannot set event !!"));
    }
}


// ****************************************************************************
// VOID      WNTClearEvent()
// ***********************
//
//  Input Parameters :
//  ******************
//
//  IN PDWORD   PmIrp   :   the IRP of an asynchronous command
//
// ****************************************************************************
VOID    WNTClearEvent(
    IN  PDWORD  PmIrp   )
{
    PIRP    LcIrp = (PIRP) PmIrp    ;
    KIRQL   LcCancelIrql ;

    if ( LcIrp != NULL )
    {
        DOUT( DBG_PRINT, ("."));

        // Set up a cancel routine
        // -----------------------
        IoAcquireCancelSpinLock( &LcCancelIrql );
        IoSetCancelRoutine( LcIrp, IrpCancelRoutine );
        IoReleaseCancelSpinLock( LcCancelIrql );

        // FS - 01/04/1997
        // Insert the IRP into our queue
        ExInterlockedInsertTailList(
                            &WaitQueue                      ,
                            &LcIrp->Tail.Overlay.ListEntry  ,
                            &WaitQueueSpinLock              );

        // return to dispatch signalling the Irp as pending
        // ------------------------------------------------
        LcIrp->IoStatus.Status = STATUS_PENDING ;
    }
    else
        DOUT( DBG_PRINT, ("!! Cannot clear event !!"));
}

// ****************************************************************************
// NTSTATUS  WNTLibInit()
// **********************
//
// Input parameters :
// ******************
//
// Output parameters :
// ******************
//
// ****************************************************************************
//
// Initializes the WindowsNT-specific library
//
// ****************************************************************************
//
// FS - 01/04/1997
//  Actually initializes the WaitQueue and associated SpinLock
//
// ****************************************************************************
NTSTATUS    WNTLibInit()
{
    // Set up the queue of pending IRPs
    // --------------------------------
    InitializeListHead( &WaitQueue );

    // Also set up an associated spinlock
    // to protect the queue from other access
    // while we are using it
    // --------------------------------
    KeInitializeSpinLock( &WaitQueueSpinLock );


    return( STATUS_SUCCESS );
}


// ****************************************************************************
// EXTERN WORD UTIDWMask2Word()
// ***************************
//
// Input parameters :
// ****************
//
//      DWORD PmMask  :   a mask with at least one bit set
//
// Output parameters :
// *******************
//
//      NONE
//
// Return value :
// **************
//
//      The number of the first set-bit found in the mask
//
// ****************************************************************************
//
//  Scan the mask bits from right to left, and returns the position of
// the first set_bit encountered
//
// ****************************************************************************
WORD    UTIDWMask2Word( IN DWORD PmMask )
{
    register WORD LcValue = 0;

    if( PmMask == 0 )
    {
        DOUT(DBG_WARNING, ("UTIDWMask2Word : Mask=0 used !!!!!!!\n"));
        return 0;
    }
    while ( !( PmMask & 1L ) && ( PmMask != 0 ) )
    {
        LcValue++;
        PmMask >>= 1;
    }

    return LcValue;
}


WORD UTI64Mask2Word( IN DWORDLONG PmMask )
{
    WORD LcValue = 0;

    if( PmMask == 0 )
    {
        DOUT(DBG_WARNING, ("UTI64Mask2Word : Mask=0 used !!!!!!!\n"));
        return 0;
    }
    while ( !( PmMask & 1 ) && ( PmMask != 0 ) )
    {
        LcValue++;
        PmMask >>= 1;
    }

    return LcValue;
}
