// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#ifndef _API_HDL_H
#define _API_HDL_H


#include "virtio.h"

// Length of path where resides all PCX files
#define MAX_PCX_PATH_LEN    144

// TAG_DEBUG_DRIVER : DEB

// Shared defines
//****************
//#define UER_PROFESSIONAL_MODE   1
//#define UER_CONSUMER_MODE       2

// Shared typedef
//***************

typedef struct _DRIVER_INFO {
    BYTE            drRelease;
    BYTE            drNver;
    BYTE            drTver;
    BYTE            drBver;

#define RESET_GAIN_MUTE     0
#define RESET_GAIN_NO       1       
#define RESET_GAIN_0DBFS    2
#define RESET_GAIN_LCMV1    3   // reset gains so as to simulate LCM V1

    BYTE            drDoNotCheckForVersionState;
    BOOLEAN         drResetAnalogLevelsAction;
    BYTE            drUnused[2];
    LPSTR           drPath;
} DRIVER_INFO, *PDRIVER_INFO, FAR *LPDRIVER_INFO;

typedef LPDRIVER_INFO   *DRIVER_INFO_HANDLE;


typedef struct  _DSP_INFO {
    BYTE    dsEtat;
    BYTE    dsZero1;
    WORD    dsFatalError;
    DWORD   dsDspVersion;	/**<firmware version 0x00MMmmbb. Update needed if MM or mm do not match the driver.*/
    DWORD   dsMaskIndexAppli;
	// assuming only one DSP 
	WORD	dsManagedPhysicalOutputNumber;	/**<count of outputs managed by the card (one CPU).*/
	WORD	dsManagedPhysicalInputNumber;	/**<count of inputs managed by the card (one CPU).*/
    WORD	dsManagedVirtualOutputNumber;
    WORD	dsManagedVirtualInputNumber;
    DWORDLONG	dsMaskVPOut;
    DWORDLONG	dsMaskVVOut;
    DWORDLONG	dsMaskVPIn;
    DWORDLONG	dsMaskVVIn;
    BYTE    dsMaxBoardOutStream;
    BYTE    dsMaxPipeOutStream;
    DWORDLONG   dsContextMaskOutPipes[MAX_CONTEXT];
    DWORD   dsContextID[MAX_CONTEXT];

} DSP_INFO, *PDSP_INFO;

// FH modification 12/02/97
// ciAmmccPort, ciDspPort and cixiPort were moved to
// PORT_INFO structure

typedef struct _BOARD_FILES_INFO {
	char* bfiBoardName;
    WORD bfiBoard ;
    WORD bfiCSID ;
    char* bfiEePromName ;
    char* bfiBootName ;
    char* bfiXilinx1Name;
    char* bfiXilinx2Name;
    char* bfiDefaultDspName ;
} BOARD_FILES_INFO, *PBOARD_FILES_INFO ;  


typedef struct  _BOARD_INFO
{
    PBYTE               portMEM;
    PBYTE               portPLX;
    PBYTE               portDSP;
    DWORD               portMEMsize;
    DWORD               portPLXsize;
    DWORD               portDSPsize;
    BYTE                biCarac;        // Indicates whether the other fields are relevant.
    BYTE                biType;         // Family of the board. ( group boards with same behaviour )
    BYTE                biTypeNoAlias;  // Type of the board. ( exact board )
    BYTE                biFlavor;       // Flavor of the board. ( handle variants ) 
    WORD                biCSID;         // We don't have to deal with CSID ( PCI specific )
    WORD                biUnused1;
    DWORD               biNumIrq;

    DSP_INFO            biTbDspInfo[MAX_BOARD_DSP];
    
    PBOARD_FILES_INFO   bipFiles;       // refered to by IOCOmmands

#define biBoardName         bipFiles->bfiBoardName

    DWORDLONG           biPipeClockMask[2];

    // Gives the index of the application that wants to be notified of events.
    WORD                biGpioAppliIndex;
    BYTE                biUnused3;
    // Indicates the a GPIO event occurred and that the application didn't read yet.
    BOOLEAN             biGpioEvent;
    // Mask for the Input GPIO's that have to be notified
    DWORD               biGpioNotifyMask;
    // Last Value notified of Input GPIO
    DWORD               biGpioNotifyLastRead;
    // Fifo for Input of GPIO
    DWORD               biGpioFifo[GPIO_NP2_FIFO_SIZE];
    WORD                biGpioFifoReadIndex;
    WORD                biGpioFifoWriteIndex;

} BOARD_INFO, *PBOARD_INFO, FAR *LPBOARD_INFO;

typedef LPBOARD_INFO    *BOARD_INFO_HANDLE;

// Values for biCarac field of BOARD_INFO record.
//
#define CARAC_FREE    0  // Must be equal to zero because must correspond
                         // to a BZERO operation.
#define CARAC_GHOST   1  // The board is no more managed but its features can still
                         // be used for clean up operations.
#define CARAC_USED    2

#define CARAC_HELD    3

#define NO_MASK_PIPE_OUT 0
#define NO_MASK_PIPE_IN  1


// Mask for all the boards
//
#define ALL_BOARDS      0x000000FF      // MAX_BOARD (8) boards

// TAG_DEBUG_DRIVER : FIN

#define	CUR_PROTOCOL_PTR	(APH_Protocol_Array[LcCurrentBoard])
#define	CUR_COMMANDS_PTR	(APH_Commands_Array[LcCurrentBoard])
#define	CUR_BOARD_INFO_PTR	(&APH_Board_Info_Array[LcCurrentBoard])


// Global functions
// ****************
#ifdef __cplusplus
extern "C" {
#endif
EXTERN int IsApiNpPipeDefined();
EXTERN VOID         APHInit(
    OUT DRIVER_INFO_HANDLE,
    OUT BOARD_INFO_HANDLE );

EXTERN BOOLEAN      APHDispatch( IN LPDWORD, OUT LPDWORD, IN PDWORD );

EXTERN VOID         APHDispatch2( INOUT PVOID );

EXTERN VOID         APHCancel( INOUT PVOID, OUT PDWORD );
EXTERN VOID         APHTraitIt( VOID );
EXTERN VOID         TraitHardItBoard( IN WORD PmNumBoard );
EXTERN VOID         APHKeepPipeError( IN PTARGET_INFO, IN WORD );
EXTERN VOID         APHKeepSeveralPipesError( IN WORD, IN WORD );

EXTERN VOID         APHKeepDspError( IN PDSP_INFO, IN WORD );

EXTERN VOID         APHEndPlayPipe( IN PTARGET_INFO );
EXTERN VOID         APHEndRecordPipe( IN PTARGET_INFO );
EXTERN VOID         APHNotifyPipe( IN  PTARGET_INFO, IN BOOLEAN );

EXTERN VOID         APHNotifyBoardPnpEvent( IN WORD, IN BYTE );
EXTERN  VOID        APHCancelBoardPnpEvent( IN WORD );

EXTERN VOID         APHFreeBuffer( IN LPPLAY_REQ_INFO );
EXTERN VOID         APHFreeRecordBuffer( IN  LPRECORD_REQ_INFO );

EXTERN VOID         APHUpdateCBitsOnBoard(
    IN      WORD        PmBoardNum,
    IN      DWORD       PmFrequency );

EXTERN WORD         APHGetPipeClock(
    IN  BOOLEAN         PmForceActual,
    IN  PTARGET_INFO    PmPTarget,
    OUT PBYTE           PmPSource,
    OUT PBYTE           PmPSyncPresent,
    OUT PDWORD          PmPFrequency );

EXTERN DWORDLONG    APH_Get_Pipe_Audio_Mask( WORD PmPipeIndex );

EXTERN  VOID        APHNotifyGpioEvent(IN WORD PmBoardNum );
EXTERN  VOID        APHCancelGpioEvent(IN WORD PmAppliNum );
EXTERN  VOID        APHTreatGpioIt(IN WORD PmBoardNum );
EXTERN LPBOARD_INFO APHGetBoardInfoPtr(IN WORD);

EXTERN WORD         APHSampleClockSetNoClock(IN  BYTE,IN  DWORDLONG,IN  DWORDLONG);

EXTERN VOID         APHPrepareFakedPipeEntry(IN PTARGET_INFO,IN WORD,IN WORD,OUT PDWORDLONG);
EXTERN VOID         APHFillInFakedPipeEntry(IN PTARGET_INFO,IN DWORDLONG, IN PVOID);
EXTERN VOID         APHRemoveFakedPipeEntry(IN PTARGET_INFO,IN WORD);

EXTERN WORD         APHSampleClockSynchronizeOnlyOneBoard(
    IN  LPSAMPLE_CLK_REQ_INFO PmLPtrReq,
    IN  WORD                  PmBoardNum);

EXTERN VOID         APH_CleanUpAppliInfo();
EXTERN VOID         APHRemoveAllBoardPipeEntry( IN WORD, IN BOOLEAN );
EXTERN VOID         APHNotifyAllDSoundPipes( IN WORD PmBoardIndex );

// DHS
EXTERN BOOLEAN      APHChkIsAudioDHSControlled( IN WORD PmBoard, IN WORD PmAudioIdx, IN BYTE PmIsCapture );
EXTERN WORD         APHNewPipeSetDHSLevels( IN WORD PmBoard, IN WORD PmAudioIdx, IN BYTE PmIsCapture );
EXTERN BOOLEAN      APHIsClockDHSLocked( IN WORD PmBoard, OUT PBOOLEAN PmFrequencyFixed );

EXTERN  WORD	    VIOGetMACAddress( IN WORD, OUT PBYTE);

#ifdef __cplusplus
}
#endif

#endif // _API_HDL_H





