// *****************************************************************************
//
// COPYRIGHT (C) 2006 DIGIGRAM. ALL RIGHT RESERVED.
//
// *****************************************************************************
//
/**	@file	IF_ES_AUDIO.H
*	@brief	interface ESM - Audio driver
*/
// Project          : PCXKDOS2
// last mod $date by $author
// *****************************************************************************
// 

#ifndef _IF_ES_AUDIO_H_
#define _IF_ES_AUDIO_H_


#define IOCTL_ES_COMMAND	CTL_CODE(	FILE_DEVICE_UNKNOWN,\
                                        0x15B3,             \
                                        METHOD_BUFFERED,    \
                                        FILE_ANY_ACCESS     )


#define	ES_DRV_IF_VERSION	0x00	// version de l'interface ES_DRV_XXXX

/**	
*	Command structure for ESM --> Audio Driver
*/
typedef struct _ES_DRV_CMD {
ULONG	ulCmd;		/**< command ID.*/
ULONG	ulParam1;	/**< param 1 : board ID.*/
ULONG	ulParam2;	/**< param 2.*/
ULONG	ulParam3;	/**< param 3.*/
ULONG	ulParam4;	/**< param 4.*/
ULONG	ulParam5;	/**< param 5.*/
ULONG	ulUnused[6]; 	/**< reserved.*/
} ES_DRV_CMD, *PES_DRV_CMD;

/**	
*	Response structure for Audio --> ESM Driver
*/
typedef struct _ES_DRV_RESP {
ULONG	ulStatus;	/**< status: SUCCESS( 0 ) ou code derreur.*/
ULONG	ulResp1;	/**< resp 1.*/
ULONG	ulResp2;	/**< resp 2.*/
ULONG	ulResp3;	/**< resp 3.*/
ULONG	ulResp4;	/**< resp 4.*/
ULONG	ulResp5;	/**< resp 5.*/
ULONG	ulResp6;	/**< resp 6.*/
ULONG	ulResp7;	/**< resp 7.*/
ULONG	ulResp8;	/**< resp 8.*/
CHAR	ulString[28]; 	/**< string.*/
} ES_DRV_RESP, *PES_DRV_RESP;

/**	
*	Command ID's for ESM --> Audio Driver
*/
typedef enum _ES_CMD_ID
{
    ES_CMD_ID_INFO  = 0,    /**< INFO: test if card exists. returns DSP version.*/
    ES_CMD_ID_WRITE_ES,     /**< Write ES register (synchron).*/
    ES_CMD_ID_READ_ES,      /**< Read ES register (synchron or asynchron).*/
    ES_CMD_ID_MAP_CSUF,     /**< get virtual address of CSUF register.*/
    ES_CMD_ID_FREE_CSUF,    /**< free virtual address of CSUF register.*/
    ES_CMD_ID_RESET_BOARD,   /**< reset the board (after firmware update).*/
    ES_CMD_MAX
} ES_CMD_ID;


// used for ES_DRV_CMD->ulParam2 in case of ES_CMD_ID_INFO :
#define LXES_CMD_INFO_GET_REAL_FW_DRV_VERSION    0x0001
// ulResp3 = 'firmware version' and ulResp4 = 'driver version' if this flag is set
// ulResp3 = ulResp4 = min('firmware version' , 'driver version') if this flag is NOT set


// Guid's used in HKLM\System\CurrentControlSet\Control\MediaCategories
// to define LXES DirectSound Device Names (1st value gets incremented for each device)
//
// {C8C6BC00-9637-4cd6-9DEA-AA594E2AA569}
#define LXES_DSDEVNAME_GUIDS {0xc8c6bc00, 0x9637, 0x4cd6, {0x9d, 0xea, 0xaa, 0x59, 0x4e, 0x2a, 0xa5, 0x69 } };

// increment LXES_DSDEVNAME_GUIDS.Data1 by (iCardIndex * LXES_MAX_GUID_PER_CARD) + iDeviceIndex
#define LXES_MAX_GUID_PER_CARD  32


#endif

