//********************************************************************
//
// COPYRIGHT 2005 DIGIGRAM. ALL RIGHTS RESERVED
//
//********************************************************************
//
/**	@file	 IF_DRV_MB.H
*	@brief	 definitions shared between PC-side Driver and Embedded
*/
//  Project          : LXES 
//
//  Last Mod $Date: 16/11/06 17:46 $ by $Author: Mtr $
//
//*********************************************************************


#ifndef __IF_DRV_MB_H_
#define __IF_DRV_MB_H_ 

///*********************************************************************
//				compile/debug options 
//*********************************************************************

#define DEBUG_MAIN		0	/** main debug switch.*/
#define DEBUG_UART		0	/** support for UART.*/
#define DEBUG_MASK64	0	// 64 bits mask class

//*********************************************************************
//				general definitions
//*********************************************************************
#define SIZE_MAPPING			10	/* number of channels supported in m/c mode.*/
#define OPT_64_BITS_PCADDR	    0	/* support for 64 bits PC address / DMA.*/

/** attention : si le max des I/O est < 32, il y a du code a revoir */

#define MAX_CARD_INPUTS		64	
#define MAX_CARD_OUTPUTS	64
#define MAX_CANAUX_CARTE	(MAX_CARD_INPUTS+MAX_CARD_OUTPUTS)

#define MAX_CARD_IN_PIPES	32	
#define MAX_CARD_OUT_PIPES	32

//*********************************************************************
//				 DRV <---> uM commands definitions
//*********************************************************************

#define MB_REG_CSM		0
// DRV --> MB
#define MB_REG_CMD0		1
#define MB_REG_CMD1		2
#define MB_REG_CMD2		3
#define MB_REG_CMD3		4
#define MB_REG_CMD4		5
#define MB_REG_CMD5		6
#define MB_REG_CMD_MAX	7
// MB --> DRV
#define MB_REG_ERR		1
#define MB_REG_RSP0		2
#define MB_REG_RSP1		3
#define MB_REG_RSP2		4
#define MB_REG_RSP3		5
#define MB_REG_RSP4		6
#define MB_REG_RSP5		7
#define MB_REG_RSP6		8
#define MB_REG_RSP7		9
#define MB_REG_RSP8		10
#define MB_REG_RSP9		11

/* 
	the capture bit position in the object_id field in driver commands
	depends upon the number of managed channels. For now, 64 IN + 64 OUT are
	supported. HOwever, the communication protocol forsees 1024 channels, hence 
	bit 10 indicates a capture (input) object).
*/
#define ID_IS_CAPTURE		( 1L << 10 )
#define ID_OFFSET			13				/**< object ID is at the 13th bit in the 1st command word.*/
#define ID_CH_MASK			0x3F

#define OPCODE_OFFSET		24				/**< offset of the command opcode in the first command word.*/	


typedef enum {
	CMD_00_INFO_DEBUG			= 0x00, 	// information de debug
	CMD_01_GET_SYS_CFG			= 0x01,	// lecture de la configuration systme
	CMD_02_SET_GRANULARITY		= 0x02,	// programmation de la granularit
	CMD_03_SET_TIMER_IRQ		= 0x03,	// programmation de l'IRQ PCI Timer
	CMD_04_GET_EVENT			= 0x04,	// lecture des vnements notifis
	CMD_05_GET_PIPES			= 0x05,	// lecture de l'tat des pipes
	//
	CMD_06_ALLOCATE_PIPE        = 0x06,	// rservation d'un pipe
	CMD_07_RELEASE_PIPE			= 0x07,	// libration d'un pipe
	CMD_08_ASK_BUFFERS			= 0x08,	// tat des buffers d'un pipe
	CMD_09_STOP_PIPE			= 0x09,	// arret d'un pipe
	CMD_0A_GET_PIPE_SPL_COUNT	= 0x0a,	// lecture du compte d'chantillons pipe
	CMD_0B_TOGGLE_PIPE_STATE	= 0x0b,	// commutation START/PAUSE
	//
	CMD_0C_DEF_STREAM			= 0x0c,	// dfinition d'un stream
	CMD_0D_SET_MUTE				= 0x0d,	// mute des voies
	CMD_0E_GET_STREAM_SPL_COUNT = 0x0e,	// lecture tat et compte d'chantillons stream
	CMD_0F_UPDATE_BUFFER		= 0x0f,	// mise  jour d'un buffer PC
	CMD_10_GET_BUFFER			= 0x10,	// tat d'un buffer PC
	CMD_11_CANCEL_BUFFER		= 0x11,	// annulation d'un buffer PC
	CMD_12_GET_PEAK				= 0x12,	// lecture des peak-metres audio
	CMD_13_SET_STREAM_STATE		= 0x13,
	CMD_14_INVALID				= 0x14,
} cmd_mb_opcodes;


//*********** specific to CODECMD_INFO_DEBUG			***************


//*********** specific to CODECMD_LEC_CONF_SYS			***************

#define FREQ_FIELD_OFFSET	15	// offset of the freq field in the response word

#define		FREQ_48			0x00
#define		FREQ_44			0x01
#define		FREQ_96			0x02	// (drv must test the frequency mode)
#define		FREQ_192		0x03	// (drv must test the frequency mode)
#define		FREQ_UNKNOWN	0x0F	// (drv must test the frequency mode)

//-- Version
#define	VERSION_MAJOR_OFFSET 16
#define	VERSION_MINOR_OFFSET 8
#define	VERSION_BUILD_OFFSET 0
#define MICROBLAZE_VERSION		((PCX_VERSION_NUMBER  << VERSION_MAJOR_OFFSET) \
								|(PCX_VERSION_RELEASE << VERSION_MINOR_OFFSET) \
								|(PCX_BUILD_NUMBER    << VERSION_BUILD_OFFSET))


//*********** specific to CODECMD_PROG_GRANULARITE		***************

// must be power of 2
//
#define MICROBLAZE_IBL_MIN		32		// 32 (0), 64 (1), 128 (2), 256 (3), 512 (4), 1024 (5)
#define MICROBLAZE_IBL_DEFAULT	128
#define MICROBLAZE_IBL_MAX		512
#define MASK_GRANULARITY		(2*MICROBLAZE_IBL_MAX-1)
#define MICROBLAZE_IBL_CODED_DEFAULT	2		// coded value, for audio vhdl { 0, 1, 2, 3, 4, 5 }

//*********** specific to CODECMD_PROG_IRQ_TIMER		***************

#define MASK_TIMER_K			0x00FFFFFF

//*********** specific to CODECMD_LEC_EVE_NOTIFIES		***************

// -- mask definitions for SYS.STAT ----- 
//
#define MASK_SYS_STATUS_ERROR	(1L << 31)	// events that lead to a PCI irq if not yet pending
#define MASK_SYS_STATUS_URUN	(1L << 30)
#define MASK_SYS_STATUS_ORUN	(1L << 29)
#define MASK_SYS_STATUS_EOBO	(1L << 28)
#define MASK_SYS_STATUS_EOBI	(1L << 27)
#define MASK_SYS_STATUS_FREQ	(1L << 26)
#define MASK_SYS_STATUS_ESA	(1L << 25)	// reserved, this is set by the XES
#define MASK_SYS_STATUS_TIMER	(1L << 24)

#define MASK_SYS_ASYNC_EVENTS	(MASK_SYS_STATUS_ERROR | MASK_SYS_STATUS_URUN | \
								 MASK_SYS_STATUS_ORUN  | MASK_SYS_STATUS_EOBO | \
								 MASK_SYS_STATUS_EOBI  | MASK_SYS_STATUS_FREQ | \
								 MASK_SYS_STATUS_ESA)

#define MASK_SYS_PCI_EVENTS		(MASK_SYS_ASYNC_EVENTS | MASK_SYS_STATUS_TIMER)

#define MASK_SYS_TIMER_COUNT	0x0000FFFF

//#define MASK_SYS_STATUS_CMD		(1L << 23)	// event that remains internal
#define MASK_SYS_STATUS_EOT_PLX		(1L << 22)	// event that remains internal : reserved fo end of plx dma
#define MASK_SYS_STATUS_XES		(1L << 21)	// event that remains internal : pending XES IRQ
#define MASK_SYS_STATUS_CMD_DONE	(1L << 20)	// alternate command management : notify driver instead of polling


// behave like on PCX : the driver may not acknowledge
// the MASK_SYS_STATUS_TIMER IRQ source with command 0x04
// in this case, the uB resets it after sending the IRQ
//
#define OPT_AUTORESET_TIMER_IRQ	  1

//*********** specific to CODECMD_ETAT_PIPES			***************

// this command is not mandatory infact
// default : do not compile
//
#define OPT_NO_CMD_GET_PIPES	  1

//*********** specific to CODECMD_RESERV_PIPE			***************
//*********** specific to CODECMD_ETAT_BUFF_PIPE		***************

#define BUFF_FLAGS_OFFSET	24		/**< offset of the buffer flags in the response word.*/
#define MASK_DATA_SIZE	0x00FFFFFF	/**<this must match the field size of datasize in the buffer_t structure.*/

/**
*	Buffer Flags
*/
 typedef enum	{
 	BF_VALID			=	0x80,	/**< set if the buffer is valid, clear if free.*/
	BF_CURRENT			=	0x40,	/**< set if this is the current buffer (there is always a current buffer).*/
	BF_NOTIFY_EOB		=	0x20,	/**< set if this buffer must cause a PCI event when finished.*/
	BF_CIRCULAR			=	0x10,	/**< set if buffer[1] must be copied to buffer[0] by the end of this buffer.*/
	BF_64BITS_ADR		=	0x08,	/**< set if the hi part of the address is valid.*/
	BF_xx				=	0x04,	/**< futur extension.*/
	BF_EOB				=	0x02,	/**< set if finished, but not yet free.*/
	BF_PAUSE			=	0x01,	/**< pause stream at buffer end.*/
	BF_ZERO				=	0x00,	/**< no flags (init).*/
 } buffer_flags;

// flags set by driver.
#define MASK_BF_FLAGS	(BF_NOTIFY_EOB|BF_CIRCULAR|BF_64BITS_ADR|BF_PAUSE|BF_xx)
 
//*********** specific to CODECMD_STOP_PIPE				***************
//*********** specific to CODECMD_LEC_CEP				***************

#define MASK_SPL_COUNT_HI	0x00FFFFFF	// 4 MSBits are status bits
#define PSTATE_OFFSET		28			// 4 MSBits are status bits

/** 
*	pipe states 
*/
typedef enum  {
	PSTATE_IDLE		= 0,	/**< the pipe is not processed in the XES_IRQ (free or stopped, or paused). */
	PSTATE_RUN		= 1,	/**< sustained play/record state. */
	PSTATE_PURGE	= 2,	/**< the ES channels are now off, render pipes do not DMA, record pipe do a last DMA. */
	PSTATE_ACQUIRE	= 3,	/**< the ES channels are now on, render pipes do not yet increase their sample count, record pipes do not DMA. */
	PSTATE_CLOSING	= 4,	/**< the pipe is releasing, and may not yet receive an "alloc" command. */
} pipe_state_t;


//*********** specific to CODECMD_START_PAUSE			***************

#define MASK_CMD_LISTE		(1L << 12)	// bit 12 indicates a list or mask of arguments is passed in the following comand words.

//*********** specific to CODECMD_DEF_STREAM			***************

#define MASK_STREAM_HAS_MAPPING	( 1L << 12)
#define MASK_STREAM_IS_ASIO		( 1L << 9)
#define STREAM_FMT_OFFSET	10	/**<the stream fmt bits start at the 10th bit in the command word.*/
// see DMA_conf_t structure aswell, must be the same values
#define STREAM_FMT_16b		0x02
#define STREAM_FMT_intel	0x01
#define STREAM_MAP_implicit	0x01
#define STREAM_MAP_explicit	0


//*********** specific to CODECMD_LEC_ETAT_CES			***************

/**
*	Stream Flags definitions
*/
 typedef enum	{
	SF_ZERO			=	0x00000000,	/**< no flags (stream invalid).*/
 	SF_VALID		=	0x10000000,	/**< the stream has a valid DMA_conf info (setstreamformat).*/
	SF_XRUN			=	0x20000000,	/**< the stream is un x-run state.*/
	SF_START		=	0x40000000,	/**< the DMA is running.*/
	SF_ASIO			=	0x80000000,	/**< ASIO.*/
 }	stream_flags ;


//*********** specific to CODECMD_MAJ_BUFFER_PC			***************
//#if DEBUG_MAIN == 1
//#define MAX_STREAM_BUFFER 3	/**< max amount of stream buffers.*/
//#else
#define MAX_STREAM_BUFFER 5	/**< max amount of stream buffers.*/
//#endif

//*********** specific to CODECMD_DEL_BUFF_PC			***************

#define MASK_BUFFER_ID	0xFF		/**<the cancel command awaits a buffer ID, may be 0xFF for "current".*/

//*********** specific to CODECMD_LECTURE_PEAKMETRES	***************


//*********** specific to CMD_13_SET_STREAM_STATE	***************


/** 
*	stream states 
*/
typedef enum  {
	SSTATE_STOP		=  0x00,		/**< setting to stop resets the stream spl count.*/
	SSTATE_RUN		= (0x01 << 0),	/**< start DMA and spl count handling. */
	SSTATE_PAUSE	= (0x01 << 1),	/**< pause DMA and spl count handling. */
} stream_state_t;


#define MASK_STREAM_STATE	0x0000000F		/**<the state field in the 1st command word.*/

#endif
