// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#ifndef _PCXERROR_H_
//{
#define _PCXERROR_H_

// ********************************************************************
// Error code structure
// ********************
//
// An error code is 16 bits :
//
//    Bit 15 : 1 = error, 0 = warning
//
//    Bits 14-->11 : source of error/warning
//          0x1 = TOOLS source error/warning
//          0x2 = API source error/warning
//          0x3 = AUDIO source error/warning
//          0x4 = DRV source error/warning
//          0x5 = VPCX source error/warning
//          0x6 = DISPATCHER source error/warning
//          0x7 = reserved
//          0x8 = BOARD source error/warning
//          0x9-->0xe = reserved
//          0xf = free for USER usage
//
//    Bits 8-->10 : Class code
//
//    Bits 0-->7  : Code
//
// *********************************************************************

// Return value when OK
// ********************

#define SUCCESS                 0


// Bits masks
// **********

#define ERROR_MASK              0x8000

#define SOURCE_MASK             0x7800

#define E_SOURCE_BOARD          0x4000 //8 >> 1
#define E_SOURCE_DRV            0x2000 //4 >> 1
#define E_SOURCE_API            0x1000 //2 >> 1
// Error tools
#define E_SOURCE_TOOLS          0x0800 //1 >> 1
// Error pcxaudio
#define E_SOURCE_AUDIO          0x1800 //3 >> 1
// Error virtual pcx
#define E_SOURCE_VPCX           0x2800 //5 >> 1
// Error dispatcher
#define E_SOURCE_DISPATCHER      0x3000 //6 >> 1
// Error from CobraNet firmware
#define E_SOURCE_COBRANET       0x3800 //7 >> 1

#define E_SOURCE_USER           0x7800

#define CLASS_MASK              0x0700

#define CODE_MASK               0x00FF

// Bits values
// ***********

// Values for the error/warning bit
// --------------------------------
#define ERROR_VALUE             0x8000
#define WARNING_VALUE           0x0000

// Class values
// ------------
#define E_CLASS_GENERAL                  0x0000
#define E_CLASS_INVALID_CMD              0x0100
#define E_CLASS_INVALID_STD_OBJECT       0x0200
#define E_CLASS_RSRC_IMPOSSIBLE          0x0300
#define E_CLASS_WRONG_CONTEXT            0x0400
#define E_CLASS_BAD_SPECIFIC_PARAMETER   0x0500
#define E_CLASS_REAL_TIME_ERROR          0x0600
#define E_CLASS_DIRECTSHOW               0x0700
#define E_CLASS_FREE                     0x0700

// Complete API warning code for the general class
// -----------------------------------------------
#define WA_GN           (WARNING_VALUE | E_SOURCE_API | E_CLASS_GENERAL)
#define WA_MORE_DATA                    (WA_GN | 0X01)
#define WA_NO_MORE_DATA                 (WA_GN | 0x02)
#define WA_ESTIMATED_VALUE              (WA_GN | 0x03)
#define WA_GENERIC_WARNING              (WA_GN | 0x04)

// Complete API error code for the general class
// ---------------------------------------------
#define EA_GN           (ERROR_VALUE | E_SOURCE_API | E_CLASS_GENERAL)
#define EA_DRIVER_NOT_LOADED            (EA_GN | 0x01)
#define EA_UNKNOWN_MEMORY_TYPE          (EA_GN | 0x02)
#define EA_USE_XMS_MEMORY_IMPOSSIBLE    (EA_GN | 0x03)
#define EA_CANT_TAKE_MUTEX              (EA_GN | 0x04)
#define EA_VERSION_MISMATCH             (EA_GN | 0x05)
#define EA_FILE_CORRUPTED               (EA_GN | 0x06)
#define EA_DLL_NOT_LOADED               (EA_GN | 0x07)
#define EA_UNKNOWN_BOARD                (EA_GN | 0x08)
#define EA_CREATE_THREAD_FAILED         (EA_GN | 0x09)
#define EA_FEATURE_NOT_AUTHORIZED       (EA_GN | 0x0a)
#define EA_TOO_MUCH_DATA                (EA_GN | 0x0b)
#define EA_COMMAND_NOT_AVAILABLE        (EA_GN | 0x0c)

// Complete API warning code for the invalid command class
// -------------------------------------------------------
#define WA_IC           (WARNING_VALUE | E_SOURCE_API | E_CLASS_INVALID_CMD)
#define WA_COMMAND_NOT_AVAILABLE        (WA_IC | 0x01)

// Complete API error code for the invalid command class
// -----------------------------------------------------
#define EA_IC           (ERROR_VALUE | E_SOURCE_API | E_CLASS_INVALID_CMD)

// Complete API warning code for the invalid standard object class
// -------------------------------------------------------------
#define WA_ISO          (WARNING_VALUE | E_SOURCE_API | E_CLASS_INVALID_STD_OBJECT)
#define WA_INVALID_PARAMETER            (WA_ISO | 0x01)

// Complete API error code for the invalid standard object class
// -------------------------------------------------------------
#define EA_ISO          (ERROR_VALUE | E_SOURCE_API | E_CLASS_INVALID_STD_OBJECT)
#define EA_INVALID_BUFFER               (EA_ISO | 0x01)
#define EA_INVALID_PCX_HANDLE           (EA_ISO | 0x02)
#define EA_INVALID_PIPE                 (EA_ISO | 0x03)
#define EA_INVALID_PARAMETER            (EA_ISO | 0x04)
#define EA_INVALID_DATA_LENGTH          (EA_ISO | 0x05)
#define EA_INVALID_FUNCTION             (EA_ISO | 0x06)

// Complete API error code for impossible resource allocation class
// ----------------------------------------------------------------
#define EA_RI           (ERROR_VALUE | E_SOURCE_API | E_CLASS_RSRC_IMPOSSIBLE)
#define EA_ALLOCATE_ASYNC_IMPOSSIBLE    (EA_RI | 0x01)
#define EA_ALLOCATE_CMD_BLK_IMPOSSIBLE  (EA_RI | 0x02)
#define EA_ALLOCATE_MEMORY_IMPOSSIBLE   (EA_RI | 0x03)

// Complete API error code for wrong call context class
// ----------------------------------------------------
#define EA_WCC          (ERROR_VALUE | E_SOURCE_API | E_CLASS_WRONG_CONTEXT)
#define EA_BUFFER_REFUSED               (EA_WCC | 0x01)
#define EA_WAIT_REQUEST_REFUSED         (EA_WCC | 0x02)
#define EA_LOAD_DSP_REFUSED             (EA_WCC | 0x03)
#define EA_SET_OEM_DLL_REFUSED          (EA_WCC | 0x04)

// Complete API warning code for bad specific parameter class
// --------------------------------------------------------
#define WA_WSP      (WARNING_VALUE | E_SOURCE_API | E_CLASS_BAD_SPECIFIC_PARAMETER)
#define WA_LEVEL_OUT_OF_RANGE           (WA_WSP | 0x01)
#define WA_PARAMETER_ADJUSTED           (WA_WSP | 0x02)

// Complete API error code for bad specific parameter class
// --------------------------------------------------------
#define EA_WSP      (ERROR_VALUE | E_SOURCE_API | E_CLASS_BAD_SPECIFIC_PARAMETER)
#define EA_APPLICATION_NAME_SIZE        (EA_WSP | 0x01)
#define EA_BAD_SYNC_SOURCE              (EA_WSP | 0x02)
#define EA_OPEN_FILE_IMPOSSIBLE         (EA_WSP | 0x03)
#define EA_READ_FILE_IMPOSSIBLE         (EA_WSP | 0x04)
#define EA_FILE_TOO_LARGE               (EA_WSP | 0x05)
#define EA_BAD_STREAM_NUMBER            (EA_WSP | 0x06)
#define EA_BAD_AUDIO_NUMBER             (EA_WSP | 0x07)
#define EA_BAD_EFFECT_ID                (EA_WSP | 0x08)
#define EA_BAD_FREQUENCY_VALUE          (EA_WSP | 0x09)
#define EA_MODE_NOT_AVAILABLE           (EA_WSP | 0x0a)
#define EA_CONTEXT_NOT_AVAILABLE        (EA_WSP | 0x0b)
#define EA_BAD_EFFECT_PARAMETER         (EA_WSP | 0x0c)
#define EA_BAD_DSP_FEATURES             (EA_WSP | 0x0d)
#define EA_BAD_PLAY_FORMATS             (EA_WSP | 0x0e)
#define EA_BAD_RECORD_FORMATS           (EA_WSP | 0x0f)
#define EA_BAD_PLAY_EFFECTS             (EA_WSP | 0x10)
#define EA_BAD_RECORD_EFFECTS           (EA_WSP | 0x11)
#define EA_BAD_SOUND_FORMAT             (EA_WSP | 0x12)
#define EA_BAD_TIME_CODE_NUMBER         (EA_WSP | 0x13)
#define EA_BAD_BAND_NUMBER              (EA_WSP | 0x14)
#define EA_BAD_OEM_ID                   (EA_WSP | 0x15)
#define EA_INVALID_POINTER              (EA_WSP | 0x16)
#define EA_BAD_MULTICHANNEL_FORMAT      (EA_WSP | 0x17)

// VPCX ADD - Begin
// Complete API error code for direct show problems class
// ------------------------------------------------------
#define EA_DS       (ERROR_VALUE | E_SOURCE_VPCX | E_CLASS_DIRECTSHOW)
#define EA_SRCFILTER_INSTANCIATION_FAILED  (EA_DS | 0x01)
#define EA_DECODMIX_INSTANCIATION_FAILED   (EA_DS | 0x02)
#define EA_RNDFILTER_INSTANCIATION_FAILED  (EA_DS | 0x03)
#define EA_EFFECT_INSTANCIATION_FAILED     (EA_DS | 0x04)
#define EA_DECFILTER_INSTANCIATION_FAILED  (EA_DS | 0x05)
#define EA_CODFILTER_INSTANCIATION_FAILED  (EA_DS | 0x06)
#define EA_CANNOT_GET_INTERFACE            (EA_DS | 0x07)
#define EA_FILTER_GRAPH_ERROR              (EA_DS | 0x08)
#define EA_NO_WAVE_DRIVER                  (EA_DS | 0x09)
#define EA_SRCFILTER_RUNTIME_ERROR         (EA_DS | 0x0A)
#define EA_DECODMIX_RUNTIME_ERROR          (EA_DS | 0x0B)
#define EA_RNDFILTER_RUNTIME_ERROR         (EA_DS | 0x0C)
#define EA_FCFILTER_RUNTIME_ERROR          (EA_DS | 0x0D)
#define EA_DEINTERLEAVEFILTER_INSTANCIATION_FAILED  (EA_DS | 0x0E)
#define EA_INTERLEAVEFILTER_INSTANCIATION_FAILED    (EA_DS | 0x0F)
#define EA_MPEGCODER_RUNTIME_ERROR         (EA_DS | 0x10)
#define EA_PCCODERMPEG_RUNTIME_ERROR       EA_MPEGCODER_RUNTIME_ERROR // for compatibility
#define EA_PCMCODER_RUNTIME_ERROR          (EA_DS | 0x11)
#define EA_EFFECT_NOT_FOUND                (EA_DS | 0x12)
#define EA_AACCODER_RUNTIME_ERROR          (EA_DS | 0x13)
#define EA_WMACODER_RUNTIME_ERROR          (EA_DS | 0x14)
// VPCX ADD - End


// Complete API warning code for real time class
// ---------------------------------------------
#define WA_RT           (WARNING_VALUE | E_SOURCE_API | E_CLASS_REAL_TIME_ERROR)
#define WA_CANNOT_CANCEL                (WA_RT | 0x07)

// Complete DRV error code for the general class
// ---------------------------------------------
#define ED_GN           (ERROR_VALUE | E_SOURCE_DRV | E_CLASS_GENERAL)
#define ED_CONCURRENCY                  (ED_GN | 0x01)
#define ED_DSP_CRASHED                  (ED_GN | 0x02)
#define ED_UNKNOWN_BOARD                (ED_GN | 0x03)
#define ED_NOT_INSTALLED                (ED_GN | 0x04)
#define ED_CANNOT_OPEN_SVC_MANAGER      (ED_GN | 0x05)
#define ED_CANNOT_READ_REGISTRY         (ED_GN | 0x06)
#define ED_DSP_VERSION_MISMATCH         (ED_GN | 0x07)
#define ED_UNAVAILABLE_FEATURE          (ED_GN | 0x08)
#define ED_CANCELLED                    (ED_GN | 0x09)
#define ED_NO_RESPONSE_AT_IRQA          (ED_GN | 0x10)
#define ED_INVALID_ADDRESS              (ED_GN | 0x11)
#define ED_DSP_CORRUPTED                (ED_GN | 0x12)
#define ED_PENDING_OPERATION            (ED_GN | 0x13)
#define ED_NET_ALLOCATE_MEMORY_IMPOSSIBLE   (ED_GN | 0x14)
#define ED_NET_REGISTER_ERROR               (ED_GN | 0x15)
#define ED_NET_THREAD_ERROR                 (ED_GN | 0x16)
#define ED_NET_OPEN_ERROR                   (ED_GN | 0x17)
#define ED_NET_CLOSE_ERROR                  (ED_GN | 0x18)
#define ED_NET_NO_MORE_PACKET               (ED_GN | 0x19)
#define ED_NET_NO_MORE_BUFFER               (ED_GN | 0x1A)
#define ED_NET_SEND_ERROR                   (ED_GN | 0x1B)
#define ED_NET_RECEIVE_ERROR                (ED_GN | 0x1C)
#define ED_NET_WRONG_MSG_SIZE               (ED_GN | 0x1D)
#define ED_NET_WAIT_ERROR                   (ED_GN | 0x1E)
#define ED_NET_EEPROM_ERROR                 (ED_GN | 0x1F)
#define ED_INVALID_RS232_COM_NUMBER         (ED_GN | 0x20)
#define ED_INVALID_RS232_INIT               (ED_GN | 0x21)
#define ED_FILE_ERROR                       (ED_GN | 0x22)
#define ED_INVALID_GPIO_CMD                 (ED_GN | 0x23)
#define ED_RS232_ALREADY_OPENED             (ED_GN | 0x24)
#define ED_RS232_NOT_OPENED                 (ED_GN | 0x25)
#define ED_GPIO_ALREADY_OPENED              (ED_GN | 0x26)
#define ED_GPIO_NOT_OPENED                  (ED_GN | 0x27)
#define ED_REGISTRY_ERROR                   (ED_GN | 0x28)// <- NCX
#define ED_INVALID_SERVICE                  (ED_GN | 0x29)// <- NCX

#define ED_READ_FILE_ALREADY_OPENED			    (ED_GN | 0x2a)// <- Decalage pour RCX (old 0x28)
#define ED_READ_FILE_INVALID_COMMAND		    (ED_GN | 0x2b)// ~
#define ED_READ_FILE_INVALID_PARAMETER		  (ED_GN | 0x2c)// ~
#define ED_READ_FILE_ALREADY_CLOSED			    (ED_GN | 0x2d)// ~
#define ED_READ_FILE_NO_INFORMATION			    (ED_GN | 0x2e)// ~
#define ED_READ_FILE_INVALID_HANDLE			    (ED_GN | 0x2f)// ~
#define ED_READ_FILE_END_OF_FILE			      (ED_GN | 0x30)// ~
#define ED_READ_FILE_ERROR					        (ED_GN | 0x31)// ~

#define ED_DSP_CRASHED_EXC_DSPSTACK_OVERFLOW (ED_GN | 0x32)// <- Decalage pour PCX (old 0x14)
#define ED_DSP_CRASHED_EXC_SYSSTACK_OVERFLOW (ED_GN | 0x33)// ~
#define ED_DSP_CRASHED_EXC_ILLEGAL           (ED_GN | 0x34)// ~
#define ED_DSP_CRASHED_EXC_TIMER_REENTRY     (ED_GN | 0x35)// ~
#define ED_DSP_CRASHED_EXC_FATAL_ERROR       (ED_GN | 0x36)// ~

#define ED_FLASH_PCCARD_NOT_PRESENT          (ED_GN | 0x37)

#define ED_NO_CURRENT_CLOCK                  (ED_GN | 0x38)


// Complete DRV warning code for the general class
// ---------------------------------------------
#define WD_GN           (WARNING_VALUE | E_SOURCE_DRV | E_CLASS_GENERAL)
#define WD_MORE_DATA                    (WD_GN | 0x01)
#define WD_NO_MORE_DATA                 (WD_GN | 0x02)
#define WD_DSP_VERSION_MISMATCH         (WD_GN | 0x07)
#define WD_IBL_CLIPPED                  (WD_GN | 0x08)	/**< on VX: when Internal Buffer Latency settings are not in accordance with granularity.*/
#define WD_FLASH_CARD_REINSERTED        (WD_GN | 0x17)


// Complete DRV error code for the invalid command class
// -----------------------------------------------------
#define ED_IC           (ERROR_VALUE | E_SOURCE_DRV | E_CLASS_INVALID_CMD)
#define ED_INVALID_FAM                  (ED_IC | 0x01)
#define ED_INVALID_CMD_FAM1             (ED_IC | 0x02)
#define ED_INVALID_CMD_FAM2             (ED_IC | 0x03)
#define ED_INVALID_CMD_FAM3             (ED_IC | 0x04)
#define ED_INVALID_CMD_FAM4             (ED_IC | 0x05)
#define ED_INVALID_CMD_FAM5             (ED_IC | 0x06)
#define ED_INVALID_CMD_FAM6             (ED_IC | 0x07)
#define ED_INVALID_CMD_FAM7             (ED_IC | 0x08)
#define ED_INVALID_CMD_FAM8             (ED_IC | 0x09)
#define ED_INVALID_CMD_FAM9             (ED_IC | 0x0A)
#define ED_INVALID_CMD_FAM10            (ED_IC | 0x0B)
#define ED_INVALID_CMD_FAM11            (ED_IC | 0x0C)
#define ED_INVALID_CMD_FAM12            (ED_IC | 0x0D)
#define ED_INVALID_CMD_FAM13            (ED_IC | 0x0E)

// Complete DRV error code for the invalid standard object class
// -------------------------------------------------------------
#define ED_ISO          (ERROR_VALUE | E_SOURCE_DRV | E_CLASS_INVALID_STD_OBJECT)
#define ED_INVALID_PCX_HANDLE           (ED_ISO | 0x01)
#define ED_INVALID_PIPE                 (ED_ISO | 0x02)
#define ED_INVALID_STREAM               (ED_ISO | 0x03)
#define ED_INVALID_PIPE_AUDIO           (ED_ISO | 0x04)
#define ED_INVALID_BUFFER               (ED_ISO | 0x05)
#define ED_INVALID_DSP_SOFTWARE         (ED_ISO | 0x06)
#define ED_INVALID_BOARD                (ED_ISO | 0x07)
#define ED_INVALID_DSP                  (ED_ISO | 0x08)
#define ED_INVALID_BOARD_AUDIO          (ED_ISO | 0x09)
#define ED_INVALID_FREQUENCY            (ED_ISO | 0x0a)

// Complete DRV warning code for impossible resource allocation class
// ------------------------------------------------------------------
#define WD_RI           (WARNING_VALUE | E_SOURCE_DRV | E_CLASS_RSRC_IMPOSSIBLE)
#define WD_UNDER_ALLOCATE_BUFFER        (WD_RI | 0x01)
#define WD_REPLY_TRUNCATED              (WD_RI | 0x02)

// Complete DRV error code for impossible resource allocation class
// ----------------------------------------------------------------
#define ED_RI           (ERROR_VALUE | E_SOURCE_DRV | E_CLASS_RSRC_IMPOSSIBLE)
#define ED_DECL_APP_IMPOSSIBLE          (ED_RI | 0x01)
#define ED_SET_CLOCK_IMPOSSIBLE         (ED_RI | 0x02)
#define ED_ALLOCATE_BUFFER_IMPOSSIBLE   (ED_RI | 0x03)
#define ED_ALLOCATE_AUDIO_IMPOSSIBLE    (ED_RI | 0x04)
#define ED_LOAD_DSP_IMPOSSIBLE          (ED_RI | 0x05)
#define ED_REQUEST_BLOC_TOO_SHORT       (ED_RI | 0x06)
#define ED_ALLOCATE_STREAM_IMPOSSIBLE   (ED_RI | 0x07)
#define ED_REPLY_BLOC_TOO_SHORT         (ED_RI | 0x08)
#define ED_ALLOCATE_MEMORY_IMPOSSIBLE   (ED_RI | 0x09)
#define ED_NON_COBRANET_CLOCK_REFUSED   (ED_RI | 0x0A)
#define ED_NON_ETHERSOUND_CLOCK_REFUSED (ED_RI | 0x0B)

// Complete DRV warning code for wrong call context class
// ----------------------------------------------------
#define WD_WCC          (WARNING_VALUE | E_SOURCE_DRV | E_CLASS_WRONG_CONTEXT)
#define WD_PRIVATE_DATA                 (WD_WCC | 0x01)
#define WD_NO_HARDWARE_SUPPORT          (WD_WCC | 0x02)
#define WD_COBRANET_CLOCK_SELECTED      (WD_WCC | 0x03)
#define WD_AUDIO_MANAGED_BY_CONSOLE     (WD_WCC | 0x04)

// Complete DRV error code for wrong call context class
// ----------------------------------------------------
#define ED_WCC          (ERROR_VALUE | E_SOURCE_DRV | E_CLASS_WRONG_CONTEXT)
#define ED_USE_DSP_REFUSED                (ED_WCC | 0x01)
#define ED_FREE_DSP_REFUSED               (ED_WCC | 0x02)
#define ED_SUPPRESS_PIPE_REFUSED          (ED_WCC | 0x03)
#define ED_SET_CLOCK_REFUSED              (ED_WCC | 0x04)
#define ED_DIFFERED_CMD_REFUSED           (ED_WCC | 0x05)
#define ED_SET_CLOCK_THESEPIPES_REFUSED   (ED_WCC | 0x06)
#define ED_MANY_PIPES_REFUSED             (ED_WCC | 0x07)
#define ED_MANY_AUDIOS_REFUSED            (ED_WCC | 0x08)
#define ED_SET_PIPE_SOURCE_REFUSED        (ED_WCC | 0x09)
#define ED_CONTEXT_REFUSED                (ED_WCC | 0x0a)
#define ED_START_IN_PROGRESS              (ED_WCC | 0x0b)
#define ED_START_ON_TIME_CODE_IN_PROGRESS (ED_WCC | 0x0c)
#define ED_START_ON_VSYNC_IN_PROGRESS     (ED_WCC | 0x0d)
#define ED_AUDIO_MANAGED_BY_DHS_PANEL     (ED_WCC | 0x0e)
#define ED_CLOCK_MANAGED_BY_DHS_PANEL     (ED_WCC | 0x0f)


// Complete DRV error code for bad specific parameter class
// ----------------------------------------------------------
#define ED_WSP      (ERROR_VALUE | E_SOURCE_DRV | E_CLASS_BAD_SPECIFIC_PARAMETER)
#define ED_APPLICATION_NAME_SIZE            (ED_WSP | 0x01)
#define ED_UNKNOWN_APPLICATION_ATTRIB       (ED_WSP | 0x02)
#define ED_UNKNOWN_PIPE_ATTRIB              (ED_WSP | 0x03)
#define ED_UNKNOWN_AUDIO_ATTRIB             (ED_WSP | 0x04)
#define ED_INCOMPATIBLE_PIPE_AUDIO_ATTRIB   (ED_WSP | 0x05)
#define ED_FORMAT_NOT_SUPPORTED             (ED_WSP | 0x06)
#define ED_LEVEL_OUT_OF_RANGE               (ED_WSP | 0x07)
#define ED_CLOCK_UER_BOARD                  (ED_WSP | 0x08)
#define ED_BAD_UER_FREQUENCY                (ED_WSP | 0x09)
#define ED_BAD_UER_MODE                     (ED_WSP | 0x0A)
#define ED_BAD_CLOCK_FREQUENCY              (ED_WSP | 0x0B)
#define ED_BAD_VALIDATION_MASK              (ED_WSP | 0x0C)
#define ED_BAD_SOURCE                       (ED_WSP | 0x0D)
#define ED_CLOCK_WORD_CLOCK_BOARD           (ED_WSP | 0x0E)
#define ED_CONTEXT_NOT_FOUND                (ED_WSP | 0x0F)
#define ED_CMD_MUST_BE_DIFFERED             (ED_WSP | 0x10)
#define ED_CLOCK_PROGRAMMABLE_CLOCK_BOARD   (ED_WSP | 0x11)
#define ED_BAD_UER_EXTRA_PARAM              (ED_WSP | 0x12)
#define ED_SRC_UNAVAILABLE                  (ED_WSP | 0x13)

// Complete DRV warning code for real time class
// ---------------------------------------------
#define WD_RT           (WARNING_VALUE | E_SOURCE_DRV | E_CLASS_REAL_TIME_ERROR)
#define WD_UER_FREQUENCY_MODIFICATION           (WD_RT | 0x01)
#define WD_WORD_CLOCK_FREQUENCY_MODIFICATION    (WD_RT | 0x02)
#define WD_UER_CLOCK_LOST					    (WD_RT | 0x03)
#define WD_EXTERNAL_CLOCK_LOST				    WD_UER_CLOCK_LOST
#define WD_SRC_ASSIGNED                         (WD_RT | 0x04)
#define WD_CANNOT_CANCEL                        (WD_RT | 0x07)

// Complete DRV error code for real time class
// ---------------------------------------------
#define ED_RT           (ERROR_VALUE | E_SOURCE_DRV | E_CLASS_REAL_TIME_ERROR)
#define ED_DSP_TIMED_OUT                (ED_RT | 0x01)
#define ED_DSP_CHK_TIMED_OUT            (ED_RT | 0x02)
#define ED_STREAM_OVERRUN               (ED_RT | 0x03)
#define ED_DSP_BUSY                     (ED_RT | 0x04)
#define ED_DSP_SEMAPHORE_TIME_OUT       (ED_RT | 0x05)
#define ED_BOARD_TIME_OUT               (ED_RT | 0x06)
#define ED_XILINX_ERROR                 (ED_RT | 0x07)
#define ED_COBRANET_ITF_NOT_RESPONDING  (ED_RT | 0x08)

// Complete BOARD error code for the general class
// -----------------------------------------------
#define EB_GN           (ERROR_VALUE | E_SOURCE_BOARD | E_CLASS_GENERAL)

// Complete BOARD warning code for the invalid command class
// -------------------------------------------------------
#define WB_IC           (WARNING_VALUE | E_SOURCE_BOARD | E_CLASS_INVALID_CMD)
#define WB_COMMAND_NOT_IMPLEMENTED_YET          (WB_IC | 0x00)

// Complete BOARD error code for the invalid command class
// -------------------------------------------------------
#define EB_IC           (ERROR_VALUE | E_SOURCE_BOARD | E_CLASS_INVALID_CMD)
#define EB_INVALID_COMMAND              (EB_IC | 0x00)

// Complete BOARD error code for the invaid standard object class
// --------------------------------------------------------------
#define EB_ISO          (ERROR_VALUE | E_SOURCE_BOARD | E_CLASS_INVALID_STD_OBJECT)
#define EB_INVALID_EFFECT               (EB_ISO | 0x00)
#define EB_INVALID_PIPE                 (EB_ISO | 0x40)
#define EB_INVALID_STREAM               (EB_ISO | 0x80)
#define EB_INVALID_AUDIO                (EB_ISO | 0xC0)

// Complete BOARD warning code for impossible resource allocation class
// ------------------------------------------------------------------
#define WB_RI           (WARNING_VALUE | E_SOURCE_BOARD | E_CLASS_RSRC_IMPOSSIBLE)
#define WB_LOW_DIFFERED_COMMAND                 (WB_RI | 0x06)
#define WB_COMMAND_WILL_NOT_BE_NOTIFIED         (WB_RI | 0x07)
#define WB_WILL_NOT_BE_NOTIFIED                 WB_COMMAND_WILL_NOT_BE_NOTIFIED
#define WB_PREVIOUS_STATUS_DIALOG_IMPOSSIBLE    (WB_RI | 0x1C)
#define WB_STATUS_TOO_BIG                       (WB_RI | 0x1F)

// Complete BOARD error code for impossible resource allocation class
// ------------------------------------------------------------------
#define EB_RI           (ERROR_VALUE | E_SOURCE_BOARD | E_CLASS_RSRC_IMPOSSIBLE)
#define EB_ALLOCATE_ALL_STREAM_TRANSFERT_BUFFERS_IMPOSSIBLE (EB_RI | 0x01)
#define EB_ALLOCATE_PIPE_SAMPLE_BUFFER_IMPOSSIBLE           (EB_RI | 0x02)

#define EB_ALLOCATE_MEM_STREAM_IMPOSSIBLE       EB_ALLOCATE_ALL_STREAM_TRANSFERT_BUFFERS_IMPOSSIBLE
#define EB_ALLOCATE_MEM_PIPE_IMPOSSIBLE         EB_ALLOCATE_PIPE_SAMPLE_BUFFER_IMPOSSIBLE

#define EB_ALLOCATE_DIFFERED_CMD_IMPOSSIBLE     (EB_RI | 0x03)
#define EB_TOO_MANY_DIFFERED_CMD                (EB_RI | 0x04)
#define EB_RBUFFERS_TABLE_OVERFLOW              (EB_RI | 0x05)
#define EB_ALLOCATE_EFFECTS_IMPOSSIBLE          (EB_RI | 0x08)
#define EB_ALLOCATE_EFFECT_POS_IMPOSSIBLE       (EB_RI | 0x09)
#define EB_RBUFFER_NOT_AVAILABLE                (EB_RI | 0x0A)
#define EB_ALLOCATE_CONTEXT_LIII_IMPOSSIBLE     (EB_RI | 0x0B)
#define EB_STATUS_DIALOG_IMPOSSIBLE             (EB_RI | 0x1D)
#define EB_CONTROL_CMD_IMPOSSIBLE               (EB_RI | 0x1E)
#define EB_STATUS_SEND_IMPOSSIBLE               (EB_RI | 0x1F)
#define EB_ALLOCATE_PIPE_IMPOSSIBLE             (EB_RI | 0x40)
#define EB_ALLOCATE_STREAM_IMPOSSIBLE           (EB_RI | 0x80)
#define EB_ALLOCATE_AUDIO_IMPOSSIBLE            (EB_RI | 0xC0)
//Debut miXart specifique
#define EB_CLOCK_ALREADY_CAPTURED               (EB_RI | 0xD0)
#define EB_NO_CURRENT_CLOCK                     (EB_RI | 0xD1)

//Fin   miXart

// Complete BOARD error code for wrong call context class
// ------------------------------------------------------
#define EB_WCC          (ERROR_VALUE | E_SOURCE_BOARD | E_CLASS_WRONG_CONTEXT)
#define EB_CMD_REFUSED                  (EB_WCC | 0x00)
#define EB_START_STREAM_REFUSED         (EB_WCC | 0xFC)
#define EB_SPC_REFUSED                  (EB_WCC | 0xFD)
#define EB_CSN_REFUSED                  (EB_WCC | 0xFE)
#define EB_CSE_REFUSED                  (EB_WCC | 0xFF)

// Complete BOARD warning code for bad specific parameter class
// ------------------------------------------------------------
#define WB_WSP    (WARNING_VALUE | E_SOURCE_BOARD | E_CLASS_BAD_SPECIFIC_PARAMETER)
#define WB_BAD_EFFECT_PARAMETER         (WB_WSP | 0x42)

// Complete BOARD error code for bad specific parameter class
// ------------------------------------------------------------
#define EB_WSP    (ERROR_VALUE | E_SOURCE_BOARD | E_CLASS_BAD_SPECIFIC_PARAMETER)
#define EB_BAD_DSP_MESSAGE_SIZE         (EB_WSP | 0x01)

#define EB_BAD_CLOCK_FREQUENCY          (EB_WSP | 0x30)

#define EB_BAD_PIPE_MESSAGE_SIZE        (EB_WSP | 0x41)
#define EB_BAD_EFFECT_PARAMETER         (EB_WSP | 0x42)
#define EB_BAD_STREAM_MESSAGE_SIZE      (EB_WSP | 0x81)

#define EB_BAD_AUDIO_MESSAGE_SIZE       (EB_WSP | 0xC1)
#define EB_BAD_DSP_MESSAGE_PARAMETER    (EB_WSP | 0x20)
#define EB_BAD_PIPE_MESSAGE_PARAMETER   (EB_WSP | 0x60)
#define EB_BAD_STREAM_MESSAGE_PARAMETER (EB_WSP | 0xA0)
#define EB_BAD_AUDIO_MESSAGE_PARAMETER  (EB_WSP | 0xE0)

#define EB_BAD_DSPMESSAGE_SIZE          EB_BAD_DSP_MESSAGE_SIZE
#define EB_BAD_PIPEMESSAGE_SIZE         EB_BAD_PIPE_MESSAGE_SIZE

#define EB_BAD_STREAMMESSAGE_SIZE       EB_BAD_STREAM_MESSAGE_SIZE
#define EB_BAD_AUDIOMESSAGE_SIZE        EB_BAD_DSP_MESSAGE_PARAMETER
#define EB_BAD_DSPMESSAGE_PARAMETER     EB_BAD_DSP_MESSAGE_PARAMETER
#define EB_BAD_PIPEMESSAGE_PARAMETER    EB_BAD_PIPE_MESSAGE_PARAMETER
#define EB_BAD_STREAMMESSAGE_PARAMETER  EB_BAD_STREAM_MESSAGE_PARAMETER
#define EB_BAD_AUDIOMESSAGE_PARAMETER   EB_BAD_AUDIO_MESSAGE_PARAMETER

#define EB_CANNOT_READ_TIME_CODE        (EB_WSP | 0xF0)
#define EB_CANNOT_READ_VSYNC            (EB_WSP | 0xF1)
#define EB_CANNOT_WRITE_VSYNC           (EB_WSP | 0xF2)

// Complete BOARD warning code for real time class
// ---------------------------------------------
#define WB_RT           (WARNING_VALUE | E_SOURCE_BOARD | E_CLASS_REAL_TIME_ERROR)
#define WB_CANNOT_CANCEL                (WB_RT | 0x0A)

// Complete BOARD error code for real time class
// ---------------------------------------------
#define EB_RT           (ERROR_VALUE | E_SOURCE_BOARD | E_CLASS_REAL_TIME_ERROR)
#define EB_STREAM_UNDERRUN                  (EB_RT | 0x01)
#define EB_STREAM_FRAME_CRC_FAILED          (EB_RT | 0x02)
#define EB_STREAM_INVALID_FRAME             (EB_RT | 0x03)
#define EB_STREAM_INCOMPATIBLE_LAYER        (EB_RT | 0x04)
#define EB_STREAM_RBUFFER_READ_ERROR        (EB_RT | 0x05)
#define EB_STREAM_RBUFFER_TOO_SMALL         (EB_RT | 0x06)
#define EB_STREAM_FORMAT_MISUSED            (EB_RT | 0x07)
#define EB_STREAM_RBUFFER_WRITE_ERROR       (EB_RT | 0x08)
#define EB_STREAM_LAYER3_FRAME_ERROR        (EB_RT | 0x09)
#define EB_STREAM_MULTICHANNEL_ERROR        (EB_RT | 0x0B)
#define EB_PIPE_UNDERRUN                    (EB_RT | 0x10)
#define EB_START_ON_TIME_CODE_FAILED        (EB_RT | 0x11)

#define EB_STREAM_FAILED_CRC            EB_STREAM_FRAME_CRC_FAILED
#define EB_STREAM_INVALID_LAYER         EB_STREAM_INCOMPATIBLE_LAYER

// Complete BOARD error code for internal error class
// --------------------------------------------------
#define EB_IE           (ERROR_VALUE | E_SOURCE_BOARD | E_CLASS_FREE)
#define EB_GENERIC_FATAL_ERROR          (EB_IE | 0x00)
#define EB_CSNR_I1_FATAL_ERROR          (EB_IE | 0x01)
#define EB_CSNR_I2_FATAL_ERROR          (EB_IE | 0x02)
#define EB_CSNR_I3_FATAL_ERROR          (EB_IE | 0x04)
#define EB_REENTRY_FATAL_ERROR          (EB_IE | 0x08)
#define EB_CONN_RE_FATAL_ERROR          (EB_IE | 0x10)


//*************WARNING AND & ERROR for the new DISPATCHER*******************
//--------------------------------------------------------------------------
// Complete DISP warning code for the general class
#define WS_GN           (WARNING_VALUE | E_SOURCE_DISPATCHER | E_CLASS_GENERAL)
#define WS_DISPATCHER                         (WS_GN | 0x00)
#define WS_NEW_MODE_ALREADY_DEFINE            (WS_GN | 0x01)
#define WS_ALREADY_INITIALIZED                (WS_GN | 0x02)
#define WS_INVALID_API_MODE_SELECTED_KEEP_OLD (WS_GN | 0x03)

// Complete DISP warning code for the invalid command class
#define WS_IC           (WARNING_VALUE | E_SOURCE_DISPATCHER | E_CLASS_INVALID_CMD)

// Complete DISP warning code for the internal class
#define WS_IE           (WARNING_VALUE | E_SOURCE_DISPATCHER | E_CLASS_FREE)

// Complete DISP warning code for the invalid standard object class
#define WS_ISO          (WARNING_VALUE | E_SOURCE_DISPATCHER | E_CLASS_INVALID_STD_OBJECT)

// Complete DISP warning code for the bad specific parameter class
#define WS_WSP          (WARNING_VALUE | E_SOURCE_DISPATCHER | E_CLASS_BAD_SPECIFIC_PARAMETER)

// Complete DISP warning code for the real time class
#define WS_RT           (WARNING_VALUE | E_SOURCE_DISPATCHER | E_CLASS_REAL_TIME_ERROR)

// Complete DISP warning code for impossible resource allocation class
#define WS_RI           (WARNING_VALUE | E_SOURCE_DISPATCHER | E_CLASS_RSRC_IMPOSSIBLE)

// Complete DISP warning code for wrong call context class
#define WS_WCC          (WARNING_VALUE | E_SOURCE_DISPATCHER | E_CLASS_WRONG_CONTEXT)

// Complete DISP warning code for direct show problems class
#define WS_DS           (WARNING_VALUE | E_SOURCE_DISPATCHER | E_CLASS_DIRECTSHOW)


// Complete DISP error code for the general class
#define ES_GN           (ERROR_VALUE | E_SOURCE_DISPATCHER | E_CLASS_GENERAL)
#define ES_CANNOT_FIND_PIPE_HANDLE              (ES_GN | 0x00)
#define ES_CANNOT_FIND_BOARD_HANDLE             (ES_GN | 0x01)
#define ES_CANNOT_FIND_LIST                     (ES_GN | 0x02)
#define ES_CANNOT_FIND_DATA                     (ES_GN | 0x03)
#define ES_CANNOT_ADD_ELEMENT_TO_LIST           (ES_GN | 0x04)
#define ES_CANNOT_REMOVE_ELEMENT_FROM_LIST      (ES_GN | 0x05)
#define ES_CANNOT_DISPATCH_FUNCTION             (ES_GN | 0x06)
#define ES_FUNCTION_NOT_IMPLEMENTED             (ES_GN | 0x07)
#define ES_ELEMENT_DOES_NOT_EXIST               (ES_GN | 0x08)
#define ES_ELEMENT_DOES_NOT_EXIST_IN_LIST       (ES_GN | 0x09)
#define ES_ELEMENT_NOT_FOUND_IN_LIST            (ES_GN | 0x0A)
#define ES_LIST_DOES_NOT_EXIST                  (ES_GN | 0x0B)
#define ES_LIST_EMPTY                           (ES_GN | 0x0C)
#define ES_DATA_DOES_NOT_EXIST                  (ES_GN | 0x0D)
#define ES_DATA_NOT_FOUND_IN_LIST               (ES_GN | 0x0E)
#define ES_FAILED                               (ES_GN | 0x0F)
#define ES_CANNOT_DETACH_DATA_FROM_LIST         (ES_GN | 0x10)
#define ES_NOT_IMPLEMENTED                      (ES_GN | 0x11)
#define ES_BOARD_NOT_FOUND                      (ES_GN | 0x12)
#define ES_INVALID_MODE                         (ES_GN | 0x13)
#define ES_ALREADY_INITIALIZED                  (ES_GN | 0x14)
#define ES_NOT_INITIALIZED                      (ES_GN | 0x15)
#define ES_MAXIMUM_APPLI_REACH                  (ES_GN | 0x16)
#define ES_NEED_REGISTRATION                    (ES_GN | 0x17)
#define ES_DATA_ALREADY_IN_LIST                 (ES_GN | 0x18)
#define ES_NO_API_TO_LOAD                       (ES_GN | 0x19)


// Complete DISP error code for the invalid command class
#define ES_IC           (ERROR_VALUE | E_SOURCE_DISPATCHER | E_CLASS_INVALID_CMD)
#define ES_COMMAND_NOT_AVAILABLE                (ES_IC | 0x00)

// Complete DISP error code for the internal class
#define ES_IE           (ERROR_VALUE | E_SOURCE_DISPATCHER | E_CLASS_FREE)

// Complete DISP error code for the invalid standard object class
#define ES_ISO          (ERROR_VALUE | E_SOURCE_DISPATCHER | E_CLASS_INVALID_STD_OBJECT)

// Complete DISP error code for the bad specific parameter class
#define ES_WSP          (ERROR_VALUE | E_SOURCE_DISPATCHER | E_CLASS_BAD_SPECIFIC_PARAMETER)
#define ES_INVALID_PIPE                         (ES_WSP | 0x01)
#define ES_INVALID_PIPE_OUT                     (ES_WSP | 0x02)
#define ES_INVALID_PIPE_IN                      (ES_WSP | 0x03)
#define ES_INVALID_BOARD                        (ES_WSP | 0x04)
#define ES_INVALID_LIST                         (ES_WSP | 0x05)
#define ES_INVALID_DATA                         (ES_WSP | 0x06)
#define ES_INVALID_PARAMETER                    (ES_WSP | 0x07)
#define ES_INVALID_HANDLE                       (ES_WSP | 0x08)
#define ES_INVALID_LOGICAL_NUMBER               (ES_WSP | 0x09)

// Complete DISP error code for the real time class
#define ES_RT           (ERROR_VALUE | E_SOURCE_DISPATCHER | E_CLASS_REAL_TIME_ERROR)

// Complete DISP error code for impossible resource allocation class
#define ES_RI           (ERROR_VALUE | E_SOURCE_DISPATCHER | E_CLASS_RSRC_IMPOSSIBLE)
#define ES_ALLOCATE_PIPE_HANDLE            (ES_RI | 0x00)
#define ES_ALLOCATE_BOARD_HANDLE           (ES_RI | 0x01)
#define ES_ALLOCATE_LIST                   (ES_RI | 0x02)
#define ES_ALLOCATE_ELEMENT                (ES_RI | 0x03)
#define ES_ALLOCATE_MEMORY                 (ES_RI | 0x04)
#define ES_CANNOT_FREE_PIPE_HANDLE         (ES_RI | 0x05)
#define ES_CANNOT_FREE_BOARD_HANDLE        (ES_RI | 0x06)
#define ES_CANNOT_FREE_LIST                (ES_RI | 0x07)
#define ES_CANNOT_FREE_ELEMENT             (ES_RI | 0x08)
#define ES_CANNOT_FREE_BIG_BLOC            (ES_RI | 0x09)
#define ES_LIST_OF_LIST_NOT_VALID          (ES_RI | 0x0a)
#define ES_INVALID_POINTER                 (ES_RI | 0x0b)
#define ES_NO_MORE_ROOM_AVAILABLE          (ES_RI | 0x0c)

// Complete DISP error code for wrong call context class
#define ES_WCC          (ERROR_VALUE | E_SOURCE_DISPATCHER | E_CLASS_WRONG_CONTEXT)

// Complete DISP error code for direct show problems class
#define ES_DS           (ERROR_VALUE | E_SOURCE_DISPATCHER | E_CLASS_DIRECTSHOW)


//************* WARNINGS AND ERRORS coming form CobraNet firmware *******************
//--------------------------------------------------------------------------
// Complete warning codes for the general class
#define WC_GN           (WARNING_VALUE | E_SOURCE_COBRANET | E_CLASS_GENERAL)


// Complete error codes for the general class
#define EC_GN           (ERROR_VALUE | E_SOURCE_COBRANET | E_CLASS_GENERAL)

//******************************FIN************************************

//}
#endif

