// ***************************************************************************
//
// COPYRIGHT 1996-1999 DIGIGRAM. ALL RIGHTS RESERVED
//
// DIGIGRAM
//
// ***************************************************************************
//
//   PcxApi_E.h
//
//   Project         : np SDK
//                     Common file
//
//  Description      : header file for the interface between an
//                     application and the np driver API.
//
//  Author(s)        : FG-PhG-FB-FS-DS-FM
//
//  Creation Date    : 13 September 1996
//  Last Modification $Date: 22/05/06 15:10 $ by $Author: Mtr $ 
//
// ***************************************************************************

#ifndef _PCXAPI_H_
//{
#define _PCXAPI_H_

// TAG_DEBUG_DRIVER : DEB

#ifdef __STDC__
  #define _CDECL_
#else
  #define _CDECL_ _cdecl
#endif

// TAG_DEBUG_DRIVER : FIN

// *******************************************************************
// Included files
// *******************************************************************

#include "PcxAll_E.h"
#include "PcxDef_E.h"
#include "PcxErr_E.h"

//*********************************************************************
// Type definitions
//*********************************************************************
#pragma pack(1)
//{


typedef struct _INIT_INFO
{
    BYTE                iiUnused0;
    PCHAR               iiIniFile;
    BYTE                iiUnused1;
    WORD                iiMode;
    //With the new dispatcher we can choose either old more or new one 
    // DISP_OLD_MODE or DISP_NEW_MODE

    DWORD               iiFlags;
    DWORD               iiUnused4;
    DWORD               iiUnused5;
    DWORD               iiUnused6;
    DWORD               iiUnused7;
    DWORD               iiUnused8;
} INIT_INFO, *PINIT_INFO;

typedef struct _UNINIT_INFO
{
    DWORD               uiUnused0;
    DWORD               uiUnused1;
    DWORD               uiUnused2;
    DWORD               uiUnused3;
    DWORD               uiUnused4;
    DWORD               uiUnused5;
    DWORD               uiUnused6;
    DWORD               uiReserved1;

} UNINIT_INFO, *PUNINIT_INFO;



#if defined(WIN32) && (defined(_UNICODE) || defined(UNICODE))
#define _APP_DECL_INFO  _APP_DECL_INFO_W
#define APP_DECL_INFO   APP_DECL_INFO_W
#define PAPP_DECL_INFO  PAPP_DECL_INFO_W
#else
#define _APP_DECL_INFO  _APP_DECL_INFO_A
#define APP_DECL_INFO   APP_DECL_INFO_A
#define PAPP_DECL_INFO  PAPP_DECL_INFO_A
#endif
#ifdef WIN32
typedef struct _APP_DECL_INFO_W
{
    BYTE                adAppAttributes;
    BYTE                adUnused1[3];
    HANDLE              adWinHandle;
    DWORD               adWinMessage;
    BYTE                adWhichAPI;          
    BYTE                adUnused2;
    WORD                adUnused3;
    DWORD               adAppInfoEx;
    WCHAR               adAppName[((SIZE_MAX_APP_NAME+1+3)/4)*4];
} APP_DECL_INFO_W, *PAPP_DECL_INFO_W ;
#endif

typedef struct _APP_DECL_INFO_A
{
    BYTE                adAppAttributes;
    BYTE                adUnused1[3];
    HANDLE              adWinHandle;
    DWORD               adWinMessage;
    BYTE                adWhichAPI; 
    BYTE                adUnused2;
    WORD                adUnused3;
    DWORD               adAppInfoEx;
    CHAR                adAppName[((SIZE_MAX_APP_NAME+1+3)/4)*4];
} APP_DECL_INFO_A, *PAPP_DECL_INFO_A, FAR *LPAPP_DECL_INFO_A ;

typedef struct _DSP_FEATURES_INFO
{
    BYTE                dfDspState;
    BYTE                dfUnused1;
    WORD                dfUnused2;
    BYTE                dfNbAppli;
    BYTE                dfUnused3;
    WORD                dfUnused4;
    DWORD               dfFeaturesEx;	
    DWORD               dfFirmwareVersion;	/**The firmware version as 0x00MMmmbb, update is required if MM or mm do not match the driver.*/
    DWORD               dfManagedPhysicalOutMask;	/**< deprecated.*/
    DWORD               dfManagedVirtualOutMask;	/**< deprecated.*/
    DWORD               dfManagedPhysicalInMask;	/**< deprecated.*/
    DWORD               dfManagedVirtualInMask;		/**< deprecated.*/
    DWORD               dfPhysicalOutMask;
    DWORD               dfVirtualOutMask;
    DWORD               dfPhysicalInMask;
    DWORD               dfVirtualInMask;
    BYTE                dfMaxBoardOutStream;
    BYTE                dfMaxPipeOutStream;
	WORD				dfManagedPhysicalOutputFirst;	/**< the index of the first output managed by this CPU.*/
    WORD				dfManagedPhysicalOutputNumber;	/**< the number of (contiguous) outputs managed by this CPU.*/
    WORD				dfManagedPhysicalInputFirst;	/**< the index of the first output managed by this CPU.*/
    WORD				dfManagedPhysicalInputNumber; 	/**< the number of (contiguous) inputs managed by this CPU.*/
    WORD                dfUnused6;
    DWORD               dfUnused7;	
    DWORD               dfUnused8;
    DWORD               dfUnused9;
    DWORD               dfUnused10;
    DWORD               dfUnused11;
    DWORD               dfUnused12;
} DSP_FEATURES_INFO, *PDSP_FEATURES_INFO;

typedef struct _CARD_FEATURES_INFO
{
    BYTE                ciBoardType;
    BYTE                ciBusType;
    BYTE                ciNbWordClock;
    BYTE                ciMiscFeatures;
    BYTE                ciDigitalSynchroInNumber;
    BYTE                ciFileManagement;
    WORD                ciAllocatedBufferNumber;
    BYTE                ciDspNumber;
    BYTE                ciTotalBoardOnDriver;//Total board on the same driver //ciMemoryType;
    WORD                ciAvailableBufferNumber;//added
    DWORD               ciBaseAddress1;
    DWORD               ciEndAddress1;
    DWORD               ciBaseAddress2;
    DWORD               ciEndAddress2;
    DWORD               ciEtherSound0;    /**< board dependent Ethersound configuration data.*/
    DWORD               ciEtherSound1;    /**< board dependent Ethersound configuration data.*/
    DWORD               ciUnused0;    
    DWORD               ciUnused1;
    BYTE                ciDriverId;
    BYTE                ciUnused2[3];
    BYTE                ciPhysicalOutFeature2[MAX_STEREO_OUTAUDIO_BOARD];
    WORD                ciIrqNumber;
    WORD                ciLineConnections;
    DWORD               ciBufferSize;
    BYTE                ciExtendedBoardType;
    BYTE                ciMiscFeatures2;
    BYTE                ciMACAddress[6];
    BYTE                ciUnused3[4];
    BYTE                ciPhysicalInFeature2[MAX_STEREO_INAUDIO_BOARD];
    BYTE                ciExtraPhysicalInFeature[MAX_STEREO_INAUDIO_BOARD];
    BYTE                ciPhysicalOutFeature[((MAX_STEREO_OUTAUDIO_BOARD+3)/4)*4];
    BYTE                ciPhysicalInFeature[((MAX_STEREO_INAUDIO_BOARD+3)/4)*4];
} CARD_FEATURES_INFO, *PCARD_FEATURES_INFO;

typedef struct _SYSTEM_FEATURES_INFO
{
    BYTE                siReleaseNumber;
    BYTE                siVersionNumber;
    BYTE                siVersionType;
    BYTE                siMemoryType;//Other than vpcx
    WORD                siAllocatedBufferNumber;//Min of all API
    WORD                siAvailableBufferNumber;//Min of all API
    DWORD               siUnused1;
    DWORD               siUnused2;
    DWORD               siBufferSize;//Min of all API other than vpcx
    WORD                siPresentBoardMask;
    CHAR                siPatchLevel;
    BYTE                siAvailableInfo;
    WORD                siVPcxAvailableBufferNumber;
    WORD                siVPcxPresentBoardMask;
    WORD                siPresentBoard;
    WORD                siMissingBoard;
    DWORD               siUnused3;
    DWORD               siUnused4;
} SYSTEM_FEATURES_INFO, *PSYSTEM_FEATURES_INFO;

#if defined(WIN32) && (defined(_UNICODE) || defined(UNICODE))
#define _APP_INFO   _APP_INFO_W
#define APP_INFO    APP_INFO_W
#define PAPP_INFO   PAPP_INFO_W
#else
#define _APP_INFO   _APP_INFO_A
#define APP_INFO    APP_INFO_A
#define PAPP_INFO   PAPP_INFO_A
#endif
#ifdef WIN32
typedef struct _APP_INFO_W
{
    PCX_HANDLE          aiProcess;
    WCHAR               aiAppName[((SIZE_MAX_APP_NAME+1+3)/4)*4];
    DWORD               aiUnused;
    HANDLE              aiWinHandle;
    DWORD               aiWinMessage;
    BYTE                aiWhichAPI;          
    BYTE                aiUnused2;
    WORD                aiUnused3;
    DWORD               aiUnused4;
    DWORD               aiAppInfoEx;
} APP_INFO_W, *PAPP_INFO_W;
#endif
typedef struct _APP_INFO_A
{
    PCX_HANDLE          aiProcess;
    CHAR                aiAppName[((SIZE_MAX_APP_NAME+1+3)/4)*4];
    DWORD               aiUnused;
    HANDLE              aiWinHandle;
    DWORD               aiWinMessage;
    BYTE                aiWhichAPI;          
    BYTE                aiUnused2;
    WORD                aiUnused3;
    DWORD               aiUnused4;
    DWORD               aiAppInfoEx;
} APP_INFO_A, *PAPP_INFO_A;

typedef struct _PIPE_INFO
{
  #define piPipeHandle  piPipeMask
    DWORD               piPipeMask;         //A pipe handle in the new API
    BYTE                piStreamNumber;
    BYTE                piAudioInOutNumber;
    WORD                piPipeAttributes;
    DWORD               piAudioMask;        //PCX drivers return the mask of assigned audios
    DWORD               piUnused1;
    DWORD               piUnused2;
} PIPE_INFO, *PPIPE_INFO;

typedef struct _DSP_TO_LOAD_INFO
{
    WORD                dtlCardMask;
    BYTE                dtlDspMask;
    DWORD               dtlDspFeatures;
    DWORD               dtlPlayFormats;
    DWORD               dtlRecordFormats;
    DWORD               dtlPlayEffects;
    DWORD               dtlRecordEffects;
    BYTE                dtlLoadPolicy;
    BYTE                dtlUnused1[3];
    DWORD               dtlBoardList;//For New API only
    DWORD               dtlUnused3;
} DSP_TO_LOAD_INFO, *PDSP_TO_LOAD_INFO;

typedef struct _DSP_RESOURCES_INFO
{
	FLOAT			driDspUsage;
	WORD			driMemAvailable;		/**< size of available memory.*/
	WORD			driMemSize;				/**< total memory size.*/
	DWORD			driUnused[4];		
} DSP_RESOURCES_INFO, *PDSP_RESOURCES_INFO;

typedef struct _PIPE_DECL_INFO
{
    BYTE                pdStreamNumber;
    BYTE                pdUnused1;
    WORD                pdAudioNumber;		/**< used to be a byte; an unused byte is absorbed to turn into word.*/
    WORD                pdPipeAttributes;
    WORD                pdPipeManagement;
    DWORD               pdBufferSize;
    WORD                pdVPcxInternalBuffering;
    DWORD               pdChannelMask;		/**< like in WAVE_FORMAT_EXTENSIBLE,  valid if pdAudioNumber == 0.*/
    WORD                pdUnused2;
    DWORD               pdUnused3;
} PIPE_DECL_INFO, *PPIPE_DECL_INFO;

typedef struct _STREAM_DECL_INFO
{
    DWORD               sdFormat;
    DWORD               sdBitrate;
    DWORD               sdMisc;
    DWORD               sdHostFormat;
    DWORD               sdUnused;
} STREAM_DECL_INFO, *PSTREAM_DECL_INFO;

typedef struct _AUDIO_DECL_INFO
{
    BYTE                adBoardNumber;
    BYTE                adDspNumber;
    WORD                adAudioNumber;		/**< used to be a byte; an unused byte is absorbed to turn into word.*/
    WORD                adAudioAttributes;
    WORD                adLogicalBoardNumber;	/**< added for new API.*/
    WORD                adUnused2;
    DWORD               adVirtualDeviceHandle;
    DWORD               adUnused4;
} AUDIO_DECL_INFO, *PAUDIO_DECL_INFO;

/*
*	Audio Information structure filled by the PCXGetAudioFeatures function
*/
typedef struct _AUDIO_FEATURES_INFO
{
	BYTE    afiPhysicalFeatures;	/**< @see CARD_FEATURES_INFO.*/
	BYTE    afiPhysicalFeatures2;	/**< @see CARD_FEATURES_INFO.*/
	BYTE    afiExtraFeatures;	    /**< @see CARD_FEATURES_INFO.*/
	DWORD   afiLevelFeatures;	    /**< gives information upon digital and analog gain and meters controls.*/
	DWORD  	afiReserved[10];		/**< reserved.*/
} AUDIO_FEATURES_INFO, *PAUDIO_FEATURES_INFO;


typedef struct _TIME_INFO
{
    BYTE                tiDelayed;
    BYTE                tiUnused1[3];
    PCX_TIME            tiScheduler;
    PCX_TIME            tiUnused2;
    DWORD               tiUnused3;
    DWORD               tiUnused4;
} TIME_INFO, *PTIME_INFO;

typedef struct _NOTIFY_INFO
{
  #define niOutPipeHandle niOutPipeMask
  #define niInPipeHandle  niInPipeMask
    DWORD               niOutPipeMask;//A pipe handle in the new API
    DWORD               niInPipeMask;//A pipe handle in the new API
    WORD                niCommandCode;
    TIME_INFO           niExecTime;
    DWORD               niCommandParam1;
    DWORD               niCommandParam2;
    DWORD               niUnused1;
    DWORD               niUnused2;
    DWORD               niUnused3;
} NOTIFY_INFO, *PNOTIFY_INFO;

typedef struct _INTERNAL_CLOCK_INFO
{
    DWORD               icClock;
    DWORD               icValidationMask1; // Was icUnused1 before
    DWORD               icUnused2;
    DWORD               icUnused3;
} INTERNAL_CLOCK_INFO, *PINTERNAL_CLOCK_INFO;

typedef struct _SYNCHRO_CARD_CLOCK_INFO
{
    DWORD               scUnused1;
    DWORD               scUnused2;
    DWORD               scUnused3;
    DWORD               scUnused4;
} SYNCHRO_CARD_CLOCK_INFO, *PSYNCHRO_CARD_CLOCK_INFO;

typedef struct _AES3_ON_INTERNAL_CONNECTOR_CLOCK_INFO
{
    DWORD               scUnused1;
    DWORD               scUnused2;
    DWORD               scUnused3;
    DWORD               scUnused4;
}AES3_ON_INTERNAL_CONNECTOR_CLOCK_INFO, *PAES3_ON_INTERNAL_CONNECTOR_CLOCK_INFO;

typedef struct _UER_CLOCK_INFO
{
    DWORD               ucUerInputNumber;  
    DWORD               ucCardNumber;//Logical
  #define ucLogicalBoardNumber ucCardNumber
    DWORD               ucValidationMask1;// Was ucUnused1 before
    DWORD               ucUnused2;
} UER_CLOCK_INFO, *PUER_CLOCK_INFO;

typedef struct _WORD_CLOCK_INFO
{
    DWORD               wcWordClockInputNumber;
    DWORD               wcCardNumber;//Logical
  #define wcLogicalBoardNumber wcCardNumber
    DWORD               wcValidationMask1;// was wcUnused1
    DWORD               wcUnused2;
} WORD_CLOCK_INFO, *PWORD_CLOCK_INFO;

typedef struct _VIDEO_CLOCK_INFO
{
    DWORD               vcVideoClockInputNumber;
    DWORD               vcCardNumber;//Logical
  #define vcLogicalBoardNumber vcCardNumber
    WORD                vcFrequency;   // 32000, 44100, 48000
    WORD                vcVideoFormat; // Video format listed pcxdef_e.h
    DWORD               vcValidationMask1;// was vcUnused1 before
} VIDEO_CLOCK_INFO, *PVIDEO_CLOCK_INFO;

typedef struct _PROGRAMMABLE_CLOCK_INFO
{
    DWORD               pcClock;
    WORD                pcBoardMask;//Logical
  #define pcLogicalBoardNumber pcBoardMask
    WORD                pcUnused2;
    DWORD               pcBoardList;//Was Unused3 before
    DWORD               pcReferenceClock;//Was pcUnused4 before
} PROGRAMMABLE_CLOCK_INFO, *PPROGRAMMABLE_CLOCK_INFO;

typedef struct _COBRANET_CLOCK_INFO
{
    DWORD               ccValidationMask;
    DWORD               ccCardNumber;
    DWORD               ccUnused3;
    DWORD               ccUnused4;
}COBRANET_CLOCK_INFO, *PCOBRANET_CLOCK_INFO;

typedef struct _ETHERSOUND_CLOCK_INFO
{
  DWORD               ecValidationMask;
  DWORD               ecCardNumber;
  DWORD               ecUnused1;      
  DWORD               ecUnused2;
}ETHERSOUND_CLOCK_INFO, *PETHERSOUND_CLOCK_INFO;

typedef struct _EXTERNAL_CLOCK_INFO
{
  DWORD   ecType;
  union _EXTERNAL_CLOCK_TYPE_INFO
  {
    SYNCHRO_CARD_CLOCK_INFO                tSyn;
    WORD_CLOCK_INFO                        tWCl;
    UER_CLOCK_INFO                         tUer;
    VIDEO_CLOCK_INFO                       tVideo;
    COBRANET_CLOCK_INFO                    tCobranet;
    AES3_ON_INTERNAL_CONNECTOR_CLOCK_INFO  tAes3;
    ETHERSOUND_CLOCK_INFO                  tEthersound;
  }   ecInfo;
} EXTERNAL_CLOCK_INFO, *PEXTERNAL_CLOCK_INFO;

typedef struct _CLOCK_INFO
{
    DWORD   ckType;
    BYTE    ckSync;
    WORD    ckMisc;
    BYTE    ckStatusFlags;  // status of SRC : SRC_AVAILABLE, SRC_IN_USE
    DWORD   ckFrequency;
    DWORD   ckAudioClock;
    DWORD   ckUnused[2];
} CLOCK_INFO, *PCLOCK_INFO;

typedef struct _OUT_PIPE_SET_PARAM_INFO
{
    DWORD               opspValidationMask1;
    DWORD               opspValidationMask2;
    BYTE                opspUer;
    BYTE                opspUerExtra;
    BYTE                opspUnused1[2];
    DWORD               opspFrequency;
    BYTE                opspMpeg;
    BYTE                opspBackward;
    WORD                opspUnused2;
    DWORD               opspUnused3[12];
} OUT_PIPE_SET_PARAM_INFO, *POUT_PIPE_SET_PARAM_INFO;

typedef struct _EFFECT_TS_PARAM_INFO
{
    FLOAT               tspSpeedFactor;
    DWORD               tspUnused1[5];
} EFFECT_TS_PARAM_INFO, *PEFFECT_TS_PARAM_INFO;

typedef struct _EFFECT_SC_PARAM_INFO
{
    FLOAT               scpSpeedFactor;
    DWORD               tspUnused1[5];
} EFFECT_SC_PARAM_INFO, *PEFFECT_SC_PARAM_INFO;

typedef struct _EFFECT_CF_PARAM_INFO
{
    DWORD               cfpSrcFrequency;
    DWORD               cfpDestFrequency;
    DWORD               cfpUnused1[4];
} EFFECT_CF_PARAM_INFO, *PEFFECT_CF_PARAM_INFO;

typedef struct _EFFECT_PS_PARAM_INFO
{
    FLOAT               pspPitchFactor;
    DWORD               pspUnused1[5];
} EFFECT_PS_PARAM_INFO, *PEFFECT_PS_PARAM_INFO;

typedef struct _EFFECT_EQ_PARAM_INFO
{
    BYTE    eqpBand;
    BYTE    eqpType;
    DWORD   eqpFrequency;
    FLOAT   eqpGain;
    FLOAT   eqpQFactor;
    BYTE    eqpSlope;
    BYTE    eqpBypass;
    DWORD   eqpUnused1[2];
} EFFECT_EQ_PARAM_INFO, *PEFFECT_EQ_PARAM_INFO;

typedef struct _EFFECT_MX_PARAM_INFO
{
    FLOAT   mxpGain;
    FLOAT   mxpThreshold;
    FLOAT   mxpRelease;
    BYTE    mxpBypass;
    BYTE    mxpUnused1[3];
    DWORD   mxpUnused2[2];

} EFFECT_MX_PARAM_INFO, *PEFFECT_MX_PARAM_INFO;

typedef struct _OUT_PIPE_SET_EFFECT_INFO
{
    PCX_EFFECT_HANDLE   opseIdentifier;
    DWORD               opseMode;
    union _opseEffectParams
    {
        EFFECT_TS_PARAM_INFO    epTS;
        EFFECT_SC_PARAM_INFO    epSC;
        EFFECT_CF_PARAM_INFO    epCF;
        EFFECT_PS_PARAM_INFO    epPS;
        EFFECT_EQ_PARAM_INFO    epEQ;	
        EFFECT_MX_PARAM_INFO    epMX;	
    }                   opseParams;
    WORD                opseOrder;   
    WORD                opseUnused1;   
    DWORD               opseUnused2;
} OUT_PIPE_SET_EFFECT_INFO, *POUT_PIPE_SET_EFFECT_INFO;

typedef struct _EFFECT_CL_PARAM_INFO
{
    FLOAT               clpCompThreshold;
    FLOAT               clpCompRatio;
    FLOAT               clpNoiseThreshold;
    FLOAT               clpOutputGain;
    DWORD               clpUnused1[2];
} EFFECT_CL_PARAM_INFO, *PEFFECT_CL_PARAM_INFO;

/* set (and get) structure for in audio effects (HW and DSP) */
typedef struct _IN_AUDIO_SET_EFFECT_INFO
{
    PCX_EFFECT_HANDLE   iaseIdentifier; 
    DWORD               iaseCommand;    // 0 = EFFECT_CMD_SET 
    union _iaseEffectParams
    {
        EFFECT_CL_PARAM_INFO   epCL;
        EFFECT_EQ_PARAM_INFO   epEQ;
        EFFECT_MX_PARAM_INFO   epMX;
    }                   iaseParams;
    DWORD               iaseUnused[2];
} IN_AUDIO_SET_EFFECT_INFO, *PIN_AUDIO_SET_EFFECT_INFO;

typedef struct _LOOP_AUDIO_INFO
{
  #define laPipeOutHandle laPipeOutMask
    DWORD               laPipeOutMask;//Pipe Handle
    WORD                laPipeAudioOutMask;
    WORD                laUnused1;
  #define laPipeInHandle  laPipeInMask
    DWORD               laPipeInMask;//Pipe Handle
    WORD                laPipeAudioInMask;
    WORD                laUnused2;
    DWORD               laUnused3;
    DWORD               laUnused4;
} LOOP_AUDIO_INFO, *PLOOP_AUDIO_INFO;

typedef struct _CHANGE_MONITORING_INFO
{
  #define cmPipeOutHandle cmPipeOutMask
    DWORD               cmPipeOutMask;//Pipe handle
    WORD                cmPipeAudioOutMask;
    WORD                cmUnused1;
  #define cmPipeInHandle  cmPipeInMask
    DWORD               cmPipeInMask;//Pipe handle
    WORD                cmPipeAudioInMask;
    WORD                cmUnused2;
    DWORD               cmUnused3;
    DWORD               cmUnused4;
} CHANGE_MONITORING_INFO, *PCHANGE_MONITORING_INFO;


typedef struct _CLOCK_FEATURES_INFO
{
    DWORD             cfiFixedClockMax;
    DWORD             cfiReserved[10];
} CLOCK_FEATURES_INFO, * PCLOCK_FEATURES_INFO;


typedef struct _IN_PIPE_SET_PARAM_INFO
{
    DWORD               ipspValidationMask1;
    DWORD               ipspValidationMask2;
    BYTE                ipspADSelect;
    BYTE                ipspADProperties;
    BYTE                ipspUnused1[2];
    DWORD               ipspUnused2[16];
} IN_PIPE_SET_PARAM_INFO, *PIN_PIPE_SET_PARAM_INFO;

typedef struct _OUT_AUDIO_SET_LEVEL_INFO
{
    DWORD               oaslValidationMask1;
    DWORD               oaslValidationMask2;
    FLOAT               oaslAnalogLevel;
    FLOAT               oaslDigitalLevel;
    FLOAT               oaslMonitoringLevel;
    FLOAT               oaslUnused1[5];
    WORD                oaslMute;
    WORD                oaslUnused2;
    WORD                oaslMonitoringMute1;
    WORD                oaslUnused3;
    WORD                oaslMonitoringMute2;
    WORD                oaslUnused4;
    DWORD               oaslUnused5[4];
} OUT_AUDIO_SET_LEVEL_INFO, *POUT_AUDIO_SET_LEVEL_INFO;

typedef struct _IN_AUDIO_SET_LEVEL_INFO
{
    DWORD               iaslValidationMask1;
    DWORD               iaslValidationMask2;
    FLOAT               iaslAnalogLevel;
    FLOAT               iaslDigitalLevel;
    FLOAT               iaslMicroLevel;
    FLOAT               iaslUnused1[4]; 
    WORD                iaslAnalogMute;
    WORD                iaslMicroMute;
    DWORD               iaslUnused2[3];
} IN_AUDIO_SET_LEVEL_INFO, *PIN_AUDIO_SET_LEVEL_INFO;

typedef struct _IN_AUDIO_SET_PARAM_INFO
{
    DWORD               iaspValidationMask;
    WORD                iaspMic48V;
    WORD                iaspUnused1;
    DWORD               iaspUnused2[2];
} IN_AUDIO_SET_PARAM_INFO, *PIN_AUDIO_SET_PARAM_INFO;

// Reserved do not use
typedef struct _LIST_MPEG_HOMOGENEOUS_INFO
{
    DWORD               dwBitRate;
    DWORD               dwFrameOffset;
    DWORD               dwFilePtrOffset;
    struct _LIST_MPEG_HOMOGENEOUS_INFO *pNext;
} LIST_MPEG_HOMOGENEOUS_INFO, *PLIST_MPEG_HOMOGENEOUS_INFO;

// Reserved do not use
typedef struct _FILE_MPEG_VAR_BITRATE
{
    CHAR                szFileName[_MAX_PATH];
    DWORD               dwSoundDataSize;
    DWORD               dwSoundDataOffset;
    DWORD               dwTotalFrame;
    DWORD               dwTotalTime;
    DWORD               dwFrequency;
    DWORD               dwSamplesPerFrame;
    BOOL                bHomogeneous;
    PLIST_MPEG_HOMOGENEOUS_INFO pListMPEGInfo;
 } FILE_MPEG_VAR_BITRATE, *PFILE_MPEG_VAR_BITRATE;

typedef struct _SOUND_FORMAT_INFO
{
    PCX_CODEC_HANDLE    sfHandle;
    BOOLEAN             sfHasHeader;
    BOOLEAN             sfHasSuffix;
    DWORD               sfFrequency;
    DWORD               sfBitRate;
    DWORD               sfChannels;
    DWORD               sfSamplesPerFrame;
    DWORD               sfBytesPerFrame;
    DWORD               sfBytesPerSample;
    BYTE                sfFrequencyQuality;
    BYTE                sfFrequencyQualityDelta;
    BYTE                sfHostUsed;
    BYTE                sfUnused1;
    DWORD               sfChannelMask;  // like in WAVE_FORMAT_EXTENSIBLE, valid if sfChannels == 0
    WORD                sfUnused[6];
    DWORD               sfUser[4];
    DWORD               sfSamplesPerChannel;	/**< set this to the card's granularity (non-zero) to support ASIO hardware acceleration.*/
    union
    {
        struct _SF_LINEAR_FORMAT_INFO
        {
            WORD        sffLinearEndianNess;
            WORD        sffLinearBits;
            BOOLEAN     sffIsSigned;
            BOOLEAN     sffIsFloat;
        } sffLinear ;

#define sfLinearEndianNess      sfFormatInfo.sffLinear.sffLinearEndianNess
#define sfLinearNbBits          sfFormatInfo.sffLinear.sffLinearBits
#define sfLinearIsSigned        sfFormatInfo.sffLinear.sffIsSigned
#define sfLinearIsFloat         sfFormatInfo.sffLinear.sffIsFloat

        struct _SF_MPEG_FORMAT_INFO
        {
            WORD        sffMpegLayer;
            WORD        sffMpegMode;
            WORD        sffMpegModeExtension;
            WORD        sffMpegPreEmphasis;
            BOOLEAN     sffMpegHasPaddingBit;
            BOOLEAN     sffMpegHasCrc;
            BOOLEAN     sffMpegHasExtension;
            BOOLEAN     sffMpegIsOriginal;
            BOOLEAN     sffMpegHasCopyright;
            PFILE_MPEG_VAR_BITRATE sffMpegExtraInfo;    // Reserved do not use
            DWORD       sffMpegCheckNonHomogeneousFile; // Reserved do not use
            DWORD       sffReserved2;                   // Do not removed or structure size will change
        } sffMpeg ;

#define sfMpegLayer                     sfFormatInfo.sffMpeg.sffMpegLayer
#define sfMpegMode                      sfFormatInfo.sffMpeg.sffMpegMode
#define sfMpegModeExtension             sfFormatInfo.sffMpeg.sffMpegModeExtension
#define sfMpegHasPaddingBit             sfFormatInfo.sffMpeg.sffMpegHasPaddingBit
#define sfMpegPreEmphasis               sfFormatInfo.sffMpeg.sffMpegPreEmphasis
#define sfMpegHasCrc                    sfFormatInfo.sffMpeg.sffMpegHasCrc
#define sfMpegHasExtension              sfFormatInfo.sffMpeg.sffMpegHasExtension
#define sfMpegIsOriginal                sfFormatInfo.sffMpeg.sffMpegIsOriginal
#define sfMpegHasCopyright              sfFormatInfo.sffMpeg.sffMpegHasCopyright
#define sfMpegExtraInfo                 sfFormatInfo.sffMpeg.sffMpegExtraInfo
#define sfMpegCheckNonHomogeneousFile   sfFormatInfo.sffMpeg.sffMpegCheckNonHomogeneousFile

        struct _SF_GSM_FORMAT_INFO
        {
            WORD        sffGsmEndianNess;
            WORD        sffGsmUnused1;
            BOOLEAN     sffGsmIsMagic;
            DWORD       sffGsmUnused2;
            DWORD       sffGsmUnused3;
        } sffGsm ;

#define sfGsmEndianNess         sfFormatInfo.sffGsm.sffGsmEndianNess
#define sfGsmIsMagic            sfFormatInfo.sffGsm.sffGsmIsMagic

        struct _SF_AAC_FORMAT_INFO
        {

            WORD        sffAacChannelSyntaticElement;
            WORD        sffAacChannelNumber;
            WORD        sffAasUnused1;
            BOOLEAN     sffAacHasCopyright;
            BOOLEAN     sffAacHasOriginalFlag;
            BOOLEAN     sffAacUnused2;
            DWORD       sffAacUnused3;
        } sffAac ;

#define sfAacChannelSyntaticElement sfFormatInfo.sffAac.sffAacChannelSyntaticElement
#define sfAacChannelNumber			sfFormatInfo.sffAac.sffAacChannelNumber
#define sfAacHasCopyright			sfFormatInfo.sffAac.sffAacHasCopyright
#define sfAacHasOriginalFlag		sfFormatInfo.sffAac.sffAacHasOriginalFlag

		struct _SF_WMA_FORMAT_INFO
        {
            
            WORD        sffWmaUnused1;
            WORD        sffWmaUnused2;
            WORD        sffWmaUnused3;
            BOOLEAN     sffWmaUnused4;
            BOOLEAN     sffWmaUnused5;
            BOOLEAN     sffWmaUnused6;
        } sffWma ;

    } sfFormatInfo;

} SOUND_FORMAT_INFO, *PSOUND_FORMAT_INFO;

typedef struct _OUT_STREAM_SET_LEVEL_INFO
{
    DWORD               osslValidationMask1;
    DWORD               osslValidationMask2;
    FLOAT               osslLeftChannelToOut1DigitalLevel;
    FLOAT               osslLeftChannelToOut2DigitalLevel;
    FLOAT               osslRightChannelToOut1DigitalLevel;
    FLOAT               osslRightChannelToOut2DigitalLevel;
    FLOAT               osslDigitalLevel1;
    FLOAT               osslDigitalLevel2;
    FLOAT               osslUnused1[5];
    WORD                osslMute1;
    WORD                osslUnused2;
    WORD                osslMute2;
    WORD                osslUnused3;
    DWORD               osslUnused4[4];
} OUT_STREAM_SET_LEVEL_INFO, *POUT_STREAM_SET_LEVEL_INFO;

typedef struct _OUT_STREAM_SET_LCURVE_INFO
{
    DWORD               osnlValidationMask1;
    DWORD               osnlValidationMask2;
    WORD                osnlNumberOfValues;
    WORD                osnlStep;
    LPFLOAT             osnlLevelValues;
    DWORD               osnlUnused1[4];
} OUT_STREAM_SET_LCURVE_INFO, *POUT_STREAM_SET_LCURVE_INFO;

typedef struct _OUT_STREAM_EPARAM_INFO
{
    DWORD               osseValidationMask1;
    WORD                osseSyncLevelSettings;
    WORD                osseUnused1;
    DWORD               osseUnused[5];
} OUT_STREAM_EPARAM_INFO, *POUT_STREAM_EPARAM_INFO;

typedef struct _VU_METER_INFO
{
    FLOAT               vmVuMeter;
    FLOAT               vmPeakMeter;
    FLOAT               vmUnused1;
    FLOAT               vmUnused2;
    BYTE                vmSaturation;
    BYTE                vmUnused3[3];
    DWORD               vmUnused4;
    DWORD               vmUnused5[4];
} VU_METER_INFO, *PVU_METER_INFO;

typedef struct _UER_INFO
{
    DWORD               uiUnused1;
    BYTE                uiData;
    BYTE                uiUnused2;
    BYTE                uiMode;
    BYTE                uiUnused3;
	DWORD               uiFrequency;
	DWORD               uiExtra;
	BYTE                uiExtraValid;
    BYTE                uiUnused4[3];
    DWORD               uiUnused5[2];
} UER_INFO, *PUER_INFO;

typedef struct _OUT_AUDIO_GET_LEVEL_INFO
{
    FLOAT               oaglAnalogLevel;
    FLOAT               oaglDigitalLevel;
    FLOAT               oaglMonitoringLevel;
    FLOAT               oaglUnused1[5];
    WORD                oaglMute;
    WORD                oaglUnused2;
    WORD                oaglMonitoringMute1;
    WORD                oaglUnused3;
    WORD                oaglMonitoringMute2;
    WORD                oaglUnused4;
    DWORD               oaglUnused5;
    DWORD               oaglUnused6[4];
} OUT_AUDIO_GET_LEVEL_INFO, *POUT_AUDIO_GET_LEVEL_INFO;

typedef struct _IN_AUDIO_GET_LEVEL_INFO
{
    FLOAT               iaglAnalogLevel;
    FLOAT               iaglDigitalLevel;
    FLOAT               iaglMicroLevel;
    FLOAT               iaglUnused1[4];
    WORD                iaglAnalogMute;
    WORD                iaglMicroMute;
    DWORD               iaglUnused2;
    DWORD               iaglUnused3[4];
} IN_AUDIO_GET_LEVEL_INFO, *PIN_AUDIO_GET_LEVEL_INFO;

typedef struct _STREAM_STATE_INFO
{
    BYTE                ssStart;
    BYTE                ssUnused1[3];
    PCX_TIME            ssTime;
    DWORD               ssUnused2;
    DWORD               ssUnused3[3];
} STREAM_STATE_INFO, *PSTREAM_STATE_INFO;

typedef union _BUFFER_ADDRESS_INFO
{
    // Not supported
    //
    struct _DosConv
    {
        DWORD           aiAddress;
        DWORD           aiUnused1;
        DWORD           aiUnused2;
        DWORD           aiUnused3;
        DWORD           aiUnused4;
    } DosConv ;

    // Not supported
    //
    struct _DosXms
    {
        DWORD           aiLinearAddress;
        DWORD           aiXmsHandle;
        DWORD           aiXmsOffset;
        DWORD           aiUnused1;
        DWORD           aiUnused2;
    } DosXms ;

    // Available for use under WindowsNT and Windows95
    //
    struct _LinearMem
    {
        DWORD           aiLinearAddress;
        DWORD           aiReserved1;
        DWORD           aiUnused2;
        DWORD           aiUnused3;
        DWORD           aiUnused4;
    } LinearMem ;

} BUFFER_ADDRESS_INFO, *PBUFFER_ADDRESS_INFO;


typedef struct _PLAY_BUFFER_INFO
{
    DWORD               pbMisc;
    WORD                pbBufferNumber;
    WORD                pbUnused1;
    DWORD               pbDataLength;
    BYTE                pbPause;
    BYTE                pbHint;
    WORD                pb9BitsTag; // setting this tag allows to be notified for this buffer
                                    // the tag value can be read later in NOTIFY_INFO.niCommandParam2
    DWORD               pbUnused3[10];
} PLAY_BUFFER_INFO, *PPLAY_BUFFER_INFO;

typedef struct _RECORD_BUFFER_INFO
{
    DWORD               rbMisc;
    WORD                rbBufferNumber;
    WORD                rbUnused1;
    DWORD               rbDataLength;
    WORD                rb9BitsTag; // setting this tag allows to be notified for this buffer
                                    // the tag value can be read later in NOTIFY_INFO.niCommandParam2
    WORD                rbUnused;
    DWORD               rbUnused2[10];
} RECORD_BUFFER_INFO, *PRECORD_BUFFER_INFO;

typedef struct _LEVEL_FEATURE_INFO
{
    BOOLEAN             lfValidity;
    DWORD               lfLevelType;            // LEVEL_FEATURE_*_MASK
    FLOAT               lfMaxLevel;             // in dBu (balanced audio if both
                                                // balanced and unbalanced exist).
    FLOAT               lfFixedLevel;           // in dBu.
    FLOAT               lfMinVariableLevel;     // in dBu.
    FLOAT               lfLevelStep;            // in dBu.
    DWORD               lfReserved[2];
} LEVEL_FEATURE_INFO, * PLEVEL_FEATURE_INFO;

typedef struct _MPEG_EQUAL_SUBBAND_INFO
{
    BOOLEAN             esbValidity;
    DWORD               esbBandNumber;
    DWORD               esbLowerFrequency;    // in Hz
    DWORD               esbUpperFrequency;    // in Hz
    DWORD               esbReserved[2];
} MPEG_EQUAL_SUBBAND_INFO, * PMPEG_EQUAL_SUBBAND_INFO;

typedef struct _OUT_STREAM_EQUAL_INFO
{
    BOOLEAN             seqValidity;
    DWORD               seqBandNumber;
    FLOAT               seqLevel;             // in dB
    DWORD               seqfReserved[2];
} OUT_STREAM_MPEG_EQUAL_INFO, OUT_STREAM_EQUAL_INFO, * POUT_STREAM_MPEG_EQUAL_INFO, * POUT_STREAM_EQUAL_INFO;

#ifdef WIN32
typedef struct _IN_PIPE_SET_EXTERNAL_CODER_INFO
{
    BYTE                ipsecAction;
    CLSID               ipsecClsid;
    GUID                ipsecRiid;
    WORD                ipsecOrder;
    DWORD               ipsecUnused1;
    DWORD               ipsecUnused2;
    DWORD               ipsecUnused3;
    DWORD               ipsecUnused4;
} IN_PIPE_SET_EXTERNAL_CODER_INFO, *PIN_PIPE_SET_EXTERNAL_CODER_INFO;

typedef struct _OUT_PIPE_SET_EXTERNAL_EFFECT_INFO
{
    BYTE                opseeAction;
    CLSID               opseeClsid;
    GUID                opseeRiid;
    WORD                opseeOrder;
    DWORD               opseeUnused1;
    DWORD               opseeUnused2;
    DWORD               opseeUnused3;
    DWORD               opseeUnused4;
} OUT_PIPE_SET_EXTERNAL_EFFECT_INFO, *POUT_PIPE_SET_EXTERNAL_EFFECT_INFO;

typedef struct _IN_PIPE_SET_EXTERNAL_EFFECT_INFO
{
    BYTE                ipseeAction;
    CLSID               ipseeClsid;
    GUID                ipseeRiid;
    WORD                ipseeOrder;
    DWORD               ipseeUnused1;
    DWORD               ipseeUnused2;
    DWORD               ipseeUnused3;
    DWORD               ipseeUnused4;
} IN_PIPE_SET_EXTERNAL_EFFECT_INFO, *PIN_PIPE_SET_EXTERNAL_EFFECT_INFO;

typedef struct _OUT_STREAM_SET_EXTERNAL_DECODER_INFO
{
    BYTE                ossedAction;
    CLSID               ossedClsid;
    GUID                ossedRiid;
    WORD                ossedOrder;
    DWORD               ossedUnused1;
    DWORD               ossedUnused2;
    DWORD               ossedUnused3;
    DWORD               ossedUnused4;
} OUT_STREAM_SET_EXTERNAL_DECODER_INFO, *POUT_STREAM_SET_EXTERNAL_DECODER_INFO;

typedef struct _OUT_STREAM_SET_EXTERNAL_EFFECT_INFO
{
    BYTE                osseeAction;
    CLSID               osseeClsid;
    GUID                osseeRiid;
    WORD                osseeOrder;
    DWORD               osseeUnused1;
    DWORD               osseeUnused2;
    DWORD               osseeUnused3;
    DWORD               osseeUnused4;
} OUT_STREAM_SET_EXTERNAL_EFFECT_INFO, *POUT_STREAM_SET_EXTERNAL_EFFECT_INFO;
#endif

typedef struct _GPIO_INFO
{
  #define gpioLogicalBoardNumber gpioBoardNum
    WORD                gpioBoardNumber;//logical in the new API
    WORD                gpioUnused0;
    DWORD               gpioNum;
    DWORD               gpioType;
    DWORD               gpioData;
    DWORD               gpioUnused1;
    DWORD               gpioUnused2;
    DWORD               gpioUnused3;
    DWORD               gpioUnused4;
} GPIO_INFO, *PGPIO_INFO;

typedef struct _RS232_INIT_INFO
{
    BYTE                riValidity;
    DWORD               riBaudValue;
    BYTE                riParity;
    BYTE                riDataBitsValue;
    BYTE                riStopBitsValue;
    BYTE                riControlFlow;
    BYTE                riUseEvent;
    WORD                riEndTimeOut;   // in multiple of 55ms
    DWORD               riUnused1;
    DWORD               riUnused2;
    DWORD               riUnused3;
} RS232_INIT_INFO, *PRS232_INIT_INFO;

typedef struct _RS232_OPEN_CLOSE_INFO
{
  #define rocLogicalBoardNumber rocBoardNum
    WORD                rocBoardNumber;
    WORD                rocUnused;
    BYTE                rocComNumber;
    RS232_INIT_INFO     rocInitInfo;
} RS232_OPEN_CLOSE_INFO, *PRS232_OPEN_CLOSE_INFO;

typedef struct _IBL_INFO {
    WORD                iblSamples;     // current IBL value in tics
    WORD                iblMax;         // Max value (must fit in hbuffer = 4096 words)
    WORD                iblMin;         // Min value to prevent too much underruns
    WORD                iblGranularity; // granularity, 1 decoding cycle
} IBL_INFO, * PIBL_INFO;

typedef struct _ES_HW_CFG_INFO {
    DWORD   cfgEtherSound0;
    DWORD   cfgEtherSound1;
    DWORD   cfgReserved[4];
} ES_HW_CFG_INFO, * PES_HW_CFG_INFO;

//}
#pragma pack()


//********************************************************************
// Functions
//
//   - When not specified, the return value is a status :
//         - 0 : No error
//         - 1 : Error or warning
//   - Some functions return status information to the application through
//     a pointer to a table. In certain cases, the application does not
//     know the number of information which are going to be given.
//     To prevent memory overflow problems, the application gives
//     the number of elements available in the table. If it is not
//     sufficient, the function will fill the table and will return
//     a warning.
//  _ The Unused fields in the structure given as input parameters to
//    the API functions must be clear.
//
//********************************************************************

// General functions
// *****************

#ifdef __cplusplus
extern "C" {
#endif

EXTERN  WORD _CDECL_ PCXInitialize(
    IN  PINIT_INFO PmInitInfo );

#if defined(WIN32) && (defined(_UNICODE) || defined(UNICODE))
#define PCXRegister     PCXRegisterW
#else
#define PCXRegister     PCXRegisterA
#endif
#ifdef WIN32
EXTERN  WORD _CDECL_ PCXRegisterW(
    IN  PAPP_DECL_INFO_W    PmAppDeclInfo,
   OUT  PPCX_HANDLE         PmMyProcess );
#endif

EXTERN  WORD _CDECL_ PCXRegisterA(
    IN  PAPP_DECL_INFO_A    PmAppDeclInfo,
   OUT  PPCX_HANDLE         PmMyProcess );

EXTERN  WORD _CDECL_ PCXUnRegister(
    IN  PCX_HANDLE          PmMyProcess );

EXTERN  WORD _CDECL_ PCXGetSystemFeature(
   OUT  PSYSTEM_FEATURES_INFO PmSystemInfo );

EXTERN  WORD _CDECL_ PCXGetHardwareBoardFeature(
    IN  WORD                PmBoardMask,
   OUT  PCARD_FEATURES_INFO PmCardInfo );

EXTERN  WORD _CDECL_ PCXGetSoftwareBoardAbilities(
    IN  WORD                PmBoardMask,
    IN  WORD                PmMaxDspInfo,
   OUT  PDSP_TO_LOAD_INFO   PmDspToLoadArray,
   OUT  LPWORD              PmActualDspInfoNum );

EXTERN  WORD _CDECL_ PCXGetSoftwareHostAbilities(
    IN  WORD                PmBoardMask,
   OUT  PDSP_TO_LOAD_INFO   PmDspToLoadInfo );

EXTERN  WORD _CDECL_ PCXGetSoftwareBoardFeature(
    IN  WORD                PmBoardMask,
    IN  WORD                PmMaxDspInfo,
   OUT  LPWORD              PmDspInfoNumber,
   OUT  PDSP_FEATURES_INFO  PmDspInfo );

// Thread control
// **************
EXTERN  WORD _CDECL_ PCXBoostThisThread( 
    IN  VOID );

EXTERN  WORD _CDECL_ PCXGetBoardExternalClocks(
    IN  WORD                PmBoardMask,
    IN  WORD                PmMaxExternalClockInfo,
   OUT  PCLOCK_INFO         PmExternalClockInfo );

EXTERN  WORD _CDECL_ PCXGetBoardExternalUerClocks(
    IN  WORD                PmBoardMask,
    IN  WORD                PmMaxUerClockInfo,
   OUT  PCLOCK_INFO         PmUerClockInfo );

#if defined(WIN32) && (defined(_UNICODE) || defined(UNICODE))
#define PCXGetPublicApplication PCXGetPublicApplicationW
#else
#define PCXGetPublicApplication PCXGetPublicApplicationA
#endif
#ifdef WIN32
EXTERN  WORD _CDECL_ PCXGetPublicApplicationW(
    IN  WORD                PmMaxAppInfo,
   OUT  LPBYTE              PmAppInfoNumber,
   OUT  PAPP_INFO_W         PmAppInfo );
#endif

EXTERN  WORD _CDECL_ PCXGetPublicApplicationA(
    IN  WORD                PmMaxAppInfo,
   OUT  LPBYTE              PmAppInfoNumber,
   OUT  PAPP_INFO_A         PmAppInfo );

EXTERN  WORD _CDECL_ PCXGetPipe(
    IN  PCX_HANDLE          PmRequestedProcess,
    IN  WORD                PmMaxPipeInfo,
   OUT  LPBYTE              PmOutPipeInfoNumber,
   OUT  LPBYTE              PmInPipeInfoNumber,
   OUT  PPIPE_INFO          PmPipeInfo );

#if defined(WIN32) && (defined(_UNICODE) || defined(UNICODE))
#define PCXDspAlloc     PCXDspAllocW
#else
#define PCXDspAlloc     PCXDspAllocA
#endif
#ifdef WIN32
EXTERN  WORD _CDECL_ PCXDspAllocW(
    IN  PCX_HANDLE          PmMyProcess,
    IN  PDSP_TO_LOAD_INFO   PmDspToLoadInfo,
    IN  WORD                PmMaxSizeDspName,
   OUT  LPWSTR              PmDspFileName );
#endif

EXTERN  WORD _CDECL_ PCXDspAllocA(
    IN  PCX_HANDLE          PmMyProcess,
    IN  PDSP_TO_LOAD_INFO   PmDspToLoadInfo,
    IN  WORD                PmMaxSizeDspName,
   OUT  LPSTR               PmDspFileName );

EXTERN  WORD _CDECL_ PCXDspFree(
    IN  PCX_HANDLE          PmMyProcess,
    IN  PDSP_TO_LOAD_INFO   PmDspToLoadInfo );

EXTERN  WORD _CDECL_ PCXDefinePipe(
    IN  PCX_HANDLE          PmMyProcess,
    IN  PPIPE_DECL_INFO     PmPipe,
    IN  PSTREAM_DECL_INFO   PmStream,
    IN  PAUDIO_DECL_INFO    PmAudio,
 INOUT  LPWORD              PmBufferNumber,
   OUT  LPDWORD             PmPipeInOutMask,
   OUT  PBUFFER_ADDRESS_INFO PmBufferAdressInfo );

EXTERN WORD _CDECL_ PCXDefinePipeEx(
    IN  PCX_HANDLE PmMyProcess,
    IN  PPIPE_DECL_INFO PmPipe,
    IN  PSTREAM_DECL_INFO PmStream,
    IN  PAUDIO_DECL_INFO PmAudio,
    IN  POUT_PIPE_SET_EFFECT_INFO PmEffect,
    INOUT LPWORD PmBufferNumber,
    OUT LPDWORD PmPipeInOutMask,
    OUT PBUFFER_ADDRESS_INFO PmBufferAdressInfo,
    IN  DWORD PmReserved );

EXTERN  WORD _CDECL_ PCXReleasePipe(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask );


#if defined(WIN32) && (defined(_UNICODE) || defined(UNICODE))
#define PCXGetOwnerApplication  PCXGetOwnerApplicationW
#else
#define PCXGetOwnerApplication  PCXGetOwnerApplicationA
#endif
#ifdef WIN32
EXTERN  WORD _CDECL_ PCXGetOwnerApplicationW(
    IN  PAUDIO_DECL_INFO    PmAudio,
   OUT  PAPP_INFO_W         PmAppInfo );
#endif

EXTERN  WORD _CDECL_ PCXGetOwnerApplicationA(
    IN  PAUDIO_DECL_INFO    PmAudio,
   OUT  PAPP_INFO_A         PmAppInfo );

EXTERN  WORD _CDECL_ PCXGetDspCrashError(
    IN  WORD                PmBoardNum,
    IN  WORD                PmDspNum,
   OUT  LPWORD              PmPtrDspFatalError );

EXTERN  WORD _CDECL_ PCXGetDspResources(
   IN   WORD                PmBoardMask,
   OUT  PDSP_RESOURCES_INFO PmDspResourcesInfo );

// Function to get back a description string for a board type
//
// This function returns:
//      - SUCCESS if the description string has been retrieved
// successfully
//      - an error code otherwise
// -------------------------------------------------------------
#if defined(WIN32) && (defined(_UNICODE) || defined(UNICODE))
#define PCXBoardNameString  PCXBoardNameStringW
#else
#define PCXBoardNameString  PCXBoardNameStringA  
#endif
#ifdef WIN32
EXTERN  WORD _CDECL_ PCXBoardNameStringW(
    IN  WORD                PmBoardMask,
    IN  WORD                PmBoardNameMaxSize,
 INOUT  LPWSTR              PmBoardNameString );
#endif

EXTERN  WORD _CDECL_ PCXBoardNameStringA(
    IN  WORD                PmBoardMask,
    IN  WORD                PmBoardNameMaxSize,
 INOUT  LPSTR               PmBoardNameString );

// Function to get back a board serial number
//
// This function returns:
//      - SUCCESS if the serial number has been retrieved
// successfully
//      - an error code otherwise
// -------------------------------------------------------------
#if defined(WIN32) && (defined(_UNICODE) || defined(UNICODE))
#define PCXGetSerialNumber  PCXGetSerialNumberW
#else
#define PCXGetSerialNumber  PCXGetSerialNumberA
#endif
#ifdef WIN32
EXTERN  WORD _CDECL_ PCXGetSerialNumberW(
    IN  WORD                PmBoardMask,
    IN  WORD                PmSerialNumberMaxSize,
   OUT  LPWSTR              PmPSerialNumber );
#endif

EXTERN  WORD _CDECL_ PCXGetSerialNumberA(
    IN  WORD                PmBoardMask,
    IN  WORD                PmSerialNumberMaxSize,
   OUT  LPSTR               PmPSerialNumber );

// Function to get back a board OEM information
//
// This function returns:
//      - SUCCESS if the information has been retrieved
// successfully
//      - an error code otherwise
// -------------------------------------------------------------
EXTERN  WORD _CDECL_ PCXGetOEMInformation(
    IN  WORD                PmBoardMask,
    IN  BYTE                PmOEMNumber,
   OUT  LPBYTE              PmPOEMInfo );

// Function to get back a board checksum
//
// This function returns:
//      - SUCCESS if the checksum has been retrieved
// successfully
//      - an error code otherwise
// -------------------------------------------------------------
EXTERN  WORD _CDECL_ PCXGetChecksum(
    IN  WORD                PmBoardMask,
   OUT  LPBYTE              PmPChecksum );

// Function to read a board time-code
//
// This function returns:
//      - SUCCESS if the time-code has been retrieved
// successfully
//      - an error code otherwise
// -------------------------------------------------------------
EXTERN  WORD _CDECL_ PCXGetTimeCode(
    IN  PCX_HANDLE          PmMyProcess,
    IN  WORD                PmBoardMask,
   OUT  LPBOOLEAN           PmPNewTimeCode,
   OUT  LPBOOLEAN           PmPBackward,
   OUT  LPBOOLEAN           PmPWaitingTimeCode,
   OUT  PPCX_TIME           PmPPcxTime,
   OUT  PPCX_TIME_CODE      PmPTimeCode );


// Function to get back the board levels features
//
// This function returns:
//      - SUCCESS if the information has been retrieved
// successfully
//      - an error code otherwise
// -------------------------------------------------------------
EXTERN  WORD _CDECL_ PCXGetBoardLevelsFeatures(
    IN  WORD                 PmBoardMask,
    IN  DWORD                PmLevelTypeMask,
   OUT  PLEVEL_FEATURE_INFO  PmPLevelsFeatures );



// Function to get back the levels features concerning one specific IO
//
// This function returns:
//      - SUCCESS if the information has been retrieved
// successfully
//      - an error code otherwise
// -------------------------------------------------------------
EXTERN  WORD _CDECL_ PCXGetBoardLevelsFeaturesEx(
    IN	PAUDIO_DECL_INFO     PmpAudioInfo,
    IN  DWORD                PmLevelTypeMask,
   OUT  PLEVEL_FEATURE_INFO  PmPLevelsFeatures );

// Function to know which DSP must be loaded to
// manage a specific audio. Note that the result
// is unknown (DspMask=0) for a virtual audio as
// long as the DSP is not loaded
//
// This function returns:
//      - SUCCESS if the information has been retrieved
// successfully
//      - an error code otherwise
// -------------------------------------------------------------
EXTERN  WORD _CDECL_ PCXGetManagingDsp(
    IN  PAUDIO_DECL_INFO    PmAudioInfo,
   OUT  LPBYTE              PmDspMask );

EXTERN  WORD _CDECL_ PCXGetGPIOFeature(
    IN  WORD                PmBoardNum, 
    IN  WORD                PmMaxGPIOInfo,
    OUT PGPIO_INFO          PmGpioInfo,
    OUT LPWORD              PmActualGPIOInfo );

EXTERN  WORD _CDECL_ PCXSetInternalLatency(
	IN	WORD				PmBoardMask,
 INOUT  PIBL_INFO			PmIBLInfoPtr );

EXTERN  WORD _CDECL_ PCXGetInternalLatency(
	IN	WORD				PmBoardMask, 
 INOUT	PIBL_INFO			PmIBLInfoPtr );

EXTERN  WORD _CDECL_ ESHardwareConfSet (
    IN  WORD                PmBoardMask,
    IN  PES_HW_CFG_INFO     PmHardwareCfg );

// PIPE control functions
// **********************

EXTERN  WORD _CDECL_ PCXSetPipeNoSamplingClock(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  PTIME_INFO          PmDelayCondition );

EXTERN  WORD _CDECL_ PCXSetPipeInternalClock(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  PINTERNAL_CLOCK_INFO PmInternalClockInfo );

EXTERN  WORD _CDECL_ PCXSetPipeExternalClock(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  PEXTERNAL_CLOCK_INFO PmExternalClockInfo );

EXTERN  WORD _CDECL_ PCXSetPipeProgrammableClock(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  PPROGRAMMABLE_CLOCK_INFO PmProgrammableClockInfo );

EXTERN  WORD _CDECL_ PCXStartPipe(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  WORD                PmStartCondition );

EXTERN  WORD _CDECL_ PCXStartPipeOnTimeCode(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  WORD                PmBoardMask,
    IN  DWORD               PmSamplesCount,
    IN  BYTE                PmNbOfTimeCode,
    IN  PPCX_TIME_CODE      PmPTimeCode );

EXTERN  WORD _CDECL_ PCXPausePipe(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  WORD                PmPauseCondition );

EXTERN  WORD _CDECL_ PCXStopPipe(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  PTIME_INFO          PmDelayCondition,
   OUT  PPCX_TIME           PmSampleNumber );

EXTERN  WORD _CDECL_ PCXSetOutPipeParameter(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  POUT_PIPE_SET_PARAM_INFO PmPipeOutParamInfo );

EXTERN  WORD _CDECL_ PCXSetOutPipeEffect(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  POUT_PIPE_SET_EFFECT_INFO PmPipeOutEffectInfo );

EXTERN  WORD _CDECL_ PCXSetInPipeParameter(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeInMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  PIN_PIPE_SET_PARAM_INFO PmPipeInParamInfo );

EXTERN  WORD _CDECL_ PCXOfflineLoop(
    IN  PCX_HANDLE          PmMyProcess,
    IN  BYTE                PmLoopNumber,
    IN  PLOOP_AUDIO_INFO    PmLoopAudioInfo );

EXTERN  WORD _CDECL_ PCXChangeMonitoringSource(
    IN  PCX_HANDLE          PmMyProcess,
    IN  BYTE                PmChangesNumber,
    IN  PCHANGE_MONITORING_INFO PmChangeMonitoringInfoPtr );

EXTERN  WORD _CDECL_ PCXNotifyPipeTime(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmOutPipeMask,
    IN  DWORD               PmInPipeMask,
    IN  PTIME_INFO          PmDelayCondition );

EXTERN  WORD _CDECL_ PCXCancelDifferedCommands(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  WORD                PmCommandCode,
    IN  PTIME_INFO          PmDelayType,
    IN  DWORD               PmCommandParam1,
    IN  DWORD               PmCommandParam2 );

// PIPE AUDIO control functions
// ****************************

EXTERN  WORD _CDECL_ PCXSetOutAudioLevel(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  WORD                PmPipeAudioOutMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  POUT_AUDIO_SET_LEVEL_INFO PmSetOutLevelInfo );

EXTERN  WORD _CDECL_ PCXSetInAudioLevel(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeInMask,
    IN  WORD                PmPipeAudioInMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  PIN_AUDIO_SET_LEVEL_INFO PmSetInLevelInfo );

EXTERN  WORD _CDECL_ PCXSetInAudioEffect(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeInMask, 
    IN  WORD                PmPipeAudioInMask, 
    IN  PTIME_INFO          PmPDelayCondition,
    IN  PIN_AUDIO_SET_EFFECT_INFO PmPInAudioSetEffectInfo );

// BOARD AUDIO control functions
// ****************************

EXTERN  WORD _CDECL_ PCXSetOutBoardAudioLevel(
    IN  PCX_HANDLE          PmMyProcess,
    IN  PAUDIO_DECL_INFO    PmOutAudio,
    IN  PTIME_INFO          PmDelayCondition,
    IN  POUT_AUDIO_SET_LEVEL_INFO PmSetOutLevelInfo );

EXTERN  WORD _CDECL_ PCXSetInBoardAudioLevel(
    IN  PCX_HANDLE          PmMyProcess,
    IN  PAUDIO_DECL_INFO    PmInAudio,
    IN  PTIME_INFO          PmDelayCondition,
    IN  PIN_AUDIO_SET_LEVEL_INFO PmSetInLevelInfo );

EXTERN  WORD _CDECL_ PCXSetInBoardAudioEffect(
    IN PCX_HANDLE           PmMyProcess,
    IN PAUDIO_DECL_INFO     PmPAudioDeclInfo,
    IN PTIME_INFO           PmPDelayCondition,
    IN PIN_AUDIO_SET_EFFECT_INFO PmPInAudioSetEffectInfo );

EXTERN  WORD _CDECL_ PCXSetInBoardAudioParameter(
    IN PCX_HANDLE           PmMyProcess,
    IN PAUDIO_DECL_INFO     PmPAudioDeclInfo,
    IN PIN_AUDIO_SET_PARAM_INFO  PmPInAudioSetParamInfo);

// PIPE STREAM control functions
// *****************************

EXTERN  WORD _CDECL_ PCXStartStream(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  DWORD               PmStreamMask,
    IN  PTIME_INFO          PmDelayCondition );

EXTERN  WORD _CDECL_ PCXPauseStream(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  DWORD               PmStreamMask,
    IN  PTIME_INFO          PmDelayCondition );

EXTERN  WORD _CDECL_ PCXStopStream(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  DWORD               PmStreamMask,
    IN  PTIME_INFO          PmDelayCondition );

EXTERN  WORD _CDECL_ PCXSetOutStreamFormat(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmStreamMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  PSOUND_FORMAT_INFO  PmStreamFormatInfo );

EXTERN  WORD _CDECL_ PCXSetOutStreamLevel(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmStreamMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  POUT_STREAM_SET_LEVEL_INFO PmOutStreamLevelInfo );

EXTERN  WORD _CDECL_ PCXSetOutStreamLevelCurve(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmAudioStreamOutMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  POUT_STREAM_SET_LCURVE_INFO PmSetOutStreamLCurveInfo );

EXTERN  WORD _CDECL_ PCXSetOutStreamExtraParameters(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmStreamMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  POUT_STREAM_EPARAM_INFO  PmStreamParamInfo );

EXTERN  WORD _CDECL_ PCXSetInStreamFormat(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeInMask,
    IN  DWORD               PmStreamMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  PSOUND_FORMAT_INFO  PmStreamFormatInfo );

EXTERN  WORD _CDECL_ PCXPurgeStreamCommands(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  DWORD               PmStreamMask );

EXTERN  WORD _CDECL_ PCXNotifyStreamTime(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmOutPipeMask,
    IN  DWORD               PmInPipeMask,
    IN  DWORD               PmStreamMask,
    IN  PTIME_INFO          PmDelayCondition );

EXTERN  WORD _CDECL_ PCXSetOutStreamMpegEqualization(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmStreamMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  DWORD               PmStreamEqualInfoSize,
    IN  POUT_STREAM_MPEG_EQUAL_INFO PmStreamEqualInfo );

EXTERN  WORD _CDECL_ PCXSetOutStreamEqualization(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmStreamMask,
    IN  PTIME_INFO          PmDelayCondition,
    IN  PCX_EFFECT_HANDLE   PmEffectID,
    IN  DWORD               PmStreamEqualInfoSize,
    IN  POUT_STREAM_EQUAL_INFO PmStreamEqualInfo );


// PIPE status functions
// *********************

EXTERN  WORD _CDECL_ PCXGetPipeSampleNumber(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
   OUT  PPCX_TIME           PmSampleNumber );

EXTERN  WORD _CDECL_ PCXGetPipeState(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
   OUT  LPBYTE              PmState );

EXTERN  WORD _CDECL_ PCXGetPipeClock(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
   OUT  PCLOCK_INFO         PmPipeClockInfo );


// PIPE AUDIO status functions
// ***************************


EXTERN  WORD _CDECL_ PCXGetAudioFeatures(    
	IN	PAUDIO_DECL_INFO	 PmPAudioDeclInfo,
 INOUT	PAUDIO_FEATURES_INFO PmPAudioFeaturesInfo);

EXTERN  WORD _CDECL_ PCXGetAudioVuMeter(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  WORD                PmPipeAudioInOutMask,
   OUT  PVU_METER_INFO      PmPipeVuMeterInfo );

EXTERN  WORD _CDECL_ PCXGetAudioUer(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeInMask,
    IN  WORD                PmPipeAudioInMask,
   OUT  PUER_INFO           PmUerInfo );

EXTERN  WORD _CDECL_ PCXGetOutAudioLevel(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  WORD                PmPipeAudioOutMask,
   OUT  POUT_AUDIO_GET_LEVEL_INFO PmGetOutLevelInfo );

EXTERN  WORD _CDECL_ PCXGetInAudioLevel(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeInMask,
    IN  WORD                PmPipeAudioInMask,
   OUT  PIN_AUDIO_GET_LEVEL_INFO PmGetInLevelInfo );

// BOARD AUDIO status functions
// ***************************

EXTERN  WORD _CDECL_ PCXGetAudioAES3ChannelStatusByte(
    IN  PAUDIO_DECL_INFO    PmAudio,
    IN  BYTE                PmByteID,
   OUT  PBYTE               PmValidity,
   OUT  PBYTE               PmByteValue );

EXTERN  WORD _CDECL_ PCXGetBoardAudioVuMeter(
    IN  PCX_HANDLE          PmMyProcess,
    IN  PAUDIO_DECL_INFO    PmAudio,
   OUT  PVU_METER_INFO      PmVuMeterInfo );

EXTERN  WORD _CDECL_ PCXGetBoardClockFeatures(
    IN WORD                 PmBoardType,
    IN PCLOCK_FEATURES_INFO PmClockFeaturesInfo );

EXTERN  WORD _CDECL_ PCXGetBoardAudioUer(
    IN  PCX_HANDLE          PmMyProcess,
    IN  PAUDIO_DECL_INFO    PmAudio,
   OUT  PUER_INFO           PmUerInfo );

EXTERN  WORD _CDECL_ PCXGetOutBoardAudioLevel(
    IN  PCX_HANDLE          PmMyProcess,
    IN  PAUDIO_DECL_INFO    PmAudio,
   OUT  POUT_AUDIO_GET_LEVEL_INFO PmGetOutLevelInfo );

EXTERN  WORD _CDECL_ PCXGetInBoardAudioLevel(
    IN  PCX_HANDLE          PmMyProcess,
    IN  PAUDIO_DECL_INFO    PmAudio,
   OUT  PIN_AUDIO_GET_LEVEL_INFO PmGetInLevelInfo );

// PIPE STREAM status functions
// ****************************

EXTERN  WORD _CDECL_ PCXGetStreamAudioVuMeter(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmStreamMask,
    IN  WORD                PmPipeAudioOutMask,
   OUT  PVU_METER_INFO      PmPipeVuMeterInfo );

EXTERN  WORD _CDECL_ PCXGetStreamState(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  DWORD               PmStreamMask,
   OUT  PSTREAM_STATE_INFO  PmStreamStateInfo );

EXTERN  WORD _CDECL_ PCXGetStreamSampleNumber(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  DWORD               PmStreamMask,
   OUT  PPCX_TIME           PmSampleNumber );

EXTERN  WORD _CDECL_ PCXGetStreamByteNumber(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  DWORD               PmStreamMask,
   OUT  PPCX_TIME           PmByteNumber );

EXTERN  WORD _CDECL_ PCXGetStreamSamplePosition(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  DWORD               PmStreamMask,
   OUT  PPCX_TIME           PmSamplePosition );

EXTERN  WORD _CDECL_ PCXGetOutStreamLevel(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmStreamMask,
   OUT  POUT_STREAM_SET_LEVEL_INFO PmOutStreamLevelInfo );

EXTERN  WORD _CDECL_ PCXGetOutStreamMpegEqualization(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmStreamMask,
    IN  DWORD               PmStreamEqualInfoSize,
    OUT PMPEG_EQUAL_SUBBAND_INFO    PmSubbandsInfo,
    OUT POUT_STREAM_MPEG_EQUAL_INFO PmStreamEqualInfo );

EXTERN  WORD _CDECL_ PCXGetOutStreamEqualization(
    IN  PCX_HANDLE                  PmMyProcess,
    IN  DWORD                       PmPipeOutMask,
    IN  DWORD                       PmStreamMask,
	IN  PCX_EFFECT_HANDLE			PmEffectID,
    IN  DWORD                       PmStreamEqualInfoSize,
    OUT PMPEG_EQUAL_SUBBAND_INFO    PmSubbandsInfo,
    OUT POUT_STREAM_EQUAL_INFO		PmStreamEqualInfo );

EXTERN  WORD _CDECL_ PCXGetStreamInternalBufferSize(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  DWORD               PmStreamMask,
 INOUT  LPDWORD             PmPtrNbArrayEntries,
   OUT  LPDWORD             PmBufferLatencyArray );

// PLAY-RECORD functions
// *********************

// Asynchronous functions to give a buffer to the driver
// -----------------------------------------------------
// If these functions return an error, the buffer will not be
// managed by the driver.

EXTERN  WORD _CDECL_ PCXPlayStream(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmStreamMask,
    IN  PPLAY_BUFFER_INFO   PmPlayBufferInfo,
    IN  HANDLE              PmEvent );

EXTERN  WORD _CDECL_ PCXRecordStream(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeInMask,
    IN  DWORD               PmStreamMask,
    IN  PRECORD_BUFFER_INFO PmRecordBufferInfo,
    IN  HANDLE              PmEvent );

EXTERN  WORD _CDECL_ PCXCancelStreamBuffers(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmPipeInMask,
    IN  DWORD               PmStreamMask,
    IN  WORD                PmBufferNumber,
   OUT  LPWORD              PmCancelledNumber );

EXTERN  WORD _CDECL_ PCXCancelPauseAtBufferEnd(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  DWORD               PmStreamMask,
    IN  WORD                PmBufferNumber,
    IN  PTIME_INFO          PmDelayType );

// -------------------------------------------------------------------
EXTERN  WORD _CDECL_ PCXWaitPipePlayEnd(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  HANDLE              PmEvent );

// Asynchronous function to ask the driver to tell when a conversion
// of a specified record pipe is finished.
// -------------------------------------------------------------------
EXTERN  WORD _CDECL_ PCXWaitPipeRecordEnd(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeInMask,
    IN  HANDLE              PmEvent );

// Functions to know whether a buffer is empty (play) or full (record).
// These functions returns :
//           1 : This buffer is available for the application.
//           0 : The parameters (PmMyProcess, PmPipeOutMask, PmBufferNumber)
//               does not correspond to a buffer or it corresponds and the
//               buffer is managed by the driver.
// -------------------------------------------------------------------------

EXTERN  BOOLEAN _CDECL_ PCXBufferEmpty(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeOutMask,
    IN  WORD                PmBufferNumber );

EXTERN  BOOLEAN _CDECL_ PCXBufferFull(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmPipeInMask,
    IN  WORD                PmBufferNumber,
   OUT  LPDWORD             PmDataLength );

// Functions to know whether a play of a pipe is finished.
//
// This function returns :
//           1 : This pipe exists and there is no PCXWaitPipePlayEnd running.
//               If no PCXWaitPipePlayEnd was called on this pipe since the
//               creation or the last stop, returns 1.
//           0 : The couple (pmMyProcess, pmOutPipeMask) does not correspond
//               to a pipe or it corresponds and a PCXWaitPipePlayEnd was
//               called by the application and the play is not finished.
// -------------------------------------------------------------------------

EXTERN  BOOLEAN _CDECL_ PCXPlayFinished(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmOutPipeMask );

// Functions to know whether a conversion (off-line record)
// of a pipe is finished.
//
// This function returns :
//           1 : This pipe exists and there is no PCXWaitPipeRecordEnd running.
//               If no PCXWaitPipeRecordEnd was called on this pipe since the
//               creation or the last stop, returns 1.
//           0 : The couple (pmMyProcess, pmInPipeMask) does not correspond
//               to a pipe or it corresponds and a PCXWaitPipeRecordEnd was
//               called by the application and the conversion is not finished.
// -------------------------------------------------------------------------

EXTERN  BOOLEAN _CDECL_ PCXRecordFinished(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmInPipeMask );

// Asynchronous function to ask the driver to tell when a
// command differed with a notification request has been
// actually executed
// --------------------------------------------------------
EXTERN  WORD _CDECL_ PCXWaitForNotification(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmInPipeMask,
    IN  DWORD               PmOutPipeMask,
    IN  HANDLE              PmEvent );

// Function to retrieve a notified differed command that
// PCXWaitForNotification has signalled for the specified pipe
//
// This function returns :
//
//           WA_NO_MORE_DATA: The pipe exists and there is a
//               PCXWaitForNotification running and no differed command
//               has been notified yet, or there is no PCXWaitForNotification
//               running and all notifications have been retrieved.
//               The NOTIFY_INFO structure is not updated.
//
//           SUCCESS : The couple (pmMyProcess, pmIn/OutPipeMask) does
//               correspond and at least one command has been notified.
//               The earliest unread notification since last pipe stop is
//               returned in the NOTIFY_INFO structure.
// -------------------------------------------------------------------------
EXTERN  WORD _CDECL_ PCXGetNotification(
    IN  PCX_HANDLE          PmMyProcess,
    IN  DWORD               PmInPipeMask,
    IN  DWORD               PmOutPipeMask,
   OUT  PNOTIFY_INFO        PmNotification );

// Get Error functions
// *******************

// Asynchronous function to ask the driver to tell when an error occurs
// --------------------------------------------------------------------

EXTERN  WORD _CDECL_ PCXWaitForError(
    IN  PCX_HANDLE   PmMyProcess,
    IN  HANDLE       PmEvent );

// Functions to know whether a buffer is an error has occured.
// This function returns :
//           0 : The parameter PmMyProcess does not correspond to a
//               PCXWaitForError or it corresponds and there is no error.
//           else : The error.
// -------------------------------------------------------------------------

EXTERN  WORD _CDECL_ PCXGetError(
    IN  PCX_HANDLE   PmMyProcess,
   OUT  LPDWORD      PmpInPipeMask,
   OUT  LPDWORD      PmpOutPipeMask,
   OUT  LPDWORD      PmStreamMask );

// Functions to SET/GET or REMOVE an input Audio Effect
// --------------------------------------------------------
EXTERN WORD _CDECL_ PCXInAudioEffect(   
     IN  PCX_HANDLE          PmMyProcess,
     IN  DWORD               PmPipeInMask, 
     IN  WORD                PmPipeAudioInMask, 
     IN  PIN_AUDIO_SET_EFFECT_INFO   PmPInAudioEffectInfo );

// Same as PCXWaitForPCCARDEvent
// --------------------------------------------------------
EXTERN  WORD _CDECL_ PCXWaitForBoardEvent(
    IN  PCX_HANDLE          PmMyProcess,
    IN  HANDLE              PmEvent );

// Same as PCXIsPCCARDEventSet
// -------------------------------------------------------------------------
EXTERN  BOOLEAN _CDECL_ PCXIsBoardEventSet(
    IN  PCX_HANDLE          PmMyProcess,
   OUT  LPWORD              PmlpBoardMask,
   OUT  LPDWORD             PmlpBoardEvent );

// Function to get back a description string for an error code
// This function returns:
//      - a pointer to a description string if the error is
//       a knowned and documented PCX error
//      - a pointer to an empty string "" if the error code
//       is unknowned
//      - 0 if the error code is not a valid PCX error code
// -------------------------------------------------------------
#if defined(WIN32) && (defined(_UNICODE) || defined(UNICODE))
#define PCXErrorString   PCXErrorStringW
#else
#define PCXErrorString   PCXErrorStringA  
#endif
#ifdef WIN32
EXTERN  LPWSTR _CDECL_ PCXErrorStringW(
    IN  WORD                PmError );
#endif

EXTERN  LPSTR _CDECL_ PCXErrorStringA(
    IN  WORD                PmError );

// GPIO Functions
// **************

EXTERN  WORD _CDECL_ PCXOpenGPIO(
    IN  PCX_HANDLE      PmMyProcess,
    IN  PGPIO_INFO      PmTabGpioInfo,
    IN  DWORD           PmTabSize,
    IN  PVOID           PmUnused );

EXTERN  WORD _CDECL_ PCXCloseGPIO(
    IN  PCX_HANDLE      PmMyProcess,
    IN  PGPIO_INFO      PmTabGpioInfo,
    IN  DWORD           PmTabSize,
    IN  PVOID           PmUnused );

EXTERN  WORD _CDECL_ PCXWriteGPIO(
    IN  PCX_HANDLE      PmMyProcess,
    IN  PGPIO_INFO      PmTabGpioInfo,
    IN  DWORD           PmTabSize );

EXTERN  WORD _CDECL_ PCXReadGPIO(
    IN  PCX_HANDLE      PmMyProcess,
 INOUT  PGPIO_INFO      PmTabGpioInfo,
    IN  DWORD           PmTabSize );

EXTERN  WORD _CDECL_ PCXWaitForGpioEvent(
    IN  PCX_HANDLE      PmMyProcess,
    IN  HANDLE          PmEvent );

EXTERN  BOOLEAN _CDECL_ PCXIsGpioEventSet(
    IN  PCX_HANDLE      PmMyProcess,
   OUT  LPWORD          PmPBoardNumber );

// ***************************************************************************

EXTERN  WORD _CDECL_ PCXGetBoardLogicalNumberEx(
    IN  WORD         PmMaxPresentBoard,
    IN  WORD         PmMaxMissingBoard,
   OUT  LPWORD       PmpPresentBoardLogicalNumTable,
   OUT  LPWORD       PmpMissingBoardLogicalNumTable,
   OUT  LPWORD       PmpActualPresentBoard,
   OUT  LPWORD       PmpActualMissingBoard,
   OUT  LPWORD       PmpPresentBoardNumTable,
   OUT  LPWORD       PmpMissingBoardNumTable );

EXTERN  WORD _CDECL_ PCXGetBoardLogicalNumber(
    IN  WORD         PmMaxPresentBoard,
    IN  WORD         PmMaxMissingBoard,
   OUT  LPWORD       PmpPresentBoardLogicalNumTable,
   OUT  LPWORD       PmpMissingBoardLogicalNumTable,
   OUT  LPWORD       PmpActualPresentBoard,
   OUT  LPWORD       PmpActualMissingBoard );

//*************************************
// New function for Uninitialisation
//*************************************
EXTERN  WORD _CDECL_ PCXUnInitialize(
    IN  PUNINIT_INFO PmUnInitInfo );

//*************************************

#ifdef __cplusplus
}
#endif

//}
#endif
