// ***************************************************************************
//
// COPYRIGHT 1996-1998 DIGIGRAM. ALL RIGHTS RESERVED
//
// DIGIGRAM
//
// ***************************************************************************
//
//   PcxAll_E.h
//
//   Project         : np driver
//                     Common file
//
//  Description      : Definitions that must be seen by the API users, the API
//                     and the driver.
//
//  Author(s)        : FG-PhG-FB-FS-DS-DPI-MQ
//
//  Last modification   : $Date: 6/04/06 15:15 $ by $Author: Mbr $
//
// ***************************************************************************


#ifndef _PCXALL_H_
//{
#define _PCXALL_H_

#ifdef DRIVER_WINNT // always defined even for 16 bit drivers
#ifndef VX_DRIVER
#define NP_DRIVER
#endif	// VX_DRIVER
#endif	// DRIVER_WINNT


#if (DBG || defined(_DEBUG))
#ifdef NP_DISPATCHER
#pragma message(">>> NP_DISPATCHER <<<")
#endif  // NP_DISPATCHER
#ifdef VX_DRIVER
#pragma message(">>> VX_DRIVER <<<")
#endif	// VX_DRIVER
#ifdef NP_DRIVER
#pragma message(">>> NP_DRIVER <<<")
#endif	// NP_DRIVER
#endif	// debug


// *******************************************************************
// Included files
// *******************************************************************

//*********************************************************************
// Constant definitions
//*********************************************************************

// See also constants defined in PcxDef_E.h

// Constants used in LEVEL_FEATURE_INFO.lfLevelType
// ************************************************
#define LEVEL_FEATURE_INPUT_LINE_MASK      0x00000001
#define LEVEL_FEATURE_INPUT_MICRO_MASK     0x00000002
#define LEVEL_FEATURE_CD_INPUT_MASK        0x00000004
#define LEVEL_FEATURE_OUTPUT_LINE_MASK     0x00010000

// ciMiscFeatures in CARD_FEATURES_INFO
// ************************************
#define SMPTE_PRESENT_MASK                 0x01
#define PROGRAMMABLE_CLOCK_PRESENT_MASK    0x02
#define MIDI_PRESENT_MASK                  0x04
#define INTERSYNC_PRESENT_MASK             0x08
#define DIRECT_MEMORY_ACCESS_PRESENT_MASK  0x10
#define VIDEO_CLOCK_PRESENT_MASK           0x20
#define COBRANET_CLOCK_PRESENT_MASK        0x40
#define GPIO_PRESENT_MASK				   0x80

// ciMiscFeatures2 in CARD_FEATURES_INFO
// ************************************

// RS232, RS422,IrdA, etc...
#define COM_PRESENT_MASK		                    0x01
#define AES3_ON_INTERNAL_CONNECTOR_PRESENT_MASK     0x02
#define VSYNC_ON_INTERNAL_CONNECTOR_PRESENT_MASK    0x04
#define VIRTUAL_DEVICE_CAPABILITY_PRESENT_MASK      0x08
#define IS_VAR_BOARD_MASK                           0x10
#define ETHERSOUND_CLOCK_PRESENT_MASK               0x20

// Bit masks used for ciLineConnections (CARD_FEATURES_INFO)
// *********************************************************
#define ANALOG_OUTPUTS_BALANCED     0x01
#define ANALOG_OUTPUTS_UNBALANCED   0x02
#define ANALOG_INPUTS_BALANCED      0x04
#define ANALOG_INPUTS_UNBALANCED    0x08
#define DIGITAL_OUTPUTS_BALANCED    0x10
#define DIGITAL_OUTPUTS_UNBALANCED  0x20
#define DIGITAL_INPUTS_BALANCED     0x40
#define DIGITAL_INPUTS_UNBALANCED   0x80
#define COBRANET_OUTPUTS_BALANCED   0x100
#define COBRANET_OUTPUTS_UNBALANCED 0x200
#define COBRANET_INPUTS_BALANCED    0x400
#define COBRANET_INPUTS_UNBALANCED  0x800
#define ETHERSOUND_OUTPUTS_BALANCED 0x1000
#define ETHERSOUND_INPUTS_BALANCED  0x2000

// Values for dfDspState (DSP_FEATURES_INFO) except DSP soft numbers
// *****************************************************************
#define STATE_DSP_EXCEPTION         0xFF
#define STATE_DSP_FREE              0x00
// .. or DSP softs numbers when DSP is loaded
// ******************************************
#define DSP_FIRST_SOFT              1
#define DSP_LAST_SOFT               0x7F

// Values for dfFeaturesEx (DSP_FEATURES_INFO)
// *****************************************************************
#define DHS_PRESENT_MASK            0x04

// Policy for loading/unloading DSP software
// Values for dtlLoadPolicy (DSP_TO_LOAD_INFO)
// **************************************************
#define DSP_FAST_REALLOC            ((BYTE) 0)
#define DSP_FORCE_RELOAD            ((BYTE) 1)

// DSP capabilities definition bits:
// Mask values for dtlDspFeatures (DSP_TO_LOAD_INFO)
// **************************************************
#define DSP_CAN_PLAY_MASK             0x00000001
#define DSP_CAN_RECORD_MASK           0x00000002
#define DSP_CAN_OFFLINE_MASK          0x00000004
#define DSP_CAN_TIME_CODE_MASK        0x00000008
#define DSP_CAN_PLUGIN_ENCODER_MASK   0x00000100
#define DSP_CAN_PLUGIN_DECODER_MASK   0x00000200
#define DSP_CAN_PLUGIN_EFFECT_MASK    0x00000400

// DSP play/record formats capabilities:
// Mask values for dtlPlayFormats or dtlRecordFormats (DSP_TO_LOAD_INFO)
// values are the same as those used by sdFormat in STREAM_DECL_INFO
// **********************************************************************
#define DSP_CAN_PR_MPEGI_MASK               STREAM_FMT_MPEGI
#define DSP_CAN_PR_MPEGII_MASK              STREAM_FMT_MPEGII
#define DSP_CAN_PR_MPEGIII_MASK             STREAM_FMT_MPEGIII
#define DSP_CAN_PR_LIN_8_MASK               STREAM_FMT_LIN_8
#define DSP_CAN_PR_LIN_16_MASK              STREAM_FMT_LIN_16
#define DSP_CAN_PR_LIN_24_MASK              STREAM_FMT_LIN_24
#define DSP_CAN_PR_LIN_32_MASK              STREAM_FMT_LIN_32
#define DSP_CAN_PR_GSM_MASK                 STREAM_FMT_GSM
#define DSP_CAN_PR_CELP_MASK                STREAM_FMT_CELP
#define DSP_CAN_PR_AAC_MASK                 STREAM_FMT_AAC
#define DSP_CAN_PR_WMA_MASK                 STREAM_FMT_WMA
#define DSP_CAN_PR_LIN_MULTICHANNEL_MASK    STREAM_FMT_LIN_MULTICHANNEL

// DSP play effects capabilities:
// Mask values for dtlPlayEffects  (DSP_TO_LOAD_INFO)

// **********************************************************************
#define DSP_CAN_TIME_STRETCH_MASK           0x00000001
#define DSP_CAN_PITCH_SHIFT_MASK            0x00000002
#define DSP_CAN_FREQUENCY_CONV_MASK         0x00000004
#define DSP_CAN_SCRUB_MASK                  0x00000008
#define DSP_CAN_EQ_MPEG_MASK                0x00000010
#define DSP_CAN_STREAM_FREQUENCY_CONV_MASK  0x00000020
#define DSP_CAN_MAXIMIZER_MASK              0x00000040
#define DSP_CAN_EQUALIZER_MASK              0x00000080
#define DSP_CAN_STREAM_EQ_LINEAR_MASK       0x00000100
#define DSP_CAN_STREAM_EQ_MPEG_MASK         DSP_CAN_EQ_MPEG_MASK

// DSP record effects capabilities:
// Mask values for dtlRecordEffects (DSP_TO_LOAD_INFO)
// **********************************************************************

#define DSP_CAN_IN_AUDIO_EQ_MASK            DSP_CAN_EQUALIZER_MASK
#define DSP_CAN_IN_AUDIO_MX_MASK            DSP_CAN_MAXIMIZER_MASK


// Host capabilities definition bits:
// Mask values for hfHostFeatures (HOST_FORMAT_INFO)
// **************************************************
#define HOST_CAN_PLAY_MASK            0x00000001
#define HOST_CAN_RECORD_MASK          0x00000002

// Host play/record formats capabilities:
// Mask values for hfPlayFormats or hfRecordFormats (HOST_FORMAT_INFO)
// **********************************************************************
#define HOST_CAN_PR_MPEGIII_MASK      HOST_MPEGIII
#define HOST_CAN_PR_AAC_MASK          HOST_AAC

/**
* Digigram DSP Effects IDs (PCX_EFFECT_HANDLE)
* On VX/PCX boards, the following defines must match the effect IDs in the DSP code
*
*	VAL_SIG_CF		equ 1
*	VAL_SIG_TS		equ 2
*	VAL_SIG_PS		equ 3
*	VAL_SIG_SC		equ 4
*	VAL_SIG_EQ		equ 5
*	VAL_SIG_CF2		equ 6
*	VAL_SIG_MX		equ 7
*	VAL_SIG_EQ_PIPE	equ 8
*	@see alldsp\common.inc
*/
#define EFFECT_NONE                   ((PCX_EFFECT_HANDLE) 0x0)
#define EFFECT_FREQUENCY_CHANGE       ((PCX_EFFECT_HANDLE) 0x1)
#define EFFECT_TIME_STRETCHING        ((PCX_EFFECT_HANDLE) 0x2)
#define EFFECT_PITCH_SHIFTING         ((PCX_EFFECT_HANDLE) 0x3)
#define EFFECT_SCRUB                  ((PCX_EFFECT_HANDLE) 0x4)
#define EFFECT_EQUALIZATION					((PCX_EFFECT_HANDLE) 0x5)
#define EFFECT_EQUALIZATION_STREAM_MPEG		((PCX_EFFECT_HANDLE) 0x5)
#define EFFECT_CF2							((PCX_EFFECT_HANDLE) 0x6)
#define EFFECT_MAXIMIZER					((PCX_EFFECT_HANDLE) 0x7)
#define EFFECT_EQUALIZATION_PIPE			((PCX_EFFECT_HANDLE) 0x8)
#define EFFECT_EQUALIZATION_STREAM_LINEAR	((PCX_EFFECT_HANDLE) 0x9)
#define EFFECT_COMPRESSOR_LIMITER           ((PCX_EFFECT_HANDLE) 0xa)
#define EFFECT_ALL_MASK               0x1f  // may grow up to 15 bits.

/**
* Digigram AUDIO Effects IDs (PCX_EFFECT_HANDLE)
*/
#define HW_EFFECT_NONE                 ((PCX_EFFECT_HANDLE) 0x80) // 16th bit
#define HW_EFFECT_MAXIMIZER            (HW_EFFECT_NONE | EFFECT_MAXIMIZER)
#define HW_EFFECT_EQUALIZER            (HW_EFFECT_NONE | EFFECT_EQUALIZATION_PIPE)
#define HW_EFFECT_COMPRESSOR_LIMITER   (HW_EFFECT_NONE | EFFECT_COMPRESSOR_LIMITER)


#define EFFECT_CMD_SET  		0 // default
#define EFFECT_CMD_GET   		1 //
#define EFFECT_CMD_REMOVE		2 // remove from stack

// constants used to add or remove external effect
// **************************************************
#define ADD_EXTERNAL 0x00
#define SUP_EXTERNAL 0x01

// Digigram Encoder/Decoder IDs (PCX_CODEC_HANDLE)
// *********************************************************
#define CODEC_NONE                    ((PCX_CODEC_HANDLE) 0)
#define CODEC_LINEAR                  ((PCX_CODEC_HANDLE) 1)
#define CODEC_MPEG                    ((PCX_CODEC_HANDLE) 2)
#define CODEC_GSM                     ((PCX_CODEC_HANDLE) 3)
#define CODEC_AAC                     ((PCX_CODEC_HANDLE) 4)
#define CODEC_WMA					  ((PCX_CODEC_HANDLE) 5)

// Clock parameters (EXTERNAL_CLOCK_INFO, CLOCK_INFO
// PROGRAMMABLE_CLOCK_INFO)
// ***********************************************************
#define CLOCK_TYPE_NONE               0x00 // ckType
#define CLOCK_TYPE_INTERNAL           0x01 // ckType
#define CLOCK_TYPE_SYNCHRO_CARD       0x02 // ecType
#define CLOCK_TYPE_UER_SYNCHRO        0x03 // ecType
#define CLOCK_TYPE_WORD_CLOCK         0x04 // ecType
#define CLOCK_TYPE_PROGRAMMABLE_CLOCK 0x05 //
#define CLOCK_TYPE_VIDEO              0x06
#define CLOCK_TYPE_COBRANET           0x07
#define CLOCK_TYPE_AES3_ON_INTERNAL_CONNECTOR   0x08
#define CLOCK_TYPE_ETHERSOUND         0x09

// Misc info for CLOCK_INFO (champ ckMisc)
#define CLOCK_MISC_SUPERWORDCLOCK_MASK 0x0001

// SRC info for CLOCK_INFO (param ckStatusFlags)
#define SRC_IN_USE                      0x01
#define SRC_AVAILABLE                   0x02

// Indexes for addressing CLOCK_INFO table
// in PCXGetBoardExternalClock
// ***************************************
#define UER_CLOCK_INDEX                 0
#define WCL_CLOCK_INDEX                 1
#define VIDEO_CLOCK_INDEX               2
#define ETHERSOUND_CLOCK_INDEX          3

// PipeManagement definition bits (PIPE_DECL_INFO) (not all cards support some of these)
// ***********************************************
#define P_UNDERRUN_SKIP_SOUND_MASK      0x01
#define P_PREPARE_FOR_MPEG3_MASK        0x02
#define P_DO_NOT_RESET_ANALOG_LEVELS    0x04
#define P_ALLOW_UNDER_ALLOCATION_MASK   0x08
#define P_DATA_MODE_MASK                0x10	/** no digital gains are applied, no fade in/out either.*/
#define P_UNDERRUN_SKIP_ALL_MASK		0x20	/** this allows for silent underrun compensation, if enabled.*/

/** in PCXnp classical mode:
* a pipe may need to mix L1 or L2 streams to running PCM streams.
* Currently, 1152 samples must have been played for the next burst to happen.
* This leads to poor responsivity on linear streams with small buffers.
* DirectSound may now allocate a pipe that issues burst for less then 1152 (in fact 128) samples,
* by setting the following flag.
* In global low latency mode (registry key), no mpeg mixing is alowed, and this flag is ignored.
*/
#define P_PCM_ONLY_MASK	 0x40	/** on np:	this tells the dsp to issue bursts for less then 1152 samples (256)*/
#define P_RESET_TIMECODE_REFERENCE_ONSTART 	 0x80	/** on HR 1.40 and later, leads to a LTC ref counter reset on regular PCXStartPipe.*/

#ifdef VX_DRIVER
#define BIT_SKIP_SOUND					0x08	// bit 3
#define BIT_DATA_MODE					0x10	// bit 4
#endif

// Start/Pause condition for pipes (PCXStartPipe, PCXPausePipe)
// ************************************************************
#define START_PAUSE_IMMEDIATE           0
#define START_PAUSE_ON_SYNCHRO          1

// Out pipe set parameters (OUT_PIPE_SET_PARAM_INFO)
// *************************************************
// Bits to validate parameters (opspValidationMask1)
#define OUT_PIPE_SET_PARAM_UER_MASK         0x00000001
#define OUT_PIPE_SET_PARAM_MPEG_MASK        0x00000002
#define OUT_PIPE_SET_PARAM_BACKWARD_MASK    0x00000004
#define OUT_PIPE_SET_PARAM_UER_EXTRA_MASK   0x00000008

// In pipe set parameters (IN_PIPE_SET_PARAM_INFO)
// ***********************************************
// Bits to validate parameters (ipspValidationMask1)
#define IN_PIPE_SET_PARAM_SOURCE_MASK          0x00000001
#define IN_PIPE_SET_PARAM_PROPERTIES_MASK      0x00000002	// deprecated
#define IN_PIPE_SET_PARAM_MIC_48V_MASK         0x00000002
#define IN_PIPE_SET_PARAM_UER_SRC_MASK         0x00000004

// Out pipe set effects (OUT_PIPE_SET_EFFECT_INFO)
// ************************************************
// Values for parameter mode (opseMode)
#define PARM_MODE_DEFAULT                   0
#define PARM_MODE_EXTENDED                  1	/**< may be used to specify that an EFFECT_EXTENDED_INFO is passed for the current effect.*/


//     Parameter modes for scrub
#define PARM_SC_MODE_SPEED_FACTOR           0

//     Parameter modes for frequency change
#define PARM_CF_MODE_CODE                   0

//     Parameter modes for time-stretching
#define PARM_TS_MODE_SPEED_FACTOR           0

//     Parameter modes for pitch-shifting
#define PARM_PS_MODE_PITCH_FACTOR           0


// Filter types for Equalizer effect
#define EQUALIZER_LOWPASS_FILTER            1
#define EQUALIZER_BELL_FILTER               2
#define EQUALIZER_HIGHPASS_FILTER           3


// Out stream set levels (OUT_STREAM_SET_LEVEL_INFO, OUT_STREAM_SET_LCURVE_INFO)
// *************************************************
// Bits to validate levels (osslValidationMask1, osnslValidationMask1 )
#define OUT_STREAM_SET_LEVEL_LEFT_AUDIO1    0x00000001
#define OUT_STREAM_SET_LEVEL_LEFT_AUDIO2    0x00000002
#define OUT_STREAM_SET_LEVEL_RIGHT_AUDIO1   0x00000004
#define OUT_STREAM_SET_LEVEL_RIGHT_AUDIO2   0x00000008
#define OUT_STREAM_SET_LEVEL_STREAM_1       0x00000010
#define OUT_STREAM_SET_LEVEL_STREAM_2       0x00000020
#define OUT_STREAM_SET_LEVEL_MUTE_1         0x00000040
#define OUT_STREAM_SET_LEVEL_MUTE_2         0x00000080

// Maximum number of spots in a level curve
// (i.e. max OUT_STREAM_SET_LEVEL_INFO entries)
// ********************************************
#define MAX_CURVE_LEVELS                    28

// Out stream extra parameters (OUT_STREAM_EPARAM_INFO)
// ****************************************************
// Bits to validate levels (osseValidationMask1)
#define OUT_STREAM_SET_SYNC_LEVEL1_MASK     0x00000001
// Values for osseSyncLevelSettings
#define OUT_STREAM_SET_SYNC_LEVEL1_OFF      0x0001
#define OUT_STREAM_SET_SYNC_LEVEL1_ON       0x0000

// Out audio set levels  (OUT_AUDIO_SET_LEVEL_INFO)
// ************************************************
// Bits to validate levels (oaslValidationMask1)
#define OUT_AUDIO_SET_LEVEL_ANALOG_MASK     0x00000001
#define OUT_AUDIO_SET_LEVEL_DIGITAL_MASK    0x00000002
#define OUT_AUDIO_SET_LEVEL_MONITOR_MASK    0x00000004
#define OUT_AUDIO_SET_LEVEL_MUTE_MASK       0x00000008
#define OUT_AUDIO_SET_LEVEL_MUTE_M1_MASK    0x00000010
#define OUT_AUDIO_SET_LEVEL_MUTE_M2_MASK    0x00000020

// osnlStep in OUT_STREAM_SET_LCURVE_INFO
// **************************************
#define MAX_LCURVE_STEP                     0x00003fff

// In audio set levels  (IN_AUDIO_SET_LEVEL_INFO)
// ************************************************
// Bits to validate levels (iaslValidationMask1)
#define IN_AUDIO_SET_LEVEL_ANALOG_MASK      0x00000001
#define IN_AUDIO_SET_LEVEL_DIGITAL_MASK     0x00000002
#define IN_AUDIO_SET_LEVEL_MICRO_MASK       0x00000004
#define IN_AUDIO_SET_LEVEL_MUTE_ANALOG_MASK 0x00000008
#define IN_AUDIO_SET_LEVEL_MUTE_MICRO_MASK  0x00000010

// In audio set parameters  (IN_AUDIO_SET_PARAM_INFO)
// ************************************************
// Bits to validate parameters (iaspValidationMask)
#define IN_AUDIO_SET_PARAM_MIC48V_MASK      0x00000001

// Values for tiDelayed field in TIME_INFO structure,
// and for pbPause field in PLAY_BUFFER_INFO structure
// *************************************************
#define BIT_DIFFERED_COMMAND                0
#define BIT_NOTIFIED_COMMAND                1
#define BIT_TIME_RELATIVE_TO_BUFFER         2
#define BIT_RESERVED                        3
#define BIT_STREAM_TIME                     4
#define BIT_CANCELLED_COMMAND               5
#define BIT_AFTER_BUFFER_TIME               6

#define DIFFERED_COMMAND_MASK               ( (BYTE)(1<<BIT_DIFFERED_COMMAND) )
#define NOTIFIED_COMMAND_MASK               ( (BYTE)(1<<BIT_NOTIFIED_COMMAND) | DIFFERED_COMMAND_MASK )
#define TIME_RELATIVE_TO_BUFFER_MASK        ( (BYTE)(1<<BIT_TIME_RELATIVE_TO_BUFFER) | DIFFERED_COMMAND_MASK )
#define CANCELLED_COMMAND_MASK              ( (BYTE)(1<<BIT_CANCELLED_COMMAND) | DIFFERED_COMMAND_MASK )

#define PIPE_TIME_MASK                      ( 0x0000 | DIFFERED_COMMAND_MASK )
#define STREAM_TIME_MASK                    ( 0x0010 | DIFFERED_COMMAND_MASK )
#define AFTER_BUFFER_TIME_MASK              ( 0x0040 | DIFFERED_COMMAND_MASK )
#define RESERVED_TIME_MASK                  ( 0x0050 | DIFFERED_COMMAND_MASK )   // en attendant une nouvelle valeur

// Notifications (NOTIFY_INFO)
// ************************************************
// Command codes (niCommandCode)
#define ALL_CMDS_NOTIFIED                   0x0000  // reserved
#define START_STREAM_NOTIFIED               0x0001
#define PAUSE_STREAM_NOTIFIED               0x0002
#define OUT_STREAM_LEVEL_NOTIFIED           0x0003
#define OUT_STREAM_PARAMETER_NOTIFIED       0x0004  // left for backward compatibility
#define OUT_STREAM_FORMAT_NOTIFIED          0x0004
#define PIPE_TIME_NOTIFIED                  0x0005
#define OUT_AUDIO_LEVEL_NOTIFIED            0x0006
#define OUT_STREAM_LEVEL_CURVE_NOTIFIED     0x0007
#define STREAM_TIME_NOTIFIED                0x0008
#define OUT_STREAM_EXTRAPARAMETER_NOTIFIED  0x0009
#define BUFFER_TAG_NOTIFIED                 0x000a
#define UNKNOWN_COMMAND_NOTIFIED            0xffff

// Values for uer syncro (ckSync in CLOCK_INFO)
// ********************************************
#define UER_SYNC_UNKNOWN                    0
#define UER_NO_SYNC                         1
#define UER_SYNC_PRESENT                    2

// Values for either pipe or stream states
//  (PmState for PCXGetPipeState(..), ssStart in STREAM_STATE_INFO)
// ****************************************************************
#define STATE_STARTED                       0x01
#define STATE_PAUSED                        0x00

// Values for stream channels
// (ssfChannels in SOUND_FORMAT_INFO)
// ***********************************
#define CHANNELS_MONO                       1
#define CHANNELS_STEREO                     2

// Values for linear format
// *************************
// sample endianness (sfLinearEndianNess in SOUND_FORMAT_INFO)
#define LINEAR_BIG_ENDIAN                   1
#define LINEAR_LITTLE_ENDIAN                2
// sample size (sfLinearBits in SOUND_FORMAT_INFO)
#define LINEAR_8                            8
#define LINEAR_16                           16
#define LINEAR_24                           24

// Values for MPEG joint stereo mode
// (sfMpegMode in SOUND_FORMAT_INFO)
// *****************************************
#define MPEG_MODE_STEREO                    0
#define MPEG_MODE_JOINT_STEREO              1
#define MPEG_MODE_DUAL_CHANNEL              2
#define MPEG_MODE_MONO                      3

// Values for MPEG joint stereo mode
// (sfMpegModeExtension in SOUND_FORMAT_INFO)
// ******************************************
#define MPEG_JSTEREO_MODE_AUTO              0
// intensity stereo for sub-bands 4-31
#define MPEG_JSTEREO_MODE_1                 1
// intensity stereo for sub-bands 8-31
#define MPEG_JSTEREO_MODE_2                 2
// intensity stereo for sub-bands 12-31
#define MPEG_JSTEREO_MODE_3                 3
// intensity stereo for sub-bands 16-31
#define MPEG_JSTEREO_MODE_4                 4

// Values for MPEG Layer III joint stereo mode
// (sfMpegModeExtension in SOUND_FORMAT_INFO)
// ******************************************
// no intensity stereo, no MS stereo
#define MPEG_LIII_JSTEREO_MODE_STEREO       5
// intensity stereo, no MS stereo
#define MPEG_LIII_JSTEREO_MODE_INTENSITY    6
// no intensity stereo, MS stereo
#define MPEG_JSTEREO_MODE_MSSTEREO          7
//  both intensity stereo and MS stereo
#define MPEG_JSTEREO_MODE_MS_AND_INTENSITY  8

// Values for MPEG pre-emphasis
// (ssfPreEmphasis in SOUND_FORMAT_INFO)
// **************************************
#define MPEG_PREEMP_NONE                    0
#define MPEG_PREEMP_50_15                   1
#define MPEG_PREEMP_J17                     3

// Values for GSM sample endianness
// (sfGsmEndianNess in SOUND_FORMAT_INFO)
// **************************************
#define GSM_BIG_ENDIAN                      1
#define GSM_LITTLE_ENDIAN                   2
#define GSM_MSFT                            3

// Values for multichannel support
// **************************************
// best would be to include those from ksmedia.h
#ifndef SPEAKER_FRONT_LEFT
#define SPEAKER_FRONT_LEFT             	0x1
#define SPEAKER_FRONT_RIGHT             0x2
#define SPEAKER_FRONT_CENTER            0x4
#define SPEAKER_LOW_FREQUENCY          	0x8
#define SPEAKER_BACK_LEFT               0x10
#define SPEAKER_BACK_RIGHT              0x20
#define SPEAKER_FRONT_LEFT_OF_CENTER   	0x40
#define SPEAKER_FRONT_RIGHT_OF_CENTER 	0x80
#define SPEAKER_BACK_CENTER             0x100
#define SPEAKER_SIDE_LEFT               0x200
#define SPEAKER_SIDE_RIGHT              0x400
#define SPEAKER_TOP_CENTER              0x800
#define SPEAKER_TOP_FRONT_LEFT          0x1000
#define SPEAKER_TOP_FRONT_CENTER        0x2000
#define SPEAKER_TOP_FRONT_RIGHT        	0x4000
#define SPEAKER_TOP_BACK_LEFT          	0x8000
#define SPEAKER_TOP_BACK_CENTER       	0x10000
#define SPEAKER_TOP_BACK_RIGHT         	0x20000
#endif

// stereo downmix extension
#ifndef SPEAKER_STEREO_LEFT
#define SPEAKER_STEREO_LEFT     0x20000000
#define SPEAKER_STEREO_RIGHT    0x40000000
#endif

#define DIGIGRAM_5POINT1         (SPEAKER_FRONT_LEFT | SPEAKER_FRONT_RIGHT | \
                                  SPEAKER_FRONT_CENTER | SPEAKER_LOW_FREQUENCY | \
                                  SPEAKER_BACK_LEFT  | SPEAKER_BACK_RIGHT)

#define DIGIGRAM_7POINT1         (DIGIGRAM_5POINT1|\
                                  SPEAKER_FRONT_LEFT_OF_CENTER | \
   				                  SPEAKER_FRONT_RIGHT_OF_CENTER)

#define DIGIGRAM_5POINT1_PLUS2   (DIGIGRAM_5POINT1 | \
                                  SPEAKER_STEREO_LEFT | SPEAKER_STEREO_RIGHT)

#define DIGIGRAM_7POINT1_PLUS2   (DIGIGRAM_7POINT1 | \
                                  SPEAKER_STEREO_LEFT | SPEAKER_STEREO_RIGHT)

// Values for pbHint field in PLAY_BUFFER_INFO structure
// *****************************************************
#define PBHINT_NO_HINT                      ((BYTE) 0)
#define PBHINT_ENDS_ON_FRAME_BOUNDARY       ((BYTE) 1)

// Values for pbMisc field in PLAY_BUFFER_INFO structure
// Values for rbMisc field in RECORD_BUFFER_INFO structure
// *****************************************************
#define BUFFER_MISC_NO_INFO                 0
#define BUFFER_MISC_CIRCULAR_BUFFER         0x10000000

// Values for PCCARD event
// (PmPCCARDEvent in PCXIsPCCARDEventSet)
// **************************************
#define PCCARD_EVENT_NOTHING                0
#define PCCARD_EVENT_NEW_BOARD              1
#define PCCARD_EVENT_BOARD_REMOVED          2
#define PCCARD_EVENT_NO_SUPPORT             3

#define BOARD_EVENT_NOTHING                0
#define BOARD_EVENT_NEW_BOARD              1
#define BOARD_EVENT_BOARD_REMOVED          2
#define BOARD_EVENT_NO_SUPPORT             3

// Values for meBandNumber.
// ************************
#define EQUAL_BASS_BAND         0
#define EQUAL_MEDIUM_BAND       1
#define EQUAL_TREBLE_BAND       2
#define EQUAL_MAX_BANDS         3					// number of MPEG_EQUAL_*_BAND
#define MPEG_EQUAL_BASS_BAND    EQUAL_BASS_BAND
#define MPEG_EQUAL_MEDIUM_BAND  EQUAL_MEDIUM_BAND
#define MPEG_EQUAL_TREBLE_BAND  EQUAL_TREBLE_BAND
#define MPEG_EQUAL_MAX_BANDS    EQUAL_MAX_BANDS		// number of MPEG_EQUAL_*_BAND

// Values for sfFrequencyQuality of _SOUND_FORMAT_INFO structure
// ************************
#define SRC_DISABLED                        0
#define SRC_QUALITY_STANDARD                128
/*
#define SRC_QUALITY_BELOW_STANDARD          (SRC_QUALITY_STANDARD - 1)
#define SRC_QUALITY_ABOVE_STANDARD          (SRC_QUALITY_STANDARD + 1)
#define SRC_QUALITY_LOWEST                  (SRC_QUALITY_STANDARD - 2)
#define SRC_QUALITY_HIGHEST                 (SRC_QUALITY_STANDARD + 2)
*/

typedef DWORD PCX_HANDLE, *PPCX_HANDLE;

typedef WORD  PCX_EFFECT_HANDLE;

typedef WORD  PCX_CODEC_HANDLE;


#if (defined(VX_DRIVER)||defined(NP_DRIVER))
#ifdef macintosh
	#pragma options align=power
#else
	#pragma pack(1)
#endif
#endif


#if (defined(_WIN32)||defined(macintosh))
//{

    // PCX Time Reference type
    // -----------------------
    typedef DWORDLONG   PCX_TIME, * PPCX_TIME ;


    // PCX Time Code Reference type
    // ----------------------------
    typedef DWORDLONG   PCX_TIME_CODE, *PPCX_TIME_CODE;

//}
#else
//{

    // PCX Time Reference type
    // -----------------------
    typedef struct _PCX_TIME_
    {
        DWORD   pcxTimeLo ;
        DWORD   pcxTimeHi ;
    } PCX_TIME, * PPCX_TIME ;

    // PCX Time Code Reference type
    // ----------------------------
    typedef struct _PCX_TIME_CODE
    {
        DWORD   pcxTimeCodeLo ;
        DWORD   pcxTimeCodeHi ;
    } PCX_TIME_CODE, * PPCX_TIME_CODE ;


#if (defined(VX_DRIVER)||defined(NP_DRIVER))
#ifdef macintosh
	#pragma options align=reset
#else
	#pragma pack()
#endif
#endif


//}
#endif

// Values for PmComNumber (see PCX*Rs232).
// ***************************************
#define RS232_COM1                      0
#define RS232_COM2                      1
#define RS232_COM_MAX_NUMBER            2

// Values for RS232 event
// (PmPRs232Event in PCXIsRs232EventSet)
// (Must be a power of 2)
// **************************************
#define RS232_EVENT_NOTHING             0
#define RS232_EVENT_1                   1
#define RS232_EVENT_2                   2
#define RS232_EVENT_NO_SUPPORT          4

#define RS232_BEGIN_RECEIPT_EVENT       RS232_EVENT_1
#define RS232_END_RECEIPT_EVENT         RS232_EVENT_2

// Min and max values for riBaudValue.
// ***********************************
#define RS232_MIN_BAUD_VALUE            300
#define RS232_MAX_BAUD_VALUE            153600

// Values for riParity.
// ********************
#define RS232_PARITY_NONE               0
#define RS232_PARITY_EVEN               1
#define RS232_PARITY_ODD                2

// Values for riControlFlow.
// *************************
#define RS232_CONTROL_FLOW_NONE         0
#define RS232_CONTROL_FLOW_HARD         1
#define RS232_CONTROL_FLOW_XON_XOFF     2

// Values for PGIO types
// *********************
#define GPIO_READ_ACCESS                1   // GPIO can be opened for read
#define GPIO_WRITE_ACCESS               2   // GPIO can be opened for write
#define GPIO_FULLDUPLEX_ACCESS          (GPIO_READ_ACCESS | GPIO_WRITE_ACCESS)  // GPIO can be opened for simultaneous read and write
#define GPIO_PROGRAMMABLE_ACCESS        4   // GPIO can be opened for read or write but not simultaneously

// VSync sources for sci_wSourceOfVSync of VSYNC_SOURCE_INFO structure
// *******************************************************************
#define VSYNC_FROM_INTERNAL_CONNECTOR   1

// Time unit for Get and Set VSyncNumber
// *******************************************************************
#define VSYNC_TIME_UNIT_TICKS           0
#define VSYNC_TIME_UNIT_MICRO_SECOND    1
#define VSYNC_TIME_UNIT_INVALID         2
//}
#endif

