/**
*	Copyright (C) 2006 DIGIGRAM S.A.
*
*	@file	LXES_registers.h
*	@brief	offsets and values of the PCI mapped registers for LX6464ES
*/

#if !defined(AFX_PCIESDEFINE_H)
#define AFX_PCIESDEFINE_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define Reg_CSM				0x400
#define Reg_CSM_MR			0x00000002
#define Reg_CSM_MC			0x00000001
#define REG_CRM_NUMBER		12
#define Reg_CRM1			0x401
#define Reg_CRM2			0x402
#define Reg_CRM3			0x403
#define Reg_CRM4			0x404
#define Reg_CRM5			0x405
#define Reg_CRM6			0x406
#define Reg_CRM7			0x407
#define Reg_CRM8			0x408
#define Reg_CRM9			0x409
#define Reg_CRM10			0x40a
#define Reg_CRM11			0x40b
#define Reg_CRM12			0x40c

#define Reg_ICR				0x410
#define Reg_CVR				0x411
#define Reg_ISR				0x412
#define Reg_RXHTXH			0x413
#define Reg_RXMTXM			0x414
#define Reg_RHLTXL			0x415
#define Reg_RESETDSP		0x416

#define Reg_CSUF			0x420
// write
#define Reg_CSUF_TMS0		 0x00000001
#define Reg_CSUF_TDI0		 0x00000002
#define Reg_CSUF_V0			 0x00000004
#define Reg_CSUF_TMS1		 0x00000008
#define Reg_CSUF_TDI1		 0x00000010
#define Reg_CSUF_V1			 0x00000020
#define Reg_CSUF_TMS2		 0x00000040
#define Reg_CSUF_TDI2		 0x00000080
#define Reg_CSUF_V2			 0x00000100
#define Reg_CSUF_TMS3		 0x00000200
#define Reg_CSUF_TDI3		 0x00000400
#define Reg_CSUF_V3			 0x00000800
#define Reg_CSUF_TMS4		 0x00001000
#define Reg_CSUF_TDI4		 0x00002000
#define Reg_CSUF_V4			 0x00004000
#define Reg_CSUF_ENABLE_JTAG 0x80000000
// read
#define Reg_CSUF_TDO0				0x00000001
#define Reg_CSUF_TDO1				0x00000002
#define Reg_CSUF_TDO2				0x00000004
#define Reg_CSUF_TDO3				0x00000008
#define Reg_CSUF_TDO4				0x00000010
#define Reg_CSUF_B					0x00000020
#define Reg_CSUF_VERIFY_PATTERN		0x0000FFC0	// bit31 = enable jtag + bits 15..6 forced to 1
#define Reg_CSUF_VERIFY_LAST_WRITE	0x7FFF0000	
#define Reg_CSUF_VERIFY_LAST_WRITE_OFFSET 16	


#define Reg_CSES			0x430
#define Reg_CRESMSB			0x431
#define Reg_CRESLSB			0x432
#define Reg_ADMACESMSB		0x433
#define Reg_ADMACESLSB		0x434

#define Reg_CONFES			0x440

// ConfES : partie lue depuis le xilinx
//
#define CONFES_READ_PART_MASK	0x00070000
//
#define IOCR_OUTPUTS_OFFSET		 0		/**< (rw) offset for the number of OUTs in the ConfES register.		*/
#define IOCR_INPUTS_OFFSET		 8		/**< (rw) offset for the number of INs in the ConfES register.		*/
#define INTERPRETER_VERS_OFFSET	16		/**< (ro) offset for ES command interpreter version info.			*/
#define INTERPRETER_VERS_MASK	0x07	/**< bits 16/17/18 give the interpreter version, amongst the following values.*/
#define		INTERPRETER_V2		0		/**< V1/V2 EtherSound, or early V3 prototypes .*/		
#define		INTERPRETER_ES100	1		/**< V3 EtherSound, ES100. */
//#define	INTERPRETER_ESGIGA	2		


// ConfES : partie ecrite a partir des info dans la registry
//
#define CONFES_WRITE_PART_MASK	0x00F80000
//
#define FREQ_RATIO_OFFSET		19		/**< (rw) offset for frequency ratio in the ConfES register.			*/
#define MAC_PROG_SET_BIT		23		/**< (rw) MAC PROG bit.			*/
#define		FREQ_RATIO_SINGLE_MODE	0x01	/**< value for single mode frequency ratio: sample rate = frequency rate.		*/
#define		FREQ_RATIO_DUAL_MODE	0x02	/**< value for dual mode frequency ratio:	sample rate = frequency rate * 2.	*/
#define		FREQ_RATIO_QUAD_MODE	0x04	/**< value for quad mode frequency ratio:   sample rate = frequency rate * 4.	*/

#define Reg_CONFESIOMR		0x441

// IOMR (32Bits)
//
#define IMR_OFFSET				16				/**< MSWord = IMR, LSWord = OMR*/
#define OMR_OFFSET				0

// offsets in OMR or IMR words
#define IOMR_PID_OFFSET			0				/**< offset for PID field in IOMR : unused for now.	*/
#define	 IOMR_PID_DEFAULT		0x0				/**< default PID value = 0.	*/
#define IOMR_PTY_OFFSET	 		6				/**< offset for Packet Type in IOMR : always audio 0x01.	*/
#define	 IOMR_PTY_AUDIO			0x1				/**< packet type AUDIO.	*/
#define	 IOMR_PTY_DEFAULT		IOMR_PTY_AUDIO	/**< default value for Packet Type.	*/
#define IOMR_BNP_OFFSET	 		8				/**< bundle number offset.	*/
#define IOMR_IOD_OFFSET	 		15				/**< offset for the bundle direction bit : significant if a bi-dir end of loop is configured in the network.*/
#define  IOMR_IOD_UPSTREAM		0x1				/**< "upstream" value.*/
#define  IOMR_IOD_DOWNSTREAM	0x0				/**< "downstream" value.*/
#define  OMR_IOD_DEFAULT 	IOMR_IOD_UPSTREAM	/**< default value for OMR:IOD.*/
#define  IMR_IOD_DEFAULT 	IOMR_IOD_DOWNSTREAM	/**< default value for IMR:IOD.*/


#endif // !defined(AFX_PCIESDEFINE_H)

//*********************************************************************************
// $history:$
//
